/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.sass;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.css.prep.options.CssPrepOptions;
import org.netbeans.modules.css.prep.sass.Bundle;
import org.netbeans.modules.css.prep.util.ExternalExecutable;
import org.netbeans.modules.css.prep.util.ExternalExecutableValidator;
import org.netbeans.modules.css.prep.util.FileUtils;
import org.netbeans.modules.css.prep.util.InvalidExternalExecutableException;
import org.netbeans.modules.css.prep.util.UiUtils;
import org.netbeans.modules.css.prep.util.VersionOutputProcessorFactory;
import org.netbeans.modules.web.common.api.Version;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class SassExecutable {
    private static final Logger LOGGER = Logger.getLogger(SassExecutable.class.getName());
    public static final String EXECUTABLE_NAME = "sass";
    public static final String EXECUTABLE_LONG_NAME = "sass" + FileUtils.getScriptExtension(true, false);
    private static final String DEBUG_PARAM = "--debug-info";
    private static final String SOURCEMAP_PARAM = "--sourcemap";
    private static final String VERSION_PARAM = "--version";
    private static final String CACHE_LOCATION_PARAM = "--cache-location";
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final Version MINIMAL_VERSION_WITH_SOURCEMAP = Version.fromDottedNotationWithFallback((String)"3.3.0");
    static final String VERSION_PATTERN = "Sass\\s+(\\d+(\\.\\d+)*)";
    private static volatile Version version;
    private final String sassPath;

    private SassExecutable(String sassPath) {
        assert (sassPath != null);
        this.sassPath = sassPath;
    }

    public static SassExecutable getDefault() throws InvalidExternalExecutableException {
        String path = CssPrepOptions.getInstance().getSassPath();
        String error = SassExecutable.validate(path);
        if (error != null) {
            throw new InvalidExternalExecutableException(error);
        }
        return new SassExecutable(path);
    }

    public static String validate(String path) {
        return ExternalExecutableValidator.validateCommand(path, Bundle.Sass_executable_label());
    }

    public static void resetVersion() {
        version = null;
    }

    @CheckForNull
    private static Version getVersion() {
        block8: {
            assert (!EventQueue.isDispatchThread());
            if (version != null) {
                return version;
            }
            VersionOutputProcessorFactory versionOutputProcessorFactory = new VersionOutputProcessorFactory(VERSION_PATTERN);
            try {
                SassExecutable sassExecutable = SassExecutable.getDefault();
                sassExecutable.getExecutable("Sass version", TMP_DIR).additionalParameters(Collections.singletonList(VERSION_PARAM)).runAndWait(SassExecutable.getSilentDescriptor(), versionOutputProcessorFactory, "Detecting Sass version...");
                String detectedVersion = versionOutputProcessorFactory.getVersion();
                if (detectedVersion != null) {
                    version = Version.fromDottedNotationWithFallback((String)detectedVersion);
                    return version;
                }
            }
            catch (CancellationException ex) {
                assert (false);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (InvalidExternalExecutableException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return null;
    }

    @CheckForNull
    public void compile(File workDir, File source, final File target, List<String> compilerOptions) throws ExecutionException {
        assert (!EventQueue.isDispatchThread());
        assert (workDir.isDirectory()) : "Not directory given: " + workDir;
        assert (source.isFile()) : "Not file given: " + source;
        final File targetDir = target.getParentFile();
        if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
            LOGGER.log(Level.WARNING, "Cannot create directory {0}", targetDir);
            return;
        }
        try {
            this.getExecutable(Bundle.Sass_compile(), workDir).additionalParameters(this.getParameters(source, target, compilerOptions)).runAndWait(this.getDescriptor(new Runnable(){

                @Override
                public void run() {
                    FileUtil.refreshFor((File[])new File[]{targetDir});
                    UiUtils.refreshCssInBrowser(target);
                }
            }), "Compiling sass files...");
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            throw ex;
        }
    }

    private ExternalExecutable getExecutable(String title, File workDir) {
        return new ExternalExecutable(this.sassPath).workDir(workDir).displayName(title);
    }

    private ExecutionDescriptor getDescriptor(Runnable postTask) {
        return new ExecutionDescriptor().inputOutput(IOProvider.getDefault().getIO(Bundle.Sass_compile(), false)).inputVisible(false).frontWindow(false).frontWindowOnError(CssPrepOptions.getInstance().getSassOutputOnError()).noReset(true).showProgress(true).postExecution(postTask);
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false);
    }

    private List<String> getParameters(File inputFile, File outputFile, List<String> compilerOptions) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(CACHE_LOCATION_PARAM);
        params.add(Places.getCacheSubdirectory((String)"sass-compiler").getAbsolutePath());
        boolean debug = CssPrepOptions.getInstance().getSassDebug();
        if (debug) {
            Version installedVersion = SassExecutable.getVersion();
            if (installedVersion != null && installedVersion.isAboveOrEqual(MINIMAL_VERSION_WITH_SOURCEMAP)) {
                params.add(SOURCEMAP_PARAM);
            } else {
                params.add(DEBUG_PARAM);
            }
        }
        params.addAll(compilerOptions);
        params.add(inputFile.getAbsolutePath());
        params.add(outputFile.getAbsolutePath());
        return params;
    }
}

