/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.process;

import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.preferences.SassPreferences;
import org.netbeans.modules.css.prep.process.BaseProcessor;
import org.netbeans.modules.css.prep.sass.SassCssPreprocessor;
import org.netbeans.modules.css.prep.sass.SassExecutable;
import org.netbeans.modules.css.prep.util.InvalidExternalExecutableException;
import org.netbeans.modules.css.prep.util.UiUtils;
import org.netbeans.modules.css.prep.util.Warnings;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public final class SassProcessor
extends BaseProcessor {
    private static final Logger LOGGER = Logger.getLogger(SassProcessor.class.getName());

    public SassProcessor(SassCssPreprocessor cssPreprocessor) {
        super(cssPreprocessor);
    }

    @Override
    protected boolean isEnabledInternal(Project project) {
        return SassPreferences.getInstance().isEnabled(project);
    }

    @Override
    protected boolean isSupportedFile(FileObject fileObject) {
        return CssPreprocessorType.SASS.getFileExtensions().contains(fileObject.getExt());
    }

    @Override
    protected boolean isPartial(FileObject fileObject) {
        return fileObject.getName().startsWith("_");
    }

    @Override
    protected List<Pair<String, String>> getMappings(Project project) {
        return SassPreferences.getInstance().getMappings(project);
    }

    @Override
    protected String getCompilerOptions(Project project) {
        return SassPreferences.getInstance().getCompilerOptions(project);
    }

    @Override
    protected void compileInternal(Project project, File workDir, File source, File target, List<String> compilerOptions) {
        block3: {
            SassExecutable sass = this.getSass(project);
            if (sass == null) {
                return;
            }
            try {
                sass.compile(workDir, source, target, compilerOptions);
            }
            catch (ExecutionException ex) {
                if (!Warnings.showWarning(CssPreprocessorType.SASS)) break block3;
                UiUtils.processExecutionException(ex);
            }
        }
    }

    @CheckForNull
    private SassExecutable getSass(Project project) {
        try {
            return SassExecutable.getDefault();
        }
        catch (InvalidExternalExecutableException ex) {
            this.cssPreprocessor.fireProcessingErrorOccured(project, ex.getLocalizedMessage());
            return null;
        }
    }
}

