/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.preferences;

import java.util.List;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.prep.preferences.Bundle;
import org.netbeans.modules.css.prep.preferences.CssPreprocessorPreferencesValidator;
import org.netbeans.modules.css.prep.preferences.SassPreferences;
import org.netbeans.modules.css.prep.sass.SassExecutable;
import org.netbeans.modules.css.prep.util.CssPreprocessorUtils;
import org.netbeans.modules.css.prep.util.InvalidExternalExecutableException;
import org.netbeans.modules.css.prep.util.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public final class SassPreferencesValidator
implements CssPreprocessorPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    @Override
    public SassPreferencesValidator validate(Project project) {
        SassPreferences sassPreferences = SassPreferences.getInstance();
        return this.validateMappings(CssPreprocessorUtils.getWebRoot(project), sassPreferences.isEnabled(project), (List)sassPreferences.getMappings(project));
    }

    @Override
    public SassPreferencesValidator validateMappings(@NullAllowed FileObject root, boolean enabled, List<Pair<String, String>> mappings) {
        if (enabled) {
            this.result.merge(new CssPreprocessorUtils.MappingsValidator().validate(root, mappings).getResult());
        }
        return this;
    }

    @Override
    public SassPreferencesValidator validateExecutable(boolean enabled) {
        if (enabled) {
            try {
                SassExecutable.getDefault();
            }
            catch (InvalidExternalExecutableException ex) {
                this.result.addError(new ValidationResult.Message("sass.path", Bundle.SassPreferencesValidator_error_executable(ex.getLocalizedMessage())));
            }
        }
        return this;
    }
}

