/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.preferences;

import java.util.List;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.prep.less.LessExecutable;
import org.netbeans.modules.css.prep.preferences.Bundle;
import org.netbeans.modules.css.prep.preferences.CssPreprocessorPreferencesValidator;
import org.netbeans.modules.css.prep.preferences.LessPreferences;
import org.netbeans.modules.css.prep.util.CssPreprocessorUtils;
import org.netbeans.modules.css.prep.util.InvalidExternalExecutableException;
import org.netbeans.modules.css.prep.util.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class LessPreferencesValidator
implements CssPreprocessorPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    @Override
    public ValidationResult getResult() {
        return this.result;
    }

    @Override
    public LessPreferencesValidator validate(Project project) {
        LessPreferences lessPreferences = LessPreferences.getInstance();
        return this.validateMappings(CssPreprocessorUtils.getWebRoot(project), lessPreferences.isEnabled(project), (List)lessPreferences.getMappings(project));
    }

    @Override
    public LessPreferencesValidator validateMappings(@NullAllowed FileObject root, boolean enabled, List<Pair<String, String>> mappings) {
        if (enabled) {
            this.result.merge(new CssPreprocessorUtils.MappingsValidator().validate(root, mappings).getResult());
        }
        return this;
    }

    @Override
    public LessPreferencesValidator validateExecutable(boolean enabled) {
        if (enabled) {
            try {
                LessExecutable.getDefault();
            }
            catch (InvalidExternalExecutableException ex) {
                this.result.addError(new ValidationResult.Message("less.path", Bundle.LessPreferencesValidator_error_executable(ex.getLocalizedMessage())));
            }
        }
        return this;
    }
}

