/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.css.prep.less.LessExecutable;
import org.netbeans.modules.css.prep.sass.SassExecutable;
import org.netbeans.modules.css.prep.util.FileUtils;
import org.openide.util.NbPreferences;

public final class CssPrepOptions {
    private static final String PREFERENCES_PATH = "css-prep";
    public static final String SASS_PATH_PROPERTY = "SASS_PATH_PROPERTY";
    public static final String LESS_PATH_PROPERTY = "LESS_PATH_PROPERTY";
    private static final CssPrepOptions INSTANCE = new CssPrepOptions();
    private static final String SASS_PATH = "sass.path";
    private static final String SASS_OUTPUT_ON_ERROR = "sass.outputOnError";
    private static final String SASS_DEBUG = "sass.debug";
    private static final String LESS_PATH = "less.path";
    private static final String LESS_OUTPUT_ON_ERROR = "less.outputOnError";
    private static final String LESS_DEBUG = "less.debug";
    final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private volatile boolean sassSearched = false;
    private volatile boolean lessSearched = false;

    private CssPrepOptions() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String key = evt.getKey();
                String newValue = evt.getNewValue();
                if (CssPrepOptions.SASS_PATH.equals(key)) {
                    CssPrepOptions.this.propertyChangeSupport.firePropertyChange(CssPrepOptions.SASS_PATH_PROPERTY, null, newValue);
                } else if (CssPrepOptions.LESS_PATH.equals(key)) {
                    CssPrepOptions.this.propertyChangeSupport.firePropertyChange(CssPrepOptions.LESS_PATH_PROPERTY, null, newValue);
                }
            }
        });
    }

    public static CssPrepOptions getInstance() {
        return INSTANCE;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @CheckForNull
    public String getSassPath() {
        String path = this.getPreferences().get(SASS_PATH, null);
        if (path == null && !this.sassSearched) {
            this.sassSearched = true;
            List<String> paths = FileUtils.findFileOnUsersPath(SassExecutable.EXECUTABLE_LONG_NAME, "sass");
            if (!paths.isEmpty()) {
                path = paths.get(0);
                this.setSassPath(path);
            }
        }
        return path;
    }

    public void setSassPath(String sassPath) {
        this.getPreferences().put(SASS_PATH, sassPath);
    }

    public boolean getSassOutputOnError() {
        return this.getPreferences().getBoolean(SASS_OUTPUT_ON_ERROR, true);
    }

    public void setSassOutpuOnError(boolean outputOnError) {
        this.getPreferences().putBoolean(SASS_OUTPUT_ON_ERROR, outputOnError);
    }

    public boolean getSassDebug() {
        return this.getPreferences().getBoolean(SASS_DEBUG, true);
    }

    public void setSassDebug(boolean debug) {
        this.getPreferences().putBoolean(SASS_DEBUG, debug);
    }

    @CheckForNull
    public String getLessPath() {
        String path = this.getPreferences().get(LESS_PATH, null);
        if (path == null && !this.lessSearched) {
            this.lessSearched = true;
            List<String> paths = FileUtils.findFileOnUsersPath(LessExecutable.EXECUTABLE_LONG_NAME, "lessc");
            if (!paths.isEmpty()) {
                path = paths.get(0);
                this.setLessPath(path);
            }
        }
        return path;
    }

    public void setLessPath(String lessPath) {
        this.getPreferences().put(LESS_PATH, lessPath);
    }

    public boolean getLessOutputOnError() {
        return this.getPreferences().getBoolean(LESS_OUTPUT_ON_ERROR, true);
    }

    public void setLessOutpuOnError(boolean outputOnError) {
        this.getPreferences().putBoolean(LESS_OUTPUT_ON_ERROR, outputOnError);
    }

    public boolean getLessDebug() {
        return this.getPreferences().getBoolean(LESS_DEBUG, true);
    }

    public void setLessDebug(boolean debug) {
        this.getPreferences().putBoolean(LESS_DEBUG, debug);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(CssPrepOptions.class).node(PREFERENCES_PATH);
    }
}

