/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor.refactoring;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.prep.editor.refactoring.CPRenameRefactoringUI;
import org.netbeans.modules.css.prep.editor.refactoring.RefactoringElementContext;
import org.netbeans.modules.css.prep.editor.refactoring.WhereUsedUI;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class CPActionsImplementationProvider
extends ActionsImplementationProvider {
    private static final Logger LOG = Logger.getLogger(CPActionsImplementationProvider.class.getName());

    public boolean canRename(Lookup lookup) {
        return CPActionsImplementationProvider.canRefactor(lookup);
    }

    public void doRename(Lookup selectedNodes) {
        EditorCookie ec = (EditorCookie)selectedNodes.lookup(EditorCookie.class);
        if (CPActionsImplementationProvider.isFromEditor(ec)) {
            new TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(RefactoringElementContext context) {
                    return new CPRenameRefactoringUI(context);
                }
            }.run();
        }
    }

    public boolean canFindUsages(Lookup lookup) {
        return CPActionsImplementationProvider.canRefactor(lookup);
    }

    private static boolean canRefactor(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        return CPActionsImplementationProvider.isRefactorableEditorElement((Node)nodes.iterator().next());
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (CPActionsImplementationProvider.isFromEditor(ec)) {
            new TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(RefactoringElementContext context) {
                    return new WhereUsedUI(context);
                }
            }.run();
        }
    }

    private static boolean isRefactorableEditorElement(final Node node) {
        class Context {
            public int caret;
            public Document document;

            Context() {
            }
        }
        final Context context = (Context)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Context>(){

            public Context run() {
                EditorCookie ec = (EditorCookie)node.getLookup().lookup(EditorCookie.class);
                if (CPActionsImplementationProvider.isFromEditor(ec)) {
                    Context context = new Context();
                    context.document = ec.getDocument();
                    JEditorPane pane = ec.getOpenedPanes()[0];
                    context.caret = pane.getCaretPosition();
                    return context;
                }
                return null;
            }
        });
        if (context == null) {
            return false;
        }
        Source source = Source.create((Document)context.document);
        final AtomicBoolean res = new AtomicBoolean(false);
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){
                {
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    CssParserResult result;
                    org.netbeans.modules.css.lib.api.Node leaf;
                    ResultIterator cssRi = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                    if (cssRi != null && (leaf = NodeUtil.findNonTokenNodeAtOffset((org.netbeans.modules.css.lib.api.Node)(result = (CssParserResult)cssRi.getParserResult()).getParseTree(), (int)context.caret)) != null) {
                        switch (leaf.type()) {
                            case cp_variable: 
                            case cp_mixin_name: {
                                res.set(true);
                                break;
                            }
                            default: {
                                res.set(false);
                            }
                        }
                    }
                }
            });
            return res.get();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private static FileObject getFileObjectFromNode(Node node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    public static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private final Document document;
        private final int caretOffset;
        private final int selectionStart;
        private final int selectionEnd;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie ec) {
            JEditorPane textC = ec.getOpenedPanes()[0];
            this.document = textC.getDocument();
            this.caretOffset = textC.getCaretPosition();
            this.selectionStart = textC.getSelectionStart();
            this.selectionEnd = textC.getSelectionEnd();
        }

        public void run(ResultIterator ri) throws ParseException {
            CssParserResult result;
            ResultIterator cssri = WebUtils.getResultIterator((ResultIterator)ri, (String)"text/css");
            if (cssri != null && (result = (CssParserResult)cssri.getParserResult()).getParseTree() != null) {
                RefactoringElementContext context = new RefactoringElementContext(result, this.caretOffset, this.selectionStart, this.selectionEnd);
                this.ui = context.isRefactoringAllowed() ? this.createRefactoringUI(context) : null;
            }
        }

        @Override
        public final void run() {
            try {
                Source source = Source.create((Document)this.document);
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(CPActionsImplementationProvider.class, (String)"ERR_CannotRefactorLoc"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(RefactoringElementContext var1);
    }
}

