/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.prep.editor.CPType;
import org.netbeans.modules.css.prep.editor.model.CPElement;
import org.netbeans.modules.css.prep.editor.model.CPElementHandle;
import org.netbeans.modules.css.prep.editor.model.CPElementType;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public class CPModel {
    public static String topLevelSnapshotMimetype;
    private static final Collection<String> SASS_DIRECTIVES;
    private CPType cpType;
    private final Snapshot snapshot;
    private final Collection<CPElement> variables;
    private final Collection<CPElement> mixins;

    public static CPModel getModel(CssParserResult result) {
        CPModel curr = (CPModel)result.getProperty(CPModel.class);
        if (curr == null) {
            curr = new CPModel(result);
            result.setProperty(CPModel.class, (Object)curr);
        }
        return curr;
    }

    public static CPModel getModel(FileObject file) throws ParseException {
        final AtomicReference model_ref = new AtomicReference();
        Source source = Source.create((FileObject)file);
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                CssParserResult result;
                ResultIterator cssRI = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                if (cssRI != null && (result = (CssParserResult)cssRI.getParserResult()) != null) {
                    model_ref.set(CPModel.getModel(result));
                }
            }
        });
        return (CPModel)model_ref.get();
    }

    private CPModel(CssParserResult result) {
        this.snapshot = result.getSnapshot();
        this.variables = this.findVariables(result);
        this.mixins = this.findMixins(result);
        this.cpType = this.findPreprocessorType();
    }

    public Collection<CPElement> getVariables() {
        return this.variables;
    }

    public Collection<CPElement> getMixins() {
        return this.mixins;
    }

    public CPType getPreprocessorType() {
        return this.cpType;
    }

    public FileObject getFile() {
        return this.snapshot.getSource().getFileObject();
    }

    private CPType findPreprocessorType() {
        CPType type;
        String fileMimetype;
        String string = fileMimetype = topLevelSnapshotMimetype != null ? topLevelSnapshotMimetype : this.snapshot.getSource().getFileObject().getMIMEType();
        if (fileMimetype == null) {
            type = CPType.NONE;
        } else {
            switch (fileMimetype) {
                case "text/less": {
                    type = CPType.LESS;
                    break;
                }
                case "text/scss": {
                    type = CPType.SCSS;
                    break;
                }
                default: {
                    type = CPType.NONE;
                }
            }
        }
        return type;
    }

    public Collection<CPElement> getElements() {
        ArrayList<CPElement> all = new ArrayList<CPElement>();
        all.addAll(this.getVariables());
        all.addAll(this.getMixins());
        return all;
    }

    public Collection<CPElement> getVariables(int offset) {
        ArrayList<CPElement> visible = new ArrayList<CPElement>();
        for (CPElement var : this.getVariables()) {
            OffsetRange context = var.getScope();
            if (context != null && !context.containsInclusive(offset)) continue;
            visible.add(var);
        }
        return visible;
    }

    public CPElement getVariableAtOffset(int offset) {
        for (CPElement var : this.getVariables()) {
            OffsetRange context = var.getRange();
            if (context != null && !context.containsInclusive(offset)) continue;
            return var;
        }
        return null;
    }

    private Collection<CPElement> findVariables(CssParserResult result) {
        final ArrayList<CPElement> vars = new ArrayList<CPElement>();
        NodeVisitor visitor = new NodeVisitor(){
            private boolean in_cp_variable_declaration;
            private boolean in_block_control;
            private boolean in_block;
            private Stack<OffsetRange> contexts = new Stack();
            private Collection<CPElement> elementsAwaitingBlockNode = new ArrayList<CPElement>();

            public boolean visit(Node node) {
                switch (node.type()) {
                    case sass_control_block: 
                    case declarations: {
                        OffsetRange range = new OffsetRange(node.from(), node.to());
                        this.contexts.push(range);
                        for (CPElement e : this.elementsAwaitingBlockNode) {
                            e.setScope(range);
                        }
                        this.elementsAwaitingBlockNode.clear();
                        this.in_block = true;
                        CPModel._visitChildren(this, node);
                        this.contexts.pop();
                        this.in_block = false;
                        break;
                    }
                    case cp_variable_declaration: {
                        this.in_cp_variable_declaration = true;
                        CPModel._visitChildren(this, node);
                        this.in_cp_variable_declaration = false;
                        break;
                    }
                    case sass_control: 
                    case cp_args_list: {
                        this.in_block_control = true;
                        CPModel._visitChildren(this, node);
                        this.in_block_control = false;
                        break;
                    }
                    case cp_variable: {
                        CPElementType type = this.in_block_control && !this.in_block ? CPElementType.VARIABLE_DECLARATION_IN_BLOCK_CONTROL : (this.in_cp_variable_declaration ? (this.in_block ? CPElementType.VARIABLE_LOCAL_DECLARATION : CPElementType.VARIABLE_GLOBAL_DECLARATION) : CPElementType.VARIABLE_USAGE);
                        OffsetRange scope = this.contexts.isEmpty() ? null : this.contexts.peek();
                        CPElementHandle handle = new CPElementHandle(CPModel.this.getFile(), node.image().toString().trim(), type, NodeUtil.getElementId((Node)node));
                        OffsetRange variableRange = new OffsetRange(node.from(), node.to());
                        CPElement element = new CPElement(handle, variableRange, scope);
                        switch (type) {
                            case VARIABLE_DECLARATION_IN_BLOCK_CONTROL: {
                                this.elementsAwaitingBlockNode.add(element);
                            }
                        }
                        vars.add(element);
                        break;
                    }
                    case token: {
                        break;
                    }
                    default: {
                        CPModel._visitChildren(this, node);
                    }
                }
                return false;
            }
        };
        visitor.visit(result.getParseTree());
        return vars;
    }

    private static void _visitChildren(NodeVisitor visitor, Node node) {
        List children = node.children();
        if (children != null) {
            for (Node child : children) {
                visitor.visit(child);
            }
        }
    }

    private Collection<CPElement> findMixins(CssParserResult result) {
        final ArrayList<CPElement> items = new ArrayList<CPElement>();
        NodeVisitor visitor = new NodeVisitor(){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case cp_mixin_declaration: {
                        Node mixin_name = NodeUtil.getChildByType((Node)node, (NodeType)NodeType.cp_mixin_name);
                        if (mixin_name == null) break;
                        CPElementHandle handle = new CPElementHandle(CPModel.this.getFile(), mixin_name.image().toString().trim(), CPElementType.MIXIN_DECLARATION, NodeUtil.getElementId((Node)node));
                        OffsetRange variableRange = new OffsetRange(mixin_name.from(), mixin_name.to());
                        OffsetRange scope = null;
                        CPElement element = new CPElement(handle, variableRange, scope);
                        items.add(element);
                        break;
                    }
                    case cp_mixin_call: {
                        Node mixin_name = NodeUtil.getChildByType((Node)node, (NodeType)NodeType.cp_mixin_name);
                        if (mixin_name == null) break;
                        CPElementHandle handle = new CPElementHandle(CPModel.this.getFile(), mixin_name.image().toString().trim(), CPElementType.MIXIN_USAGE, NodeUtil.getElementId((Node)node));
                        OffsetRange variableRange = new OffsetRange(mixin_name.from(), mixin_name.to());
                        OffsetRange scope = null;
                        CPElement element = new CPElement(handle, variableRange, scope);
                        items.add(element);
                        break;
                    }
                    default: {
                        List children = node.children();
                        if (children == null) break;
                        for (Node child : children) {
                            this.visit(child);
                        }
                    }
                }
                return false;
            }
        };
        visitor.visit(result.getParseTree());
        return items;
    }

    public Collection<String> getMixinNames() {
        return CPModel.getElementNames(this.getMixins());
    }

    public Collection<String> getVarNames() {
        return CPModel.getElementNames(this.getVariables());
    }

    private static Collection<String> getElementNames(Collection<? extends CPElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (CPElement cPElement : elements) {
            names.add(cPElement.getName().toString());
        }
        return names;
    }

    public Collection<String> getDirectives() {
        switch (this.getPreprocessorType()) {
            case SCSS: {
                return SASS_DIRECTIVES;
            }
        }
        return Collections.emptyList();
    }

    static {
        SASS_DIRECTIVES = Arrays.asList("@content", "@debug", "@each", "@extend", "@if", "@include", "@for", "@else", "@else if", "@function", "@mixin", "@return", "@warn", "@while");
    }
}

