/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.FutureParamTask;
import org.netbeans.modules.css.editor.module.spi.SemanticAnalyzer;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.prep.editor.CPCategoryStructureItem;
import org.netbeans.modules.css.prep.editor.CPCslElementHandle;
import org.netbeans.modules.css.prep.editor.CPCssIndexModel;
import org.netbeans.modules.css.prep.editor.CPSemanticAnalyzer;
import org.netbeans.modules.css.prep.editor.CPStructureItem;
import org.netbeans.modules.css.prep.editor.CPType;
import org.netbeans.modules.css.prep.editor.CPUtils;
import org.netbeans.modules.css.prep.editor.MixinCompletionItem;
import org.netbeans.modules.css.prep.editor.VariableCompletionItem;
import org.netbeans.modules.css.prep.editor.model.CPElement;
import org.netbeans.modules.css.prep.editor.model.CPElementHandle;
import org.netbeans.modules.css.prep.editor.model.CPElementType;
import org.netbeans.modules.css.prep.editor.model.CPModel;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.DependencyType;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.Lines;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public class CPCssEditorModule
extends CssEditorModule {
    private final SemanticAnalyzer semanticAnalyzer = new CPSemanticAnalyzer();
    private static Map<NodeType, ColoringAttributes> COLORINGS;
    private static final Collection<String> PSEUDO_CLASSES;

    public SemanticAnalyzer getSemanticAnalyzer() {
        return this.semanticAnalyzer;
    }

    public List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        ArrayList<CompletionProposal> proposals;
        block44: {
            proposals = new ArrayList<CompletionProposal>();
            CPModel model = CPModel.getModel(context.getParserResult());
            if (model == null) {
                return Collections.emptyList();
            }
            ArrayList<CompletionProposal> allVars = new ArrayList<CompletionProposal>(CPCssEditorModule.getVariableCompletionProposals(context, model));
            TokenSequence ts = context.getTokenSequence();
            Token token = ts.token();
            if (token == null) {
                return Collections.emptyList();
            }
            CssTokenId tid = (CssTokenId)token.id();
            CharSequence ttext = token.text();
            char first = ttext.charAt(0);
            switch (tid) {
                case ERROR: {
                    switch (first) {
                        case '$': {
                            if (NodeUtil.getAncestorByType((Node)context.getActiveTokenNode(), (NodeType)NodeType.rule) == null && NodeUtil.getAncestorByType((Node)context.getActiveTokenNode(), (NodeType)NodeType.cp_mixin_block) == null) break;
                            return Utilities.filterCompletionProposals(allVars, (CharSequence)context.getPrefix(), (boolean)true);
                        }
                    }
                }
                case AT_SIGN: {
                    switch (first) {
                        case '@': {
                            proposals.addAll(Utilities.createRAWCompletionProposals(model.getDirectives(), (ElementKind)ElementKind.KEYWORD, (int)context.getAnchorOffset()));
                            if (model.getPreprocessorType() == CPType.LESS) {
                                proposals.addAll(allVars);
                            }
                            return Utilities.filterCompletionProposals(proposals, (CharSequence)context.getPrefix(), (boolean)true);
                        }
                    }
                    break;
                }
                case SASS_VAR: {
                    if (model.getPreprocessorType() == CPType.SCSS) {
                        return Utilities.filterCompletionProposals(allVars, (CharSequence)context.getPrefix(), (boolean)true);
                    }
                }
                case AT_IDENT: {
                    List props = Utilities.createRAWCompletionProposals(model.getDirectives(), (ElementKind)ElementKind.KEYWORD, (int)context.getAnchorOffset());
                    if (model.getPreprocessorType() == CPType.LESS) {
                        return Utilities.filterCompletionProposals(allVars, (CharSequence)context.getPrefix(), (boolean)true);
                    }
                    return Utilities.filterCompletionProposals((List)props, (CharSequence)context.getPrefix(), (boolean)true);
                }
            }
            Node activeNode = context.getActiveNode();
            boolean isError = false;
            while (activeNode.type() == NodeType.error || activeNode.type() == NodeType.recovery) {
                isError = true;
                activeNode = activeNode.parent();
            }
            block12 : switch (activeNode.type()) {
                case bodyItem: 
                case mediaBody: 
                case mediaBodyItem: 
                case cssClass: {
                    switch (tid) {
                        case WS: {
                            if (ts.movePrevious()) {
                                Token previousToken = ts.token();
                                if (previousToken.id() != CssTokenId.SASS_INCLUDE) break block12;
                                proposals.addAll(CPCssEditorModule.getMixinsCompletionProposals(context, model));
                                break;
                            }
                            break block44;
                        }
                        case IDENT: {
                            if (LexerUtils.followsToken((TokenSequence)ts, (TokenId)CssTokenId.SASS_INCLUDE, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS}) != null) {
                                proposals.addAll(CPCssEditorModule.getMixinsCompletionProposals(context, model));
                                break;
                            }
                            if (LexerUtils.followsToken((TokenSequence)ts, (TokenId)CssTokenId.DOT, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS}) != null) {
                                proposals.addAll(CPCssEditorModule.getMixinsCompletionProposals(context, model));
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case cp_mixin_call: 
                case cp_mixin_name: {
                    proposals.addAll(CPCssEditorModule.getMixinsCompletionProposals(context, model));
                    break;
                }
                case cp_variable: {
                    proposals.addAll(allVars);
                    break;
                }
                case propertyValue: {
                    if (context.getPrefix().length() != 1 || context.getPrefix().charAt(0) != model.getPreprocessorType().getVarPrefix().charValue()) break;
                    proposals.addAll(allVars);
                    break;
                }
                case declaration: {
                    switch (tid) {
                        case DOT: {
                            proposals.addAll(CPCssEditorModule.getMixinsCompletionProposals(context, model));
                            break;
                        }
                        case WS: {
                            while (ts.movePrevious() && (ts.token().id() == CssTokenId.WS || ts.token().id() == CssTokenId.NL)) {
                            }
                            switch ((CssTokenId)ts.token().id()) {
                                case SASS_INCLUDE: {
                                    proposals.addAll(CPCssEditorModule.getMixinsCompletionProposals(context, model));
                                }
                            }
                        }
                    }
                    break;
                }
                case selectorsGroup: {
                    switch ((CssTokenId)ts.token().id()) {
                        case DOT: {
                            proposals.addAll(CPCssEditorModule.getMixinsCompletionProposals(context, model));
                        }
                    }
                }
            }
        }
        return Utilities.filterCompletionProposals(proposals, (CharSequence)context.getPrefix(), (boolean)true);
    }

    private static Collection<CompletionProposal> getVariableCompletionProposals(CompletionContext context, CPModel model) {
        LinkedHashSet<CompletionProposal> proposals = new LinkedHashSet<CompletionProposal>();
        for (CPElement var : model.getVariables(context.getCaretOffset())) {
            if (var.getType() == CPElementType.VARIABLE_USAGE || var.getRange().containsInclusive(context.getCaretOffset())) continue;
            CPCslElementHandle handle = new CPCslElementHandle(context.getFileObject(), var.getName());
            VariableCompletionItem item = new VariableCompletionItem(handle, var.getHandle(), context.getAnchorOffset(), null);
            proposals.add((CompletionProposal)item);
        }
        try {
            FileObject file = context.getFileObject();
            if (file != null) {
                Map<FileObject, CPCssIndexModel> indexModels = CPUtils.getIndexModels(file, DependencyType.REFERRING_AND_REFERRED, true);
                for (Map.Entry<FileObject, CPCssIndexModel> entry : indexModels.entrySet()) {
                    FileObject reff = entry.getKey();
                    CPCssIndexModel cpIndexModel = entry.getValue();
                    Collection<CPElementHandle> variables = cpIndexModel.getVariables();
                    for (CPElementHandle var : variables) {
                        if (var.getType() != CPElementType.VARIABLE_GLOBAL_DECLARATION) continue;
                        CPCslElementHandle handle = new CPCslElementHandle(context.getFileObject(), var.getName());
                        VariableCompletionItem item = new VariableCompletionItem(handle, var, context.getAnchorOffset(), reff.getNameExt());
                        proposals.add((CompletionProposal)item);
                    }
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return proposals;
    }

    private static Collection<CompletionProposal> getMixinsCompletionProposals(CompletionContext context, CPModel model) {
        LinkedHashSet<CompletionProposal> proposals = new LinkedHashSet<CompletionProposal>();
        for (CPElement mixin : model.getMixins()) {
            if (mixin.getType() != CPElementType.MIXIN_DECLARATION) continue;
            CPCslElementHandle handle = new CPCslElementHandle(context.getFileObject(), mixin.getName());
            MixinCompletionItem item = new MixinCompletionItem(handle, mixin.getHandle(), context.getAnchorOffset(), null);
            proposals.add((CompletionProposal)item);
        }
        try {
            FileObject file = context.getFileObject();
            if (file != null) {
                Map<FileObject, CPCssIndexModel> indexModels = CPUtils.getIndexModels(file, DependencyType.REFERRING_AND_REFERRED, true);
                for (Map.Entry<FileObject, CPCssIndexModel> entry : indexModels.entrySet()) {
                    FileObject reff = entry.getKey();
                    CPCssIndexModel cpIndexModel = entry.getValue();
                    Collection<CPElementHandle> mixins = cpIndexModel.getMixins();
                    for (CPElementHandle mixin : mixins) {
                        if (mixin.getType() != CPElementType.MIXIN_DECLARATION) continue;
                        CPCslElementHandle handle = new CPCslElementHandle(context.getFileObject(), mixin.getName());
                        MixinCompletionItem item = new MixinCompletionItem(handle, mixin, context.getAnchorOffset(), reff.getNameExt());
                        proposals.add((CompletionProposal)item);
                    }
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return proposals;
    }

    public <T extends Map<OffsetRange, Set<ColoringAttributes>>> NodeVisitor<T> getSemanticHighlightingNodeVisitor(FeatureContext context, T result) {
        final Snapshot snapshot = context.getSnapshot();
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                ColoringAttributes coloring = (ColoringAttributes)CPCssEditorModule.getColorings().get(node.type());
                if (coloring != null) {
                    int dso = snapshot.getOriginalOffset(node.from());
                    int deo = snapshot.getOriginalOffset(node.to());
                    if (dso >= 0 && deo >= 0) {
                        OffsetRange range = new OffsetRange(dso, deo);
                        ((Map)this.getResult()).put(range, Collections.singleton(coloring));
                    }
                }
                return false;
            }
        };
    }

    private static Map<NodeType, ColoringAttributes> getColorings() {
        if (COLORINGS == null) {
            COLORINGS = new EnumMap<NodeType, ColoringAttributes>(NodeType.class);
            COLORINGS.put(NodeType.cp_variable, ColoringAttributes.LOCAL_VARIABLE);
            COLORINGS.put(NodeType.cp_mixin_name, ColoringAttributes.PRIVATE);
        }
        return COLORINGS;
    }

    public <T extends Set<OffsetRange>> NodeVisitor<T> getMarkOccurrencesNodeVisitor(EditorFeatureContext context, T result) {
        return Utilities.createMarkOccurrencesNodeVisitor((EditorFeatureContext)context, result, (NodeType[])new NodeType[]{NodeType.cp_variable, NodeType.cp_mixin_name});
    }

    public boolean isInstantRenameAllowed(EditorFeatureContext context) {
        TokenSequence tokenSequence = context.getTokenSequence();
        int diff = tokenSequence.move(context.getCaretOffset());
        if (diff > 0 && tokenSequence.moveNext() || diff == 0 && tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            return token.id() == CssTokenId.AT_IDENT || token.id() == CssTokenId.SASS_VAR || token.id() == CssTokenId.IDENT;
        }
        return false;
    }

    public <T extends Set<OffsetRange>> NodeVisitor<T> getInstantRenamerVisitor(EditorFeatureContext context, T result) {
        TokenSequence tokenSequence = context.getTokenSequence();
        int diff = tokenSequence.move(context.getCaretOffset());
        if (diff > 0 && tokenSequence.moveNext() || diff == 0 && tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            final CharSequence elementName = token.text();
            return new NodeVisitor<T>(result){

                public boolean visit(Node node) {
                    switch (node.type()) {
                        case cp_mixin_name: 
                        case cp_variable: {
                            if (!LexerUtils.equals((CharSequence)elementName, (CharSequence)node.image(), (boolean)false, (boolean)false)) break;
                            OffsetRange range = new OffsetRange(node.from(), node.to());
                            ((Set)this.getResult()).add(range);
                            break;
                        }
                    }
                    return false;
                }
            };
        }
        return null;
    }

    public Pair<OffsetRange, FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>> getDeclaration(Document document, int caretOffset) {
        TokenSequence ts = LexerUtils.getJoinedTokenSequence((Document)document, (int)caretOffset, (Language)CssTokenId.language());
        if (ts == null) {
            return null;
        }
        OffsetRange foundRange = null;
        Token token = ts.token();
        int quotesDiff = WebUtils.isValueQuoted((CharSequence)ts.token().text().toString()) ? 1 : 0;
        OffsetRange range = new OffsetRange(ts.offset() + quotesDiff, ts.offset() + ts.token().length() - quotesDiff);
        switch ((CssTokenId)token.id()) {
            case IDENT: {
                CharSequence mixinName = token.text();
                while (ts.movePrevious() && ts.token().id() == CssTokenId.WS) {
                }
                Token t = ts.token();
                if (t != null && (t.id() == CssTokenId.DOT || t.id() == CssTokenId.SASS_INCLUDE)) {
                    foundRange = range;
                }
                if (foundRange == null) {
                    return null;
                }
                final CharSequence searchedMixinName = mixinName;
                FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext> callable = new FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>(){

                    public DeclarationFinder.DeclarationLocation run(EditorFeatureContext context) {
                        final ArrayList<Pair> locations = new ArrayList<Pair>();
                        CPModel model = CPModel.getModel(context.getParserResult());
                        for (CPElement mixin : model.getMixins()) {
                            if (mixin.getType() != CPElementType.MIXIN_DECLARATION || !LexerUtils.equals((CharSequence)searchedMixinName, (CharSequence)mixin.getName(), (boolean)false, (boolean)false)) continue;
                            locations.add(Pair.of((Object)new CPCslElementHandle(context.getFileObject(), mixin.getName(), mixin.getRange(), mixin.getType()), (Object)context.getSnapshot()));
                        }
                        try {
                            Map<FileObject, CPCssIndexModel> indexModels = CPUtils.getIndexModels(context.getFileObject(), DependencyType.REFERRING_AND_REFERRED, true);
                            for (Map.Entry<FileObject, CPCssIndexModel> entry : indexModels.entrySet()) {
                                final CPCssIndexModel im = entry.getValue();
                                final FileObject file = entry.getKey();
                                Source source = Source.create((FileObject)file);
                                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                                    public void run(ResultIterator resultIterator) throws Exception {
                                        ResultIterator cssRI = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                                        if (cssRI != null) {
                                            CssParserResult result = (CssParserResult)cssRI.getParserResult();
                                            CPModel model = CPModel.getModel(result);
                                            for (CPElementHandle mixin : im.getMixins()) {
                                                CPElement element;
                                                if (mixin.getType() != CPElementType.MIXIN_DECLARATION || !LexerUtils.equals((CharSequence)searchedMixinName, (CharSequence)mixin.getName(), (boolean)false, (boolean)false) || (element = mixin.resolve(model)) == null) continue;
                                                locations.add(Pair.of((Object)new CPCslElementHandle(file, mixin.getName(), element.getRange(), mixin.getType()), (Object)result.getSnapshot()));
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        catch (IOException | ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        if (locations.isEmpty()) {
                            return DeclarationFinder.DeclarationLocation.NONE;
                        }
                        Iterator itr = locations.iterator();
                        DeclarationFinder.DeclarationLocation main = null;
                        while (itr.hasNext()) {
                            Pair item = (Pair)itr.next();
                            CPCslElementHandle handle = (CPCslElementHandle)item.first();
                            Snapshot snapshot = (Snapshot)item.second();
                            Lines lines = new Lines(snapshot.getText());
                            DeclarationFinder.DeclarationLocation location = new DeclarationFinder.DeclarationLocation(handle.getFileObject(), handle.getOffsetRange(null).getStart());
                            if (main == null) {
                                main = location;
                            }
                            CpAlternativeLocation alternative = new CpAlternativeLocation(handle, location, snapshot, lines, handle.getFileObject().equals(context.getSource().getFileObject()));
                            main.addAlternative((DeclarationFinder.AlternativeLocation)alternative);
                        }
                        return main;
                    }
                };
                return Pair.of((Object)foundRange, (Object)callable);
            }
            case SASS_VAR: 
            case AT_IDENT: {
                final String varName = token.text().toString();
                foundRange = new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
                FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext> callable = new FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>(){

                    public DeclarationFinder.DeclarationLocation run(EditorFeatureContext context) {
                        final ArrayList<Pair> locations = new ArrayList<Pair>();
                        CPModel model = CPModel.getModel(context.getParserResult());
                        for (CPElement var : model.getVariables()) {
                            if (!var.getType().isOfTypes(CPElementType.VARIABLE_GLOBAL_DECLARATION, CPElementType.VARIABLE_LOCAL_DECLARATION, CPElementType.VARIABLE_DECLARATION_IN_BLOCK_CONTROL) || !LexerUtils.equals((CharSequence)varName, (CharSequence)var.getName(), (boolean)false, (boolean)false)) continue;
                            locations.add(Pair.of((Object)new CPCslElementHandle(context.getFileObject(), var.getName(), var.getRange(), var.getType()), (Object)context.getSnapshot()));
                        }
                        try {
                            Map<FileObject, CPCssIndexModel> indexModels = CPUtils.getIndexModels(context.getFileObject(), DependencyType.REFERRING_AND_REFERRED, true);
                            for (Map.Entry<FileObject, CPCssIndexModel> entry : indexModels.entrySet()) {
                                final CPCssIndexModel im = entry.getValue();
                                final FileObject file = entry.getKey();
                                Source source = Source.create((FileObject)file);
                                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                                    public void run(ResultIterator resultIterator) throws Exception {
                                        ResultIterator cssRI = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                                        if (cssRI != null) {
                                            CssParserResult result = (CssParserResult)cssRI.getParserResult();
                                            CPModel model = CPModel.getModel(result);
                                            for (CPElementHandle var : im.getVariables()) {
                                                CPElement element;
                                                if (var.getType() != CPElementType.VARIABLE_GLOBAL_DECLARATION || !var.getName().equals(varName) || (element = var.resolve(CPModel.getModel(file))) == null) continue;
                                                locations.add(Pair.of((Object)new CPCslElementHandle(file, var.getName(), element.getRange(), var.getType()), (Object)result.getSnapshot()));
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        catch (IOException | ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        if (locations.isEmpty()) {
                            return DeclarationFinder.DeclarationLocation.NONE;
                        }
                        Iterator itr = locations.iterator();
                        DeclarationFinder.DeclarationLocation main = null;
                        while (itr.hasNext()) {
                            Pair item = (Pair)itr.next();
                            CPCslElementHandle handle = (CPCslElementHandle)item.first();
                            Snapshot snapshot = (Snapshot)item.second();
                            Lines lines = new Lines(snapshot.getText());
                            DeclarationFinder.DeclarationLocation location = new DeclarationFinder.DeclarationLocation(handle.getFileObject(), handle.getOffsetRange(null).getStart());
                            if (main == null) {
                                main = location;
                            }
                            CpAlternativeLocation alternative = new CpAlternativeLocation(handle, location, snapshot, lines, handle.getFileObject().equals(context.getSource().getFileObject()));
                            main.addAlternative((DeclarationFinder.AlternativeLocation)alternative);
                        }
                        return main;
                    }
                };
                return Pair.of((Object)foundRange, (Object)callable);
            }
        }
        return null;
    }

    public <T extends Map<String, List<OffsetRange>>> NodeVisitor<T> getFoldsNodeVisitor(FeatureContext context, T result) {
        Snapshot snapshot = context.getSnapshot();
        final Lines lines = new Lines(snapshot.getText());
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case sass_control_block: 
                    case cp_mixin_block: {
                        int from = node.from();
                        int to = node.to();
                        try {
                            if (lines.getLineIndex(from) >= lines.getLineIndex(to)) break;
                            ArrayList<OffsetRange> codeblocks = (ArrayList<OffsetRange>)((Map)this.getResult()).get("codeblocks");
                            if (codeblocks == null) {
                                codeblocks = new ArrayList<OffsetRange>();
                                ((Map)this.getResult()).put("codeblocks", codeblocks);
                            }
                            codeblocks.add(new OffsetRange(from, to));
                            break;
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                return false;
            }
        };
    }

    public <T extends List<StructureItem>> NodeVisitor<T> getStructureItemsNodeVisitor(FeatureContext context, T result) {
        HashSet<StructureItem> vars = new HashSet<StructureItem>();
        HashSet<StructureItem> mixins = new HashSet<StructureItem>();
        CPModel model = CPModel.getModel(context.getParserResult());
        for (CPElement element : model.getElements()) {
            switch (element.getType()) {
                case MIXIN_DECLARATION: {
                    mixins.add(new CPStructureItem.Mixin(element));
                    break;
                }
                case VARIABLE_GLOBAL_DECLARATION: {
                    vars.add(new CPStructureItem.Variable(element));
                }
            }
        }
        if (!vars.isEmpty()) {
            result.add((CPCategoryStructureItem.Variables)new CPCategoryStructureItem.Variables((Set<StructureItem>)vars));
        }
        if (!mixins.isEmpty()) {
            result.add((CPCategoryStructureItem.Mixins)new CPCategoryStructureItem.Mixins(mixins, context));
        }
        return new NodeVisitor<T>(){

            public boolean visit(Node node) {
                return true;
            }
        };
    }

    public Collection<String> getPseudoClasses(EditorFeatureContext context) {
        Collection<String> result = null;
        if (CPUtils.LESS_FILE_MIMETYPE.equals(context.getSource().getMimeType())) {
            result = PSEUDO_CLASSES;
        }
        return result;
    }

    static {
        PSEUDO_CLASSES = Arrays.asList("extend");
    }

    private static class CpAlternativeLocation
    implements DeclarationFinder.AlternativeLocation {
        private static final int TEXT_MAX_LENGTH = 50;
        private final CPCslElementHandle handle;
        private final DeclarationFinder.DeclarationLocation location;
        private int lineIndex = -1;
        private String lineText;
        private final boolean currentFile;

        public CpAlternativeLocation(CPCslElementHandle handle, DeclarationFinder.DeclarationLocation location, Snapshot snapshot, Lines lines, boolean currentFile) {
            this.handle = handle;
            this.location = location;
            this.currentFile = currentFile;
            try {
                this.lineIndex = lines.getLineIndex(location.getOffset());
                int from = lines.getLineOffset(this.lineIndex);
                int to = lines.getLinesCount() > this.lineIndex + 1 ? lines.getLineOffset(this.lineIndex + 1) : snapshot.getText().length();
                this.lineText = snapshot.getText().subSequence(from, to).toString();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(CpAlternativeLocation.class.getName()).log(Level.INFO, null, ex);
            }
        }

        public ElementHandle getElement() {
            return this.handle;
        }

        public String getDisplayHtml(HtmlFormatter b) {
            if (this.lineText != null) {
                String elementText = this.handle.getName();
                String prefix = "";
                String postfix = "";
                int elementIndex = this.lineText.indexOf(elementText);
                if (elementIndex >= 0) {
                    char ch;
                    int from;
                    char c;
                    int to;
                    for (to = elementIndex; to < this.lineText.length() && (c = this.lineText.charAt(to)) != '{' && c != '\n'; ++to) {
                    }
                    for (from = elementIndex; from >= 0 && (ch = this.lineText.charAt(from)) != '}' && ch != '\n'; --from) {
                    }
                    prefix = this.lineText.substring(from + 1, elementIndex).trim();
                    postfix = this.lineText.substring(elementIndex + elementText.length(), to).trim();
                    int overlap = prefix.length() + elementText.length() + postfix.length() - 50;
                    if (overlap > 0) {
                        int stripFromPrefix = Math.min(overlap / 2, prefix.length());
                        prefix = ".." + prefix.substring(stripFromPrefix);
                        int stripFromPostfix = Math.min(overlap - stripFromPrefix, postfix.length());
                        postfix = postfix.substring(0, postfix.length() - stripFromPostfix) + "..";
                    }
                }
                b.appendHtml("<span>");
                b.appendText(prefix);
                b.appendText(" ");
                b.appendHtml("<b>");
                b.appendText(elementText);
                b.appendHtml("</b>");
                b.appendText(" ");
                b.appendText(postfix);
                b.appendHtml("</span>");
            }
            b.appendHtml("<span>");
            if (!this.isLocalDeclaration()) {
                Project project;
                FileObject file = this.location.getFileObject();
                FileObject pathRoot = ProjectWebRootQuery.getWebRoot((FileObject)file);
                String path = null;
                String resolveTo = null;
                if (pathRoot != null) {
                    path = FileUtil.getRelativePath((FileObject)pathRoot, (FileObject)file);
                }
                if (path == null && (project = FileOwnerQuery.getOwner((FileObject)file)) != null && (path = FileUtil.getRelativePath((FileObject)(pathRoot = project.getProjectDirectory()), (FileObject)file)) != null) {
                    resolveTo = "${project.home}/";
                }
                if (path == null) {
                    path = file.getPath();
                }
                b.appendText(" in ");
                if (resolveTo != null) {
                    b.appendHtml("<i>");
                    b.appendText(resolveTo);
                    b.appendHtml("</i>");
                }
                b.appendText(path);
                if (this.lineIndex != -1) {
                    b.appendText(":");
                    b.appendText(Integer.toString(this.lineIndex + 1));
                }
            } else {
                b.appendText(" at line ");
                b.appendText(Integer.toString(this.lineIndex + 1));
            }
            b.appendHtml("</span>");
            return b.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            CpAlternativeLocation cpal = (CpAlternativeLocation)o;
            if (this.isLocalDeclaration() == cpal.isLocalDeclaration()) {
                return this.location.getFileObject().getPath().compareTo(o.getLocation().getFileObject().getPath());
            }
            return this.isLocalDeclaration() && !cpal.isLocalDeclaration() ? -1 : 1;
        }

        private boolean isLocalDeclaration() {
            return this.currentFile;
        }
    }
}

