/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.css.prep.Bundle;
import org.netbeans.modules.css.prep.preferences.CssPreprocessorPreferences;
import org.netbeans.modules.css.prep.preferences.CssPreprocessorPreferencesValidator;
import org.netbeans.modules.css.prep.preferences.LessPreferences;
import org.netbeans.modules.css.prep.preferences.LessPreferencesValidator;
import org.netbeans.modules.css.prep.preferences.SassPreferences;
import org.netbeans.modules.css.prep.preferences.SassPreferencesValidator;
import org.openide.filesystems.FileUtil;

public enum CssPreprocessorType {
    SASS{

        @Override
        public String getDisplayName() {
            return Bundle.CssPreprocessorType_sass_displayName();
        }

        @Override
        public String getDefaultDirectoryName() {
            return "scss";
        }

        @Override
        public Collection<String> getMimeTypes() {
            return Arrays.asList("text/scss", "text/sass");
        }

        @Override
        public CssPreprocessorPreferences getPreferences() {
            return SassPreferences.getInstance();
        }

        @Override
        public CssPreprocessorPreferencesValidator getPreferencesValidator() {
            return new SassPreferencesValidator();
        }

        @Override
        public String getExecutablePathPropertyName() {
            return "SASS_PATH_PROPERTY";
        }
    }
    ,
    LESS{

        @Override
        public String getDisplayName() {
            return Bundle.CssPreprocessorType_less_displayName();
        }

        @Override
        public String getDefaultDirectoryName() {
            return "less";
        }

        @Override
        public Collection<String> getMimeTypes() {
            return Collections.singleton("text/less");
        }

        @Override
        public CssPreprocessorPreferences getPreferences() {
            return LessPreferences.getInstance();
        }

        @Override
        public CssPreprocessorPreferencesValidator getPreferencesValidator() {
            return new LessPreferencesValidator();
        }

        @Override
        public String getExecutablePathPropertyName() {
            return "LESS_PATH_PROPERTY";
        }
    };

    private static Map<String, CssPreprocessorType> mime2filetypeMap;

    public abstract String getDisplayName();

    public abstract String getDefaultDirectoryName();

    public abstract Collection<String> getMimeTypes();

    public abstract CssPreprocessorPreferences getPreferences();

    public abstract CssPreprocessorPreferencesValidator getPreferencesValidator();

    public abstract String getExecutablePathPropertyName();

    public Collection<String> getFileExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        for (String mimeType : this.getMimeTypes()) {
            extensions.addAll(FileUtil.getMIMETypeExtensions((String)mimeType));
        }
        return extensions;
    }

    public static synchronized CssPreprocessorType find(String mimeType) {
        if (mime2filetypeMap == null) {
            mime2filetypeMap = new HashMap<String, CssPreprocessorType>();
            for (CssPreprocessorType type : CssPreprocessorType.values()) {
                for (String mt : type.getMimeTypes()) {
                    mime2filetypeMap.put(mt, type);
                }
            }
        }
        return mime2filetypeMap.get(mimeType);
    }
}

