/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBMetaDataFactory;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.output.SQLStatementExecutor;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SQLExecutionHelper {
    private static final Logger LOGGER = Logger.getLogger(SQLExecutionHelper.class.getName());
    private final DataView dataView;
    private final RequestProcessor rp = new RequestProcessor("SQLStatementExecution", 20, true);
    private static final String LIMIT_CLAUSE = "LIMIT ";
    public static final String OFFSET_CLAUSE = "OFFSET ";
    private static Pattern GROUP_BY_IN_SELECT = null;
    private boolean limitSupported = false;
    private boolean useScrollableCursors = false;
    private int resultSetScrollType = 1003;
    private boolean supportesMultipleResultSets = false;

    SQLExecutionHelper(DataView dataView) {
        this.dataView = dataView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialDataLoad() throws SQLException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must be called off the EDT!";
        class Loader
        implements Runnable,
        Cancellable {
            public boolean finished = false;
            public SQLException ex = null;
            Statement stmt = null;

            Loader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int updateCount;
                    Object dc = SQLExecutionHelper.this.dataView.getDatabaseConnection();
                    Connection conn = DBConnectionFactory.getInstance().getConnection((DatabaseConnection)dc);
                    this.checkNonNullConnection(conn);
                    this.checkSupportForMultipleResultSets(conn);
                    DBMetaDataFactory dbMeta = new DBMetaDataFactory(conn);
                    SQLExecutionHelper.this.limitSupported = dbMeta.supportsLimit();
                    String sql = SQLExecutionHelper.this.dataView.getSQLString();
                    boolean isSelect = SQLExecutionHelper.this.isSelectStatement(sql);
                    SQLExecutionHelper.this.updateScrollableSupport(conn, dc, sql);
                    if (Thread.interrupted()) {
                        return;
                    }
                    this.stmt = SQLExecutionHelper.this.prepareSQLStatement(conn, sql, true);
                    if (Thread.interrupted()) {
                        return;
                    }
                    boolean isResultSet = SQLExecutionHelper.this.executeSQLStatement(this.stmt, sql);
                    if (!isResultSet || SQLExecutionHelper.this.dataView.getUpdateCount() != -1) {
                        if (!conn.getAutoCommit()) {
                            conn.commit();
                        }
                        return;
                    }
                    if (Thread.interrupted()) {
                        return;
                    }
                    boolean needReread = false;
                    ResultSet rs = null;
                    do {
                        if (isResultSet) {
                            rs = this.stmt.getResultSet();
                            Collection<DBTable> tables = dbMeta.generateDBTables(rs, sql, isSelect);
                            DataViewDBTable dvTable = new DataViewDBTable(tables);
                            DataViewPageContext pageContext = SQLExecutionHelper.this.dataView.addPageContext(dvTable);
                            if (!(needReread |= SQLExecutionHelper.this.resultSetNeedsReloading(dvTable))) {
                                SQLExecutionHelper.this.loadDataFrom(pageContext, rs, SQLExecutionHelper.this.useScrollableCursors);
                            }
                        }
                        if (!SQLExecutionHelper.this.supportesMultipleResultSets) break;
                        isResultSet = this.stmt.getMoreResults();
                        updateCount = this.stmt.getUpdateCount();
                    } while (isResultSet || updateCount != -1);
                    if (needReread) {
                        int updateCount2;
                        isResultSet = SQLExecutionHelper.this.executeSQLStatement(this.stmt, sql);
                        int res = -1;
                        do {
                            if (isResultSet) {
                                rs = this.stmt.getResultSet();
                                DataViewPageContext pageContext = SQLExecutionHelper.this.dataView.getPageContext(++res);
                                SQLExecutionHelper.this.loadDataFrom(pageContext, rs, SQLExecutionHelper.this.useScrollableCursors);
                            }
                            if (!SQLExecutionHelper.this.supportesMultipleResultSets) break;
                            isResultSet = this.stmt.getMoreResults();
                            updateCount2 = this.stmt.getUpdateCount();
                        } while (isResultSet || updateCount2 != -1);
                    }
                    if (!SQLExecutionHelper.this.useScrollableCursors && SQLExecutionHelper.this.dataView.getPageContexts().size() > 0) {
                        SQLExecutionHelper.this.getTotalCount(isSelect, sql, this.stmt, SQLExecutionHelper.this.dataView.getPageContext(0));
                    }
                    DataViewUtils.closeResources(rs);
                }
                catch (SQLException sqlEx) {
                    this.ex = sqlEx;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
                finally {
                    DataViewUtils.closeResources(this.stmt);
                    Loader sqlEx = this;
                    synchronized (sqlEx) {
                        this.finished = true;
                        this.notifyAll();
                    }
                }
            }

            public boolean cancel() {
                if (this.stmt != null) {
                    try {
                        this.stmt.cancel();
                    }
                    catch (SQLException sqlEx) {
                        LOGGER.log(Level.FINE, null, sqlEx);
                    }
                }
                return true;
            }

            private void checkNonNullConnection(Connection conn) throws SQLException {
                if (conn == null) {
                    Throwable t = DBConnectionFactory.getInstance().getLastException();
                    String msg = t != null ? t.getMessage() : NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_connection_failure", (Object)SQLExecutionHelper.this.dataView.getDatabaseConnection());
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                    LOGGER.log(Level.INFO, msg, t);
                    throw new SQLException(msg, t);
                }
            }

            private void checkSupportForMultipleResultSets(Connection conn) {
                block2: {
                    try {
                        SQLExecutionHelper.this.supportesMultipleResultSets = conn.getMetaData().supportsMultipleResultSets();
                    }
                    catch (RuntimeException | SQLException e) {
                        LOGGER.log(Level.INFO, "Database driver throws exception when checking for multiple resultset support.");
                        if (!LOGGER.isLoggable(Level.FINE)) break block2;
                        LOGGER.log(Level.FINE, null, this.ex);
                    }
                }
            }
        }
        Loader l = new Loader();
        Future f = this.rp.submit((Runnable)l);
        try {
            f.get();
        }
        catch (InterruptedException ex) {
            f.cancel(true);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex.getCause());
        }
        Loader loader = l;
        synchronized (loader) {
            while (!l.finished) {
                try {
                    l.wait();
                }
                catch (InterruptedException ex) {}
            }
        }
        if (l.ex != null) {
            throw l.ex;
        }
    }

    RequestProcessor.Task executeInsertRow(final DataViewPageContext pageContext, final DBTable table, final String insertSQL, final Object[] insertedRow) {
        this.dataView.setEditable(false);
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_insert");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, ""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                List<DBColumn> columns = table.getColumnList();
                PreparedStatement pstmt = this.conn.prepareStatement(insertSQL);
                try {
                    int pos = 1;
                    for (int i = 0; i < insertedRow.length; ++i) {
                        Object val = insertedRow[i];
                        if (DataViewUtils.isSQLConstantString(val, columns.get(i))) continue;
                        int colType = columns.get(i).getJdbcType();
                        DBReadWriteHelper.setAttributeValue(pstmt, pos++, colType, val);
                    }
                    SQLExecutionHelper.this.executePreparedStatement(pstmt);
                    int rows = this.dataView.getUpdateCount();
                    if (rows != 1) {
                        this.error = true;
                        this.errorMsg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_failure_insert_rows");
                    }
                }
                finally {
                    DataViewUtils.closeResources(pstmt);
                }
            }

            @Override
            public void finished() {
                this.dataView.resetEditable();
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_insert_command"));
            }

            @Override
            protected void executeOnSucess() {
                Boolean needRequery = (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                    public Boolean run() {
                        if (pageContext.getTotalRows() < 0) {
                            pageContext.setTotalRows(0);
                            pageContext.first();
                        }
                        pageContext.incrementRowSize(1);
                        return pageContext.refreshRequiredOnInsert();
                    }
                });
                if (needRequery.booleanValue()) {
                    SQLExecutionHelper.this.executeQuery();
                } else {
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            this.reinstateToolbar();
                        }
                    });
                }
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
        return task;
    }

    void executeDeleteRow(final DataViewPageContext pageContext, DBTable table, DataViewTableUI rsTable) {
        this.dataView.setEditable(false);
        SQLStatementGenerator generator = this.dataView.getSQLStatementGenerator();
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_delete");
        class DeleteElement {
            public List<Object> values = new ArrayList<Object>();
            public List<Integer> types = new ArrayList<Integer>();
            public String sql;

            DeleteElement() {
            }
        }
        final ArrayList<DeleteElement> rows = new ArrayList<DeleteElement>();
        for (int viewRow : rsTable.getSelectedRows()) {
            int modelRow = rsTable.convertRowIndexToModel(viewRow);
            DeleteElement de = new DeleteElement();
            de.sql = generator.generateDeleteStatement(table, de.types, de.values, modelRow, rsTable.getModel());
            rows.add(de);
        }
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, ""){

            @Override
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                for (DeleteElement de : rows) {
                    if (Thread.currentThread().isInterrupted() || this.error) break;
                    this.deleteARow(de);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void deleteARow(DeleteElement deleteRow) throws SQLException, DBException {
                PreparedStatement pstmt = this.conn.prepareStatement(deleteRow.sql);
                try {
                    int pos = 1;
                    for (Object val : deleteRow.values) {
                        DBReadWriteHelper.setAttributeValue(pstmt, pos, deleteRow.types.get(pos - 1), val);
                        ++pos;
                    }
                    SQLExecutionHelper.this.executePreparedStatement(pstmt);
                    int rows2 = this.dataView.getUpdateCount();
                    if (rows2 == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_delete");
                    } else if (rows2 > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(pstmt);
                }
            }

            @Override
            public void finished() {
                this.dataView.resetEditable();
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_delete_command"));
            }

            @Override
            protected void executeOnSucess() {
                pageContext.decrementRowSize(rows.size());
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeUpdateRow(DBTable table, final DataViewTableUI rsTable, boolean selectedOnly) {
        this.dataView.setEditable(false);
        SQLStatementGenerator generator = this.dataView.getSQLStatementGenerator();
        DataViewTableUIModel dataViewTableUIModel = rsTable.getModel();
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_update");
        class UpdateElement {
            public List<Object> values = new ArrayList<Object>();
            public List<Integer> types = new ArrayList<Integer>();
            public String sql;
            public Integer key;

            UpdateElement() {
            }
        }
        final ArrayList<UpdateElement> updateSet = new ArrayList<UpdateElement>();
        int[] viewRows = rsTable.getSelectedRows();
        ArrayList<Integer> modelRows = new ArrayList<Integer>();
        int[] arr$ = viewRows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer viewRow = arr$[i$];
            modelRows.add(rsTable.convertRowIndexToModel(viewRow));
        }
        for (Integer key : dataViewTableUIModel.getUpdateKeys()) {
            if (!modelRows.contains(key) && selectedOnly) continue;
            UpdateElement ue = new UpdateElement();
            try {
                ue.key = key;
                ue.sql = generator.generateUpdateStatement(table, key, dataViewTableUIModel.getChangedData(key), ue.values, ue.types, rsTable.getModel());
                updateSet.add(ue);
            }
            catch (DBException ex) {
                throw new RuntimeException(ex);
            }
        }
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, ""){
            private PreparedStatement pstmt;
            Set<Integer> keysToRemove;
            {
                super(x0, x1, x2);
                this.keysToRemove = new HashSet<Integer>();
            }

            @Override
            public void execute() throws SQLException, DBException {
                for (UpdateElement ue : updateSet) {
                    if (Thread.interrupted()) break;
                    this.updateARow(ue);
                    this.keysToRemove.add(ue.key);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateARow(UpdateElement ue) throws SQLException, DBException {
                this.pstmt = this.conn.prepareStatement(ue.sql);
                int pos = 1;
                for (Object val : ue.values) {
                    DBReadWriteHelper.setAttributeValue(this.pstmt, pos, ue.types.get(pos - 1), val);
                    ++pos;
                }
                try {
                    SQLExecutionHelper.this.executePreparedStatement(this.pstmt);
                    int rows = this.dataView.getUpdateCount();
                    if (rows == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_update");
                    } else if (rows > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(this.pstmt);
                }
            }

            @Override
            public void finished() {
                this.dataView.resetEditable();
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_update_command"));
            }

            @Override
            protected void executeOnSucess() {
                Mutex.EVENT.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        DataViewTableUIModel tblContext = rsTable.getModel();
                        for (Integer key : keysToRemove) {
                            tblContext.removeUpdateForSelectedRow(key, false);
                        }
                        this.reinstateToolbar();
                    }
                });
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeTruncate(final DataViewPageContext pageContext, final DBTable dbTable) {
        String msg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_truncate_table_progress");
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_truncate");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, msg){
            private PreparedStatement stmt;
            {
                super(x0, x1, x2);
                this.stmt = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws SQLException, DBException {
                String truncateSql = "TRUNCATE TABLE " + dbTable.getFullyQualifiedName(true);
                try {
                    this.stmt = this.conn.prepareStatement(truncateSql);
                    SQLExecutionHelper.this.executePreparedStatement(this.stmt);
                }
                catch (SQLException sqe) {
                    LOGGER.log(Level.FINE, "TRUNCATE Not supported...will try DELETE * \n");
                    truncateSql = "DELETE FROM " + dbTable.getFullyQualifiedName(true);
                    this.stmt = this.conn.prepareStatement(truncateSql);
                    SQLExecutionHelper.this.executePreparedStatement(this.stmt);
                }
                finally {
                    DataViewUtils.closeResources(this.stmt);
                }
            }

            @Override
            public void finished() {
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_truncate_command"));
            }

            @Override
            protected void executeOnSucess() {
                pageContext.setTotalRows(0);
                pageContext.first();
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeQueryOffEDT() {
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                SQLExecutionHelper.this.executeQuery();
            }
        });
    }

    void executeQuery() {
        assert (!SwingUtilities.isEventDispatchThread());
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executequery");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, this.dataView.getSQLString()){
            private Statement stmt;
            boolean lastEditState;
            {
                this.stmt = null;
                this.lastEditState = this.dataView.isEditable();
            }

            @Override
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                String sql = this.dataView.getSQLString();
                if (Thread.interrupted()) {
                    return;
                }
                boolean getTotal = false;
                for (DataViewPageContext pageContext : this.dataView.getPageContexts()) {
                    if (pageContext.getTotalRows() != -1) continue;
                    getTotal = true;
                    break;
                }
                this.stmt = SQLExecutionHelper.this.prepareSQLStatement(this.conn, sql, getTotal);
                try {
                    int updateCount;
                    if (Thread.interrupted()) {
                        return;
                    }
                    boolean resultSet = SQLExecutionHelper.this.executeSQLStatement(this.stmt, sql);
                    ResultSet rs = null;
                    int res = -1;
                    do {
                        if (resultSet) {
                            DataViewPageContext pageContext = this.dataView.getPageContext(++res);
                            rs = this.stmt.getResultSet();
                            SQLExecutionHelper.this.loadDataFrom(pageContext, rs, getTotal && SQLExecutionHelper.this.useScrollableCursors);
                        }
                        if (!SQLExecutionHelper.this.supportesMultipleResultSets) break;
                        resultSet = this.stmt.getMoreResults();
                        updateCount = this.stmt.getUpdateCount();
                    } while (resultSet || updateCount != -1);
                    if (!SQLExecutionHelper.this.useScrollableCursors && getTotal && this.dataView.getPageContexts().size() > 0) {
                        SQLExecutionHelper.this.getTotalCount(SQLExecutionHelper.this.isSelectStatement(sql), sql, this.stmt, this.dataView.getPageContext(0));
                    }
                    DataViewUtils.closeResources(rs);
                }
                catch (SQLException sqlEx) {
                    String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_error");
                    String msg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"Confirm_Close");
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(sqlEx.getMessage() + "\n" + msg), title, 2, 3);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                        this.dataView.removeComponents();
                    }
                    throw sqlEx;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished() {
                DataViewUtils.closeResources(this.stmt);
                this.dataView.resetEditable();
                DataView dataView = this.dataView;
                synchronized (dataView) {
                    if (this.error) {
                        this.dataView.setErrorStatusText(this.ex);
                    }
                    this.dataView.resetToolbar(this.error);
                }
            }

            @Override
            public boolean cancel() {
                boolean superResult = super.cancel();
                if (this.stmt != null) {
                    try {
                        this.stmt.cancel();
                    }
                    catch (SQLException sqlEx) {
                        LOGGER.log(Level.FINEST, null, sqlEx);
                    }
                }
                return superResult;
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadDataFrom(DataViewPageContext pageContext, ResultSet rs, boolean getTotal) throws SQLException {
        ArrayList<Object[]> rows;
        block23: {
            block24: {
                if (rs == null) {
                    return;
                }
                int pageSize = pageContext.getPageSize();
                int startFrom = this.useScrollableCursors ? pageContext.getCurrentPos() : (!this.limitSupported || this.isLimitUsedInSelect(this.dataView.getSQLString()) ? pageContext.getCurrentPos() : 0);
                rows = new ArrayList<Object[]>();
                int colCnt = pageContext.getTableMetaData().getColumnCount();
                try {
                    int rowCnt;
                    boolean hasNext;
                    block25: {
                        block22: {
                            hasNext = false;
                            boolean needSlowSkip = true;
                            if (this.useScrollableCursors && (rs.getType() == 1004 || rs.getType() == 1005)) {
                                try {
                                    hasNext = rs.absolute(startFrom);
                                    needSlowSkip = false;
                                }
                                catch (SQLException ex) {
                                    LOGGER.log(Level.FINE, "Absolute positioning failed", ex);
                                }
                            }
                            if (needSlowSkip) {
                                hasNext = rs.next();
                                for (int curRowPos = 1; hasNext && curRowPos < startFrom; ++curRowPos) {
                                    if (!Thread.currentThread().isInterrupted()) {
                                        hasNext = rs.next();
                                        continue;
                                    }
                                    break block22;
                                }
                            }
                            rowCnt = 0;
                            break block25;
                        }
                        Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Void>(pageContext, rows){
                            final /* synthetic */ DataViewPageContext val$pageContext;
                            final /* synthetic */ List val$rows;
                            {
                                this.val$pageContext = dataViewPageContext;
                                this.val$rows = list;
                            }

                            public Void run() {
                                this.val$pageContext.getModel().setData(this.val$rows);
                                return null;
                            }
                        });
                        return;
                    }
                    while ((pageSize == -1 || pageSize > rowCnt) && hasNext) {
                        if (!Thread.currentThread().isInterrupted()) {
                            Object[] row = new Object[colCnt];
                            for (int i = 0; i < colCnt; ++i) {
                                row[i] = DBReadWriteHelper.readResultSet(rs, pageContext.getTableMetaData().getColumn(i), i + 1);
                            }
                            rows.add(row);
                            ++rowCnt;
                            try {
                                hasNext = rs.next();
                            }
                            catch (SQLException x) {
                                LOGGER.log(Level.INFO, "Failed to forward to next record, cause: " + x.getLocalizedMessage(), x);
                                hasNext = false;
                            }
                            continue;
                        }
                        break block23;
                    }
                    if (!getTotal) break block24;
                    Integer result = null;
                    assert (this.useScrollableCursors) : "Scrollable cursors need to be enabled to get total counts here";
                    if (rs.getType() == 1004 || rs.getType() == 1005) {
                        try {
                            rs.last();
                            result = rs.getRow();
                        }
                        catch (SQLException ex) {
                            LOGGER.log(Level.INFO, "Failed to jump to end of SQL Statement '{0}' - cause: {1}", new Object[]{this.dataView.getSQLString(), ex});
                        }
                    }
                    pageContext.setTotalRows(result);
                }
                catch (SQLException e) {
                    try {
                        LOGGER.log(Level.SEVERE, "Failed to set up table model.", e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Mutex.EVENT.writeAccess((Mutex.Action)new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            }
            Mutex.EVENT.writeAccess((Mutex.Action)new /* invalid duplicate definition of identical inner class */);
            return;
        }
        Mutex.EVENT.writeAccess((Mutex.Action)new /* invalid duplicate definition of identical inner class */);
    }

    private Statement prepareSQLStatement(Connection conn, String sql, boolean needTotal) throws SQLException {
        Statement stmt = null;
        if (sql.startsWith("{")) {
            stmt = this.useScrollableCursors ? conn.prepareCall(sql, this.resultSetScrollType, 1007) : conn.prepareCall(sql);
        } else if (this.isSelectStatement(sql)) {
            stmt = this.useScrollableCursors ? conn.createStatement(this.resultSetScrollType, 1007) : conn.createStatement();
            SQLExecutionHelper.setFetchSize(stmt, 50);
            if (!needTotal) {
                try {
                    Integer maxRows = 0;
                    for (DataViewPageContext pageContext : this.dataView.getPageContexts()) {
                        int currentRows = pageContext.getCurrentPos();
                        int pageSize = pageContext.getPageSize();
                        if (pageSize <= 0) {
                            maxRows = 0;
                            break;
                        }
                        maxRows = Math.max(maxRows, currentRows + pageSize);
                    }
                    stmt.setMaxRows(maxRows);
                }
                catch (SQLException exc) {
                    LOGGER.log(Level.WARNING, "Unable to set Max row count", exc);
                    try {
                        stmt.setMaxRows(0);
                    }
                    catch (SQLException ex) {}
                }
            }
        } else {
            stmt = this.useScrollableCursors ? conn.createStatement(this.resultSetScrollType, 1007) : conn.createStatement();
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSQLStatement(Statement stmt, String sql) throws SQLException {
        LOGGER.log(Level.FINE, "Statement: {0}", sql);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executestmt") + sql);
        long startTime = System.currentTimeMillis();
        boolean isResultSet = false;
        if (stmt instanceof PreparedStatement) {
            isResultSet = ((PreparedStatement)stmt).execute();
        } else {
            try {
                DataViewPageContext pc = this.dataView.getPageContexts().size() > 0 ? this.dataView.getPageContext(0) : null;
                isResultSet = stmt.execute(this.appendLimitIfRequired(pc, sql));
            }
            catch (NullPointerException ex) {
                LOGGER.log(Level.SEVERE, "Failed to execute SQL Statement [{0}], cause: {1}", new Object[]{sql, ex});
                throw new SQLException(ex);
            }
            catch (SQLException sqlExc) {
                LOGGER.log(Level.SEVERE, "Failed to execute SQL Statement [{0}], cause: {1}", new Object[]{sql, sqlExc});
                throw sqlExc;
            }
        }
        long executionTime = System.currentTimeMillis() - startTime;
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.setUpdateCount(stmt.getUpdateCount());
            this.dataView.setExecutionTime(executionTime);
        }
        return isResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePreparedStatement(PreparedStatement stmt) throws SQLException {
        long startTime = System.currentTimeMillis();
        boolean isResultSet = stmt.execute();
        long executionTime = System.currentTimeMillis() - startTime;
        String execTimeStr = SQLExecutionHelper.millisecondsToSeconds(executionTime);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_execution_success", (Object)execTimeStr));
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.setUpdateCount(stmt.getUpdateCount());
            this.dataView.setExecutionTime(executionTime);
        }
        return isResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTotalCount(boolean isSelect, String sql, Statement stmt, DataViewPageContext pageContext) {
        if (!isSelect) {
            this.setTotalCount(null, pageContext);
            return;
        }
        ResultSet cntResultSet = null;
        try {
            cntResultSet = stmt.executeQuery(SQLStatementGenerator.getCountAsSubQuery(sql));
            this.setTotalCount(cntResultSet, pageContext);
        }
        catch (SQLException e) {
            try {
                LOGGER.log(Level.FINE, null, e);
            }
            catch (Throwable throwable) {
                DataViewUtils.closeResources(cntResultSet);
                throw throwable;
            }
            DataViewUtils.closeResources(cntResultSet);
        }
        DataViewUtils.closeResources(cntResultSet);
        return;
        if (!SQLExecutionHelper.isGroupByUsedInSelect(sql)) {
            cntResultSet = null;
            try {
                cntResultSet = stmt.executeQuery(SQLStatementGenerator.getCountSQLQuery(sql));
                this.setTotalCount(cntResultSet, pageContext);
                return;
            }
            catch (SQLException e) {
                LOGGER.log(Level.FINE, null, e);
            }
            finally {
                DataViewUtils.closeResources(cntResultSet);
            }
        }
        this.setTotalCount(null, pageContext);
    }

    private boolean isSelectStatement(String queryString) {
        return queryString.trim().toUpperCase().startsWith("SELECT") && queryString.trim().toUpperCase().indexOf("INTO") == -1;
    }

    private boolean isLimitUsedInSelect(String sql) {
        return sql.toUpperCase().indexOf(LIMIT_CLAUSE) != -1;
    }

    static boolean isGroupByUsedInSelect(String sql) {
        if (GROUP_BY_IN_SELECT == null) {
            GROUP_BY_IN_SELECT = Pattern.compile("\\Wgroup\\s+by\\W|\\Wcount\\s*\\(\\s*\\*\\s*\\)", 2);
        }
        return GROUP_BY_IN_SELECT.matcher(sql).find();
    }

    void setTotalCount(ResultSet countresultSet, DataViewPageContext pageContext) {
        try {
            if (countresultSet == null) {
                pageContext.setTotalRows(-1);
                pageContext.setTotalRows(-1);
            } else if (countresultSet.next()) {
                int count = countresultSet.getInt(1);
                pageContext.setTotalRows(count);
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, "Could not get total row count ", ex);
        }
    }

    private String appendLimitIfRequired(DataViewPageContext pageContext, String sql) {
        if (this.useScrollableCursors) {
            return sql;
        }
        if (this.limitSupported && this.isSelectStatement(sql) && !this.isLimitUsedInSelect(sql)) {
            int pageSize = pageContext == null ? this.dataView.getPageSize() : pageContext.getPageSize();
            int currentPos = pageContext == null ? 1 : pageContext.getCurrentPos();
            return sql + ' ' + LIMIT_CLAUSE + pageSize + ' ' + OFFSET_CLAUSE + (currentPos - 1);
        }
        return sql;
    }

    static String millisecondsToSeconds(long ms) {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(3);
        return fmt.format((double)ms / 1000.0);
    }

    private boolean resultSetNeedsReloading(DataViewDBTable metadata) {
        if (!this.dataView.getDatabaseConnection().getDriverClass().contains("oracle")) {
            return false;
        }
        int colCnt = metadata.getColumnCount();
        for (int i = 0; i < colCnt; ++i) {
            DBColumn column = metadata.getColumn(i);
            int jdbcType = column.getJdbcType();
            if (jdbcType != -1 && jdbcType != -16 && jdbcType != -4 && jdbcType != 2004 && jdbcType != 2005 && jdbcType != 2011) continue;
            return true;
        }
        return false;
    }

    private static void setFetchSize(Statement stmt, int fetchSize) {
        try {
            stmt.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            LOGGER.log(Level.INFO, "Unable to set Fetch size", e);
            try {
                stmt.setFetchSize(0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void updateScrollableSupport(Connection conn, DatabaseConnection dc, String sql) {
        this.useScrollableCursors = dc.isUseScrollableCursors();
        if (!this.useScrollableCursors) {
            return;
        }
        String driverName = dc.getDriverClass();
        if (driverName != null && driverName.startsWith("org.apache.derby") && !this.isSelectStatement(sql)) {
            this.resultSetScrollType = 1003;
            return;
        }
        try {
            if (conn.getMetaData().supportsResultSetType(1004)) {
                this.resultSetScrollType = 1004;
            } else if (conn.getMetaData().supportsResultSetType(1005)) {
                this.resultSetScrollType = 1005;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Exception while querying database for scrollable resultset support");
        }
    }
}

