/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.InsertRecordTableUI;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.table.JXTableRowHeader;
import org.netbeans.modules.db.dataview.table.ResultSetTableModel;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

class InsertRecordDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(InsertRecordDialog.class.getName());
    private final ResultSetTableModel insertDataModel;
    private final DBTable insertTable;
    private final DataView dataView;
    private final DataViewPageContext pageContext;
    InsertRecordTableUI insertRecordTableUI;
    private JXTableRowHeader rowHeader;
    private Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private JButton addBtn;
    private JPanel btnPanel;
    private JButton cancelBtn;
    private JButton executeBtn;
    private JEditorPane jEditorPane1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextArea jTextArea1;
    private JButton previewBtn;
    private JButton removeBtn;

    public InsertRecordDialog(DataView dataView, DataViewPageContext pageContext, DBTable insertTable) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.pageContext = pageContext;
        this.dataView = dataView;
        this.insertTable = insertTable;
        this.insertDataModel = new ResultSetTableModel(insertTable.getColumnList().toArray(new DBColumn[0]));
        this.insertDataModel.setEditable(true);
        this.insertRecordTableUI = new InsertRecordTableUI(){

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                AWTEvent awtEvent;
                if (rowIndex != -1 && columnIndex != -1 && this.getModel().getRowCount() > 1) {
                    InsertRecordDialog.this.removeBtn.setEnabled(true);
                }
                if ((awtEvent = EventQueue.getCurrentEvent()) instanceof KeyEvent) {
                    KeyEvent keyEvt = (KeyEvent)awtEvent;
                    if (keyEvt.getSource() != InsertRecordDialog.this) {
                        return;
                    }
                    if (rowIndex == 0 && columnIndex == 0 && KeyStroke.getKeyStrokeForEvent(keyEvt).equals(KeyStroke.getKeyStroke(9, 0))) {
                        this.appendEmptyRow();
                        rowIndex = this.getRowCount() - 1;
                        this.editCellAt(rowIndex, 0);
                    } else if (KeyStroke.getKeyStrokeForEvent(keyEvt).equals(KeyStroke.getKeyStroke(25, 0))) {
                        this.editCellAt(rowIndex, columnIndex);
                    } else {
                        this.editCellAt(rowIndex, columnIndex);
                    }
                }
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }
        };
        this.insertRecordTableUI.setModel(this.insertDataModel);
        this.initComponents();
        this.addInputFields();
        this.insertRecordTableUI.addKeyListener(new TableKeyListener());
        this.insertRecordTableUI.getModel().addTableModelListener(new TableListener());
        this.jSplitPane1.setBottomComponent(null);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertRecordDialog.this.executeBtnActionPerformed(null);
            }
        };
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertRecordDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getInputMap(2).put(enter, "ENTER");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().getActionMap().put("ENTER", enterAction);
        Rectangle screenBounds = Utilities.getUsableScreenBounds();
        Dimension prefSize = this.getPreferredSize();
        if (prefSize.width > screenBounds.width - 100 || prefSize.height > screenBounds.height - 100) {
            Dimension sz = new Dimension(prefSize);
            if (sz.width > screenBounds.width - 100) {
                sz.width = screenBounds.width * 3 / 4;
            }
            if (sz.height > screenBounds.height - 100) {
                sz.height = screenBounds.height * 3 / 4;
            }
            this.setPreferredSize(sz);
        }
        this.pack();
        this.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
    }

    private void initComponents() {
        this.jTextArea1 = new JTextArea();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.btnPanel = new JPanel();
        this.previewBtn = new JButton();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.executeBtn = new JButton();
        this.cancelBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.title"));
        this.setBackground(Color.white);
        this.setFont(new Font("Dialog", 0, 12));
        this.setForeground(Color.black);
        this.setLocationByPlatform(true);
        this.setModal(true);
        this.jTextArea1.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(this.jTextArea1.getFont());
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(3);
        this.jTextArea1.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.jTextArea1, "North");
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"insertRecodrDialog.jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"insertRecord.textarea.desc"));
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLastDividerLocation(250);
        this.jSplitPane1.setRequestFocusEnabled(false);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 255)));
        this.jScrollPane1.setFont(this.jScrollPane1.getFont());
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setForeground(new Color(204, 204, 255));
        this.jPanel3.setFont(this.jPanel3.getFont().deriveFont((float)this.jPanel3.getFont().getSize() + 1.0f));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel3);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.jScrollPane2.setFont(this.jScrollPane2.getFont());
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-sql"));
        this.jEditorPane1.setToolTipText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jEditorPane1.toolTipText"));
        this.jEditorPane1.setOpaque(false);
        this.jScrollPane2.setViewportView(this.jEditorPane1);
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.btnPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 20, 10));
        this.btnPanel.setFont(this.btnPanel.getFont());
        this.btnPanel.setPreferredSize(new Dimension(550, 50));
        this.btnPanel.setLayout(new FlowLayout(2));
        this.previewBtn.setFont(this.previewBtn.getFont());
        this.previewBtn.setMnemonic('S');
        Mnemonics.setLocalizedText((AbstractButton)this.previewBtn, (String)NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        this.previewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InsertRecordDialog.this.previewBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.previewBtn);
        this.previewBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        this.previewBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.addBtn.text_1"));
        this.addBtn.setToolTipText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.addBtn.toolTipText"));
        this.addBtn.setMaximumSize(this.previewBtn.getMaximumSize());
        this.addBtn.setMinimumSize(this.previewBtn.getMinimumSize());
        this.addBtn.setPreferredSize(this.previewBtn.getPreferredSize());
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InsertRecordDialog.this.addBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.addBtn);
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.removeBtn.text_1"));
        this.removeBtn.setToolTipText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.removeBtn.toolTipText"));
        this.removeBtn.setEnabled(false);
        this.removeBtn.setMaximumSize(this.previewBtn.getMaximumSize());
        this.removeBtn.setMinimumSize(this.previewBtn.getMinimumSize());
        this.removeBtn.setPreferredSize(this.previewBtn.getPreferredSize());
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InsertRecordDialog.this.removeBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.removeBtn);
        this.executeBtn.setFont(this.executeBtn.getFont());
        Mnemonics.setLocalizedText((AbstractButton)this.executeBtn, (String)NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.executeBtn.setMaximumSize(this.previewBtn.getMaximumSize());
        this.executeBtn.setMinimumSize(this.previewBtn.getMinimumSize());
        this.executeBtn.setPreferredSize(this.previewBtn.getPreferredSize());
        this.executeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InsertRecordDialog.this.executeBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.executeBtn);
        this.executeBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.executeBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.cancelBtn.setFont(this.cancelBtn.getFont());
        Mnemonics.setLocalizedText((AbstractButton)this.cancelBtn, (String)NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.cancelBtn.setMaximumSize(this.previewBtn.getMaximumSize());
        this.cancelBtn.setMinimumSize(this.previewBtn.getMinimumSize());
        this.cancelBtn.setPreferredSize(this.previewBtn.getPreferredSize());
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InsertRecordDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.cancelBtn);
        this.cancelBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.cancelBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleParent(null);
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        this.insertRecordTableUI.appendEmptyRow();
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        this.insertRecordTableUI.removeRows();
        this.removeBtn.setEnabled(false);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void executeBtnActionPerformed(ActionEvent evt) {
        if (this.insertRecordTableUI.isEditing()) {
            this.insertRecordTableUI.getCellEditor().stopCellEditing();
        }
        final int rows = this.insertRecordTableUI.getRowCount();
        final Object[][] insertedRows = new Object[rows][this.insertTable.getColumnList().size()];
        try {
            for (int i = 0; i < rows; ++i) {
                insertedRows[i] = this.getInsertValues(i);
            }
        }
        catch (DBException ex) {
            LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getLocalizedMessage()));
            return;
        }
        new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() throws Exception {
                SQLStatementGenerator stmtBldr = InsertRecordDialog.this.dataView.getSQLStatementGenerator();
                SQLExecutionHelper execHelper = InsertRecordDialog.this.dataView.getSQLExecutionHelper();
                for (int i = 0; i < rows; ++i) {
                    boolean wasException;
                    try {
                        Object[] insertedRow = insertedRows[i];
                        String insertSQL = stmtBldr.generateInsertStatement(InsertRecordDialog.this.insertTable, insertedRow);
                        RequestProcessor.Task task = execHelper.executeInsertRow(InsertRecordDialog.this.pageContext, InsertRecordDialog.this.insertTable, insertSQL, insertedRow);
                        task.waitFinished();
                        wasException = InsertRecordDialog.this.dataView.hasExceptions();
                    }
                    catch (DBException ex) {
                        LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getLocalizedMessage()));
                        wasException = true;
                    }
                    if (!wasException) continue;
                    return i;
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    Integer brokeOn = (Integer)this.get();
                    if (brokeOn == null) {
                        InsertRecordDialog.this.dispose();
                    } else {
                        for (int j = 0; j < brokeOn; ++j) {
                            InsertRecordDialog.this.insertRecordTableUI.getModel().removeRow(0);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                catch (ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }.execute();
    }

    private void previewBtnActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_show_sql"))) {
            this.jSplitPane1.setDividerLocation(this.jSplitPane1.getHeight() / 2);
            this.jSplitPane1.setBottomComponent(this.jScrollPane2);
            this.refreshSQL();
            this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_hide_sql"));
        } else {
            this.jSplitPane1.setBottomComponent(null);
            this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_show_sql"));
        }
    }

    public void refreshSQL() {
        try {
            String sqlText = "";
            if (this.jSplitPane1.getBottomComponent() != null) {
                SQLStatementGenerator stmtBldr = this.dataView.getSQLStatementGenerator();
                for (int i = 0; i < this.insertDataModel.getRowCount(); ++i) {
                    String sql = stmtBldr.generateRawInsertStatement(this.insertTable, this.getInsertValues(i));
                    sqlText = sqlText + sql + "\n";
                }
                this.jEditorPane1.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-sql"));
                this.jEditorPane1.setText(sqlText);
                this.jScrollPane2.setViewportView(this.jEditorPane1);
            }
        }
        catch (DBException ex) {
            JLabel errorLabel = new JLabel("<html><body><font color=\"#FF0000\">" + ex.getMessage().replaceAll("\\n", "<br>") + "</font></body></html>");
            errorLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
            errorLabel.setVerticalAlignment(1);
            this.jScrollPane2.setViewportView(errorLabel);
            this.jScrollPane2.revalidate();
            this.jScrollPane2.repaint();
        }
    }

    private void addInputFields() {
        this.insertRecordTableUI.appendEmptyRow();
        this.jScrollPane1.setViewportView((Component)((Object)this.insertRecordTableUI));
        this.rowHeader = new JXTableRowHeader(this.insertRecordTableUI);
        final Component[] order = new Component[]{this.rowHeader, this.insertRecordTableUI};
        FocusTraversalPolicy policy = new FocusTraversalPolicy(){
            List componentList;
            {
                this.componentList = Arrays.asList(order);
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return order[0];
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return order[order.length - 1];
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (aComponent instanceof JXTableRowHeader) {
                    int rowIndex = InsertRecordDialog.this.insertRecordTableUI.getRowCount() - 1;
                    InsertRecordDialog.this.insertRecordTableUI.editCellAt(rowIndex, 0);
                    InsertRecordDialog.this.insertRecordTableUI.setRowSelectionInterval(rowIndex, 0);
                }
                return InsertRecordDialog.this.insertRecordTableUI;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                int index = this.componentList.indexOf(aComponent);
                return order[(index - 1 + order.length) % order.length];
            }

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return order[0];
            }
        };
        this.setFocusTraversalPolicy(policy);
        this.jScrollPane1.setRowHeaderView(this.rowHeader);
        this.jScrollPane1.setCorner("UPPER_LEFT_CORNER", this.rowHeader.getTableHeader());
    }

    private Object[] getInsertValues(int row) throws DBException {
        Object[] insertData = new Object[this.insertDataModel.getColumnCount()];
        if (this.insertDataModel.getRowCount() <= 0) {
            return insertData;
        }
        for (int i = 0; i < this.insertDataModel.getColumnCount(); ++i) {
            DBColumn col = this.insertDataModel.getColumn(i);
            Object val = this.insertDataModel.getValueAt(row, i);
            insertData[i] = DataViewUtils.isSQLConstantString(val, col) ? val : DBReadWriteHelper.validate(val, col);
        }
        return insertData;
    }

    private void processKeyEvents(KeyEvent e) {
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        if (KeyStroke.getKeyStrokeForEvent(e).equals(copy)) {
            this.copy();
        } else if (KeyStroke.getKeyStrokeForEvent(e).equals(paste)) {
            this.paste();
        }
        if (e.isControlDown() && e.getKeyCode() == 127) {
            this.insertRecordTableUI.removeRows();
        } else if (e.getKeyCode() == 10) {
            this.setFocusable(false);
        } else if (e.isControlDown() && e.getKeyChar() == '0') {
            this.control0Event();
        } else if (e.isControlDown() && e.getKeyChar() == '1') {
            this.control1Event();
        } else if (KeyStroke.getKeyStrokeForEvent(e).equals(tab)) {
            // empty if block
        }
    }

    private void copy() {
        StringBuilder strBuffer = new StringBuilder();
        int numcols = this.insertRecordTableUI.getSelectedColumnCount();
        int numrows = this.insertRecordTableUI.getSelectedRowCount();
        int[] rowsselected = this.insertRecordTableUI.getSelectedRows();
        int[] colsselected = this.insertRecordTableUI.getSelectedColumns();
        if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
            JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
            return;
        }
        for (int i = 0; i < numrows; ++i) {
            for (int j = 0; j < numcols; ++j) {
                strBuffer.append(this.insertRecordTableUI.getValueAt(rowsselected[i], colsselected[j]));
                if (j >= numcols - 1) continue;
                strBuffer.append("\t");
            }
            strBuffer.append("\n");
        }
        StringSelection stringSelection = new StringSelection(strBuffer.toString());
        this.clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.clipBoard.setContents(stringSelection, stringSelection);
    }

    private void paste() {
        int startRow = this.insertRecordTableUI.getSelectedRows()[0];
        int startCol = this.insertRecordTableUI.getSelectedColumns()[0];
        try {
            String trstring = (String)this.clipBoard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            StringTokenizer st1 = new StringTokenizer(trstring, "\n");
            if (this.insertRecordTableUI.getSelectedRows().length < st1.countTokens()) {
                int rowCnt = st1.countTokens() - this.insertRecordTableUI.getSelectedRows().length;
                for (int cnt = 0; cnt < rowCnt; ++cnt) {
                    this.addBtnActionPerformed(null);
                }
            }
            int i = 0;
            while (st1.hasMoreTokens()) {
                String rowstring = st1.nextToken();
                StringTokenizer st2 = new StringTokenizer(rowstring, "\t");
                int j = 0;
                while (st2.hasMoreTokens()) {
                    String value = st2.nextToken();
                    if (startRow + i < this.insertRecordTableUI.getRowCount() && startCol + j < this.insertRecordTableUI.getColumnCount()) {
                        this.insertRecordTableUI.setValueAt(value, startRow + i, startCol + j);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "Failed to paste the contents ", ex);
        }
    }

    private void control0Event() {
        int row = this.insertRecordTableUI.getSelectedRow();
        int col = this.insertRecordTableUI.getSelectedColumn();
        if (row == -1) {
            return;
        }
        this.insertRecordTableUI.editCellAt(row, col);
        TableCellEditor editor = this.insertRecordTableUI.getCellEditor();
        List<DBColumn> columns = this.insertTable.getColumnList();
        if (editor != null) {
            DBColumn dbcol = columns.get(col);
            if (dbcol.isGenerated() || !dbcol.isNullable()) {
                Toolkit.getDefaultToolkit().beep();
                editor.stopCellEditing();
            } else {
                editor.getTableCellEditorComponent((JTable)((Object)this.insertRecordTableUI), null, this.insertRecordTableUI.isRowSelectionAllowed, row, col);
                this.insertRecordTableUI.setValueAt(null, row, col);
                editor.stopCellEditing();
            }
            this.insertRecordTableUI.setRowSelectionInterval(row, row);
        }
    }

    private void control1Event() {
        int row = this.insertRecordTableUI.getSelectedRow();
        int col = this.insertRecordTableUI.getSelectedColumn();
        if (row == -1) {
            return;
        }
        this.insertRecordTableUI.editCellAt(row, col);
        TableCellEditor editor = this.insertRecordTableUI.getCellEditor();
        if (editor != null) {
            List<DBColumn> columns = this.insertTable.getColumnList();
            DBColumn dbcol = columns.get(col);
            Object val = this.insertRecordTableUI.getValueAt(row, col);
            if (dbcol.isGenerated() || !dbcol.hasDefault()) {
                Toolkit.getDefaultToolkit().beep();
                editor.stopCellEditing();
            } else if (val != null && val instanceof String && ((String)val).equals("<DEFAULT>")) {
                editor.getTableCellEditorComponent((JTable)((Object)this.insertRecordTableUI), "", this.insertRecordTableUI.isRowSelectionAllowed, row, col);
                this.insertRecordTableUI.setValueAt(null, row, col);
                editor.stopCellEditing();
            } else {
                editor.getTableCellEditorComponent((JTable)((Object)this.insertRecordTableUI), "<DEFAULT>", this.insertRecordTableUI.isRowSelectionAllowed, row, col);
                this.insertRecordTableUI.setValueAt("<DEFAULT>", row, col);
                editor.stopCellEditing();
            }
            this.insertRecordTableUI.setRowSelectionInterval(row, row);
        }
    }

    private class TableKeyListener
    implements KeyListener {
        @Override
        public void keyTyped(KeyEvent e) {
            InsertRecordDialog.this.processKeyEvents(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            InsertRecordDialog.this.processKeyEvents(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            InsertRecordDialog.this.processKeyEvents(e);
        }
    }

    public class TableListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent e) {
            if (SwingUtilities.isEventDispatchThread()) {
                InsertRecordDialog.this.refreshSQL();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InsertRecordDialog.this.refreshSQL();
                    }
                });
            }
        }
    }
}

