/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.EditorExtender;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.index.JsIndex;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.OccurrencesSupport;
import org.netbeans.modules.javascript2.editor.model.Type;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DeclarationFinderImpl
implements DeclarationFinder {
    private final Language<JsTokenId> language;

    public DeclarationFinderImpl(Language<JsTokenId> language) {
        this.language = language;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        JsParserResult jsResult = (JsParserResult)info;
        Model model = jsResult.getModel();
        model.resolve();
        int offset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        OccurrencesSupport os = model.getOccurrencesSupport();
        Occurrence occurrence = os.getOccurrence(offset);
        if (occurrence != null) {
            FileObject fo;
            Collection<? extends TypeUsage> assignments;
            JsObject object = occurrence.getDeclarations().iterator().next();
            JsObject jsObject = object.getParent();
            Collection<? extends TypeUsage> collection = assignments = jsObject == null ? null : jsObject.getAssignmentForOffset(offset);
            if (assignments != null && assignments.isEmpty()) {
                assignments = jsObject.getAssignments();
            }
            Snapshot snapshot = jsResult.getSnapshot();
            JsIndex jsIndex = JsIndex.get(snapshot.getSource().getFileObject());
            ArrayList<IndexResult> indexResults = new ArrayList<IndexResult>();
            if (assignments == null || assignments.isEmpty()) {
                fo = object.getFileObject();
                if (object.isDeclared()) {
                    if (fo != null) {
                        if (!fo.equals(snapshot.getSource().getFileObject())) return new DeclarationFinder.DeclarationLocation(fo, object.getDeclarationName().getOffsetRange().getStart());
                        int docOffset = LexUtilities.getLexerOffset(jsResult, object.getDeclarationName().getOffsetRange().getStart());
                        if (docOffset > -1) {
                            return new DeclarationFinder.DeclarationLocation(fo, docOffset);
                        }
                    }
                } else {
                    Collection<? extends IndexResult> items = JsIndex.get(fo).findByFqn(object.getFullyQualifiedName(), JsIndex.TERMS_BASIC_INFO);
                    indexResults.addAll(items);
                    DeclarationFinder.DeclarationLocation location = this.processIndexResult(indexResults);
                    if (location != null) {
                        return location;
                    }
                }
            } else {
                TokenSequence<? extends JsTokenId> ts;
                fo = object.getFileObject();
                if (object.isDeclared() && fo != null) {
                    if (!fo.equals(snapshot.getSource().getFileObject())) return new DeclarationFinder.DeclarationLocation(fo, object.getDeclarationName().getOffsetRange().getStart());
                    int docOffset = LexUtilities.getLexerOffset(jsResult, object.getDeclarationName().getOffsetRange().getStart());
                    if (docOffset > -1) {
                        return new DeclarationFinder.DeclarationLocation(fo, docOffset);
                    }
                }
                if ((ts = LexUtilities.getTokenSequence(snapshot, caretOffset, this.language)) != null) {
                    ts.move(offset);
                    if (ts.moveNext() && ts.token().id() == JsTokenId.IDENTIFIER) {
                        String propertyName = ts.token().text().toString();
                        for (Type type : assignments) {
                            Collection<? extends IndexResult> items;
                            String fqn = type.getType();
                            if (fqn.startsWith("@exp;")) {
                                fqn = fqn.substring("@exp;".length());
                            }
                            if (fqn.contains("@pro;")) {
                                fqn = fqn.replace("@pro;", ".");
                            }
                            if ((items = jsIndex.findByFqn(fqn + "." + propertyName, JsIndex.TERMS_BASIC_INFO)).isEmpty()) {
                                items = jsIndex.findByFqn(fqn + ".prototype." + propertyName, JsIndex.TERMS_BASIC_INFO);
                            }
                            indexResults.addAll(items);
                        }
                        DeclarationFinder.DeclarationLocation location = this.processIndexResult(indexResults);
                        if (location != null) {
                            return location;
                        }
                    }
                }
            }
        }
        for (DeclarationFinder declarationFinder : EditorExtender.getDefault().getDeclarationFinders()) {
            DeclarationFinder.DeclarationLocation loc = declarationFinder.findDeclaration(info, caretOffset);
            if (loc == null || loc == DeclarationFinder.DeclarationLocation.NONE) continue;
            return loc;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation processIndexResult(List<IndexResult> indexResults) {
        if (!indexResults.isEmpty()) {
            IndexResult iResult = indexResults.get(0);
            String value = iResult.getValue("offset");
            int offset = Integer.parseInt(value);
            DeclarationFinder.DeclarationLocation location = new DeclarationFinder.DeclarationLocation(iResult.getFile(), offset, (ElementHandle)IndexedElement.create(iResult));
            if (indexResults.size() > 1) {
                for (int i = 0; i < indexResults.size(); ++i) {
                    iResult = indexResults.get(i);
                    location.addAlternative((DeclarationFinder.AlternativeLocation)new AlternativeLocationImpl(iResult));
                }
            }
            return location;
        }
        return null;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        if (doc == null) {
            return OffsetRange.NONE;
        }
        final OffsetRange[] value = new OffsetRange[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence<? extends JsTokenId> ts = LexUtilities.getTokenSequence(doc, caretOffset, (Language<JsTokenId>)DeclarationFinderImpl.this.language);
                if (ts != null) {
                    ts.move(caretOffset);
                    if (ts.moveNext() && ts.token().id() == JsTokenId.IDENTIFIER) {
                        value[0] = new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
                    }
                }
            }
        });
        if (value[0] != null) {
            return value[0];
        }
        for (DeclarationFinder declarationFinder : EditorExtender.getDefault().getDeclarationFinders()) {
            OffsetRange result = declarationFinder.getReferenceSpan(doc, caretOffset);
            if (result == null || result == OffsetRange.NONE) continue;
            return result;
        }
        return OffsetRange.NONE;
    }

    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private final IndexResult iResult;
        private final int offset;
        private final DeclarationFinder.DeclarationLocation location;
        private final IndexedElement element;

        public AlternativeLocationImpl(IndexResult iResult) {
            this.iResult = iResult;
            String value = iResult.getValue("offset");
            this.offset = Integer.parseInt(value);
            this.location = new DeclarationFinder.DeclarationLocation(iResult.getFile(), this.offset);
            this.element = IndexedElement.create(iResult);
        }

        public ElementHandle getElement() {
            return this.element;
        }

        private String getStringLocation() {
            List asLines;
            int lineNumber = 0;
            int count = 0;
            try {
                asLines = this.element.getFileObject().asLines();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                asLines = null;
            }
            if (asLines != null) {
                for (String line : asLines) {
                    ++lineNumber;
                    if ((count += line.length()) < this.offset) continue;
                    break;
                }
            }
            String result = this.iResult.getRelativePath();
            if (lineNumber > 0) {
                result = result + " : " + lineNumber;
            }
            return result;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            formatter.appendText(this.getStringLocation());
            return formatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            AlternativeLocationImpl ali = (AlternativeLocationImpl)o;
            return this.getStringLocation().compareTo(ali.getStringLocation());
        }
    }
}

