/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AbstractDocument;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Selector;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.Pattern;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public class Feature {
    private String featureName;
    private Selector selector;
    private Object value;
    private Map<String, Evaluator> evaluators;
    private Map<String, Pattern> patterns;

    public static Feature create(String featureName, Selector selector) {
        return new Feature(featureName, selector, null, Collections.<String, Evaluator>emptyMap(), Collections.<String, Pattern>emptyMap());
    }

    public static Feature createMethodCallFeature(String featureName, Selector selector, String methodCall) {
        return new Feature(featureName, selector, new Method(methodCall), Collections.<String, Evaluator>emptyMap(), Collections.<String, Pattern>emptyMap());
    }

    public static Feature createExpressionFeature(String featureName, Selector selector, String expression) {
        return new Feature(featureName, selector, new Expression(expression), Collections.<String, Evaluator>emptyMap(), Collections.<String, Pattern>emptyMap());
    }

    public static Feature createExpressionFeature(String featureName, Selector selector, Pattern pattern) {
        return new Feature(featureName, selector, pattern, Collections.<String, Evaluator>emptyMap(), Collections.<String, Pattern>emptyMap());
    }

    public static Feature create(String featureName, Selector selector, Map<String, String> expressions, Map<String, String> methods, Map<String, Pattern> patterns) {
        HashMap<String, Evaluator> evaluators = new HashMap<String, Evaluator>();
        for (String key : expressions.keySet()) {
            evaluators.put(key, new Expression(expressions.get(key)));
        }
        for (String key : methods.keySet()) {
            evaluators.put(key, new Method(methods.get(key)));
        }
        return new Feature(featureName, selector, null, evaluators, patterns);
    }

    private Feature(String featureName, Selector selector, Object value, Map<String, Evaluator> evaluators, Map<String, Pattern> patterns) {
        this.featureName = featureName;
        this.selector = selector;
        this.value = value;
        this.evaluators = evaluators;
        this.patterns = patterns;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public boolean hasSingleValue() {
        return this.value != null;
    }

    public Type getType() {
        if (this.value == null) {
            return Type.NOT_SET;
        }
        if (this.value instanceof Pattern) {
            return Type.PATTERN;
        }
        if (this.value instanceof Method) {
            return Type.METHOD_CALL;
        }
        return Type.STRING;
    }

    public Object getValue() {
        if (this.value instanceof Evaluator) {
            return ((Evaluator)this.value).evaluate();
        }
        return this.value;
    }

    public Pattern getPattern() {
        return (Pattern)this.value;
    }

    public Object getValue(Context context) {
        if (this.value == null) {
            return null;
        }
        return ((Evaluator)this.value).evaluate(context);
    }

    public Object getValue(Object[] parameters) {
        if (this.value == null) {
            return null;
        }
        return ((Method)this.value).evaluate(parameters);
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        Object o = this.getValue(propertyName);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean((String)o);
    }

    public boolean getBoolean(String propertyName, Context context, boolean defaultValue) {
        Object o = this.getValue(propertyName, context);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean((String)o);
    }

    public Object getValue(String propertyName) {
        Evaluator e = this.evaluators.get(propertyName);
        if (e != null) {
            return e.evaluate();
        }
        return this.patterns.get(propertyName);
    }

    public Object getValue(String propertyName, Context context) {
        Evaluator e = this.evaluators.get(propertyName);
        if (e == null) {
            return null;
        }
        return e.evaluate(context);
    }

    public Object getValue(String propertyName, Object[] parameters) {
        Method e = (Method)this.evaluators.get(propertyName);
        if (e == null) {
            return null;
        }
        return e.evaluate(parameters);
    }

    public Pattern getPattern(String propertyName) {
        return this.patterns.get(propertyName);
    }

    public Type getType(String propertyName) {
        if (this.patterns.containsKey(propertyName)) {
            return Type.PATTERN;
        }
        Evaluator e = this.evaluators.get(propertyName);
        if (e == null) {
            return Type.NOT_SET;
        }
        if (e instanceof Method) {
            return Type.METHOD_CALL;
        }
        return Type.STRING;
    }

    public String getMethodName() {
        return ((Method)this.value).getMethodName();
    }

    public String getMethodName(String propertyName) {
        Method m = (Method)this.evaluators.get(propertyName);
        if (m == null) {
            return null;
        }
        return m.getMethodName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Feature ");
        if (this.featureName != null) {
            sb.append(this.featureName).append(' ');
        }
        if (this.selector != null) {
            sb.append(this.selector).append(' ');
        }
        if (this.value != null) {
            sb.append(this.value).append(' ');
        }
        return sb.toString();
    }

    private static abstract class Evaluator {
        private Evaluator() {
        }

        public abstract Object evaluate();

        public abstract Object evaluate(Context var1);
    }

    private static class Expression
    extends Evaluator {
        private String[] names;
        private String expression;

        private Expression(String expression) {
            int se;
            this.expression = expression;
            if (expression == null) {
                return;
            }
            ArrayList<String> l = new ArrayList<String>();
            int start = 0;
            do {
                int ss;
                if ((ss = expression.indexOf(36, start)) < 0) {
                    l.add(expression.substring(start, expression.length()));
                    break;
                }
                l.add(expression.substring(start, ss));
                se = expression.indexOf(36, ++ss);
                if (se < 0) {
                    se = expression.length();
                }
                l.add(expression.substring(ss, se));
            } while ((start = se + 1) < expression.length());
            this.names = l.toArray(new String[l.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object evaluate(Context context) {
            if (context instanceof SyntaxContext) {
                ASTItem l = ((SyntaxContext)context).getASTPath().getLeaf();
                if (l instanceof ASTNode) {
                    return this.evaluate((ASTNode)l);
                }
                if (l instanceof ASTToken) {
                    return this.evaluate((ASTToken)l);
                }
            } else {
                AbstractDocument document = (AbstractDocument)context.getDocument();
                document.readLock();
                ASTToken stoken = null;
                try {
                    TokenSequence tokenSequence = Utils.getTokenSequence(document, context.getOffset());
                    Token token = tokenSequence.token();
                    if (token != null) {
                        stoken = ASTToken.create(null, token.id().ordinal(), token.text().toString(), tokenSequence.offset());
                    }
                }
                finally {
                    document.readUnlock();
                }
                return this.evaluate(stoken);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object evaluate() {
            return this.expression;
        }

        private Object evaluate(ASTNode node) {
            if (this.names == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int k = this.names.length;
            for (int i = 0; i < k; i += 2) {
                sb.append(this.names[i]);
                if (i + 1 >= this.names.length) break;
                if (this.names[i + 1].equals("")) {
                    sb.append(node.getAsText());
                    continue;
                }
                ASTItem item = Expression.get(node, this.names[i + 1]);
                if (item instanceof ASTToken) {
                    sb.append(((ASTToken)item).getIdentifier());
                    continue;
                }
                if (!(item instanceof ASTNode)) continue;
                sb.append(((ASTNode)item).getAsText());
            }
            return sb.toString();
        }

        private static ASTItem get(ASTNode node, String s) {
            int i = s.indexOf(46);
            if (i > 0) {
                String ss = s.substring(0, i);
                ASTNode n = node.getNode(ss);
                if (n != null) {
                    return Expression.get(n, s.substring(i + 1));
                }
                return null;
            }
            ASTNode n = node.getNode(s);
            if (n != null) {
                return n;
            }
            return node.getTokenType(s);
        }

        private String evaluate(ASTToken token) {
            if (this.names == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int k = this.names.length;
            for (int i = 0; i < k; i += 2) {
                sb.append(this.names[i]);
                if (i + 1 >= this.names.length) break;
                if (this.names[i + 1].equals("identifier")) {
                    sb.append(token.getIdentifier());
                    continue;
                }
                if (this.names[i + 1].equals("")) {
                    sb.append(token.getIdentifier());
                    continue;
                }
                if (!this.names[i + 1].equals("type")) continue;
                sb.append(token.getTypeName());
            }
            return sb.toString();
        }
    }

    private static class Method
    extends Evaluator {
        private String methodName;
        private java.lang.reflect.Method method;
        private boolean resolved = false;

        private Method(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public Object evaluate() {
            return this.evaluate(new Object[0]);
        }

        @Override
        public Object evaluate(Context context) {
            return this.evaluate(new Object[]{context});
        }

        public Object evaluate(Object[] params) {
            if (!this.resolved) {
                this.resolved = true;
                int i = this.methodName.lastIndexOf(46);
                if (i < 1) {
                    throw new IllegalArgumentException(this.methodName);
                }
                String className = this.methodName.substring(0, i);
                String methodN = this.methodName.substring(i + 1);
                ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                try {
                    Class<?> cls = cl.loadClass(className);
                    java.lang.reflect.Method[] ms = cls.getMethods();
                    int jj = ms.length;
                    for (int j = 0; j < jj; ++j) {
                        int l;
                        if (!ms[j].getName().equals(methodN) || ms[j].getParameterTypes().length != params.length) continue;
                        Class<?>[] pts = ms[j].getParameterTypes();
                        int ll = params.length;
                        for (l = 0; l < ll && (params[l] == null || pts[l].isAssignableFrom(params[l].getClass())); ++l) {
                        }
                        if (l < ll) continue;
                        this.method = ms[j];
                        break;
                    }
                    if (this.method == null) {
                        throw new NoSuchMethodException(this.methodName);
                    }
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (NoSuchMethodException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (this.method != null) {
                try {
                    return this.method.invoke(null, params);
                }
                catch (IllegalAccessException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            return null;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }

    public static enum Type {
        STRING,
        METHOD_CALL,
        PATTERN,
        NOT_SET;

    }
}

