/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infomandb.client;

import de.proveo.infomandb.api.InfomanDBCommonWS;
import de.proveo.infomandb.api.SearchDeviceWS;
import de.proveo.infomandb.api.model.ValueWrapper;
import de.proveo.infomandb.client.InfomanDBAccessDeniedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class InfomanDBClient
implements SearchDeviceWS,
InfomanDBCommonWS {
    private final SearchDeviceWS infomanWS;
    private final InfomanDBCommonWS commonWS;
    private final DefaultHttpClient httpClient;
    private final String url;
    private String username;
    private char[] password;

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private InfomanDBClient(String url, DefaultHttpClient httpClient, SearchDeviceWS infomanWS, InfomanDBCommonWS commonWS) {
        this.url = url;
        this.httpClient = httpClient;
        this.infomanWS = infomanWS;
        this.commonWS = commonWS;
    }

    public static InfomanDBClient create(String url) {
        RegisterBuiltin.register((ResteasyProviderFactory)ResteasyProviderFactory.getInstance());
        try {
            URL webserviceURL = new URL(url);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            if (webserviceURL.getProtocol().equals("https")) {
                SSLSocketFactory socketFactory = new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy());
                Scheme sch = new Scheme("https", webserviceURL.getPort(), (SchemeSocketFactory)socketFactory);
                httpClient.getConnectionManager().getSchemeRegistry().register(sch);
            }
            ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor((HttpClient)httpClient);
            SearchDeviceWS infomanWS = (SearchDeviceWS)ProxyFactory.create(SearchDeviceWS.class, (String)webserviceURL.toString(), (ClientExecutor)executor);
            InfomanDBCommonWS commonWS = (InfomanDBCommonWS)ProxyFactory.create(InfomanDBCommonWS.class, (String)webserviceURL.toString(), (ClientExecutor)executor);
            return new InfomanDBClient(url, httpClient, infomanWS, commonWS);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void login() throws IOException, InfomanDBAccessDeniedException {
        this.login(this.username, this.password);
    }

    public static void main(String[] args) throws Exception {
        InfomanDBClient client = InfomanDBClient.create("http://localhost:8080/infomanDB");
        client.login("admin", "mypassword".toCharArray());
        client.ping();
    }

    public void login(String username, char[] password) throws IOException, InfomanDBAccessDeniedException {
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        HttpGet get = new HttpGet(InfomanDBClient.buildURL(this.url, "pages/login/welcome.jsf").toString());
        this.httpClient.execute((HttpUriRequest)get, (ResponseHandler)responseHandler);
        HttpPost post = new HttpPost(InfomanDBClient.buildURL(this.url, "pages/login/j_security_check").toString());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("j_username", username));
        nvps.add(new BasicNameValuePair("j_password", new String(password)));
        nvps.add(new BasicNameValuePair("login", ""));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        InfomanAccessDeniedHttpPostFollowRedirectStrategy accessdeniedRedirectStrategy = new InfomanAccessDeniedHttpPostFollowRedirectStrategy();
        this.httpClient.setRedirectStrategy((RedirectStrategy)accessdeniedRedirectStrategy);
        this.httpClient.execute((HttpUriRequest)post, (ResponseHandler)responseHandler);
        this.httpClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        if (!accessdeniedRedirectStrategy.isRedirected()) {
            throw new InfomanDBAccessDeniedException(username);
        }
        Cookie sessionCookie = this.findCookie(this.httpClient.getCookieStore().getCookies(), "JSESSIONID");
        if (sessionCookie == null) {
            throw new IllegalStateException("session cookie not found");
        }
    }

    protected static URL buildURL(String url, String path) throws MalformedURLException {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + path;
        return new URL(url);
    }

    public ValueWrapper getSerialNumber(String deviceType, String hardwareSerialNumber) {
        return this.infomanWS.getSerialNumber(deviceType, hardwareSerialNumber);
    }

    private Cookie findCookie(List<Cookie> cookies, String cookieName) {
        for (Cookie cookie : cookies) {
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public String ping() {
        return this.commonWS.ping();
    }

    class InfomanAccessDeniedHttpPostFollowRedirectStrategy
    extends DefaultRedirectStrategy {
        private boolean redirected;

        InfomanAccessDeniedHttpPostFollowRedirectStrategy() {
        }

        public boolean isRedirected() {
            return this.redirected;
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            if (response == null) {
                throw new IllegalArgumentException("HTTP response may not be null");
            }
            int statusCode = response.getStatusLine().getStatusCode();
            String method = request.getRequestLine().getMethod();
            Header locationHeader = response.getFirstHeader("location");
            switch (statusCode) {
                case 302: {
                    boolean redirectNecessary;
                    boolean bl = redirectNecessary = method.equalsIgnoreCase("POST") && locationHeader != null;
                    if (!this.redirected) {
                        this.redirected = redirectNecessary;
                    }
                    return redirectNecessary;
                }
            }
            return super.isRedirected(request, response, context);
        }
    }
}

