/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty.swing.standalone;

import com.wittams.gritty.RequestOrigin;
import com.wittams.gritty.ResizePanelDelegate;
import com.wittams.gritty.jsch.JSchTty;
import com.wittams.gritty.swing.BufferPanel;
import com.wittams.gritty.swing.GrittyTerminal;
import com.wittams.gritty.swing.TermPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Main {
    public static final Logger logger = Logger.getLogger(Main.class);
    JFrame bufferFrame;
    private TermPanel termPanel;
    private GrittyTerminal terminal;
    private AbstractAction openAction = new AbstractAction("Open SHELL Session..."){

        public void actionPerformed(ActionEvent e) {
            Main.this.openSession();
        }
    };
    private AbstractAction showBuffersAction = new AbstractAction("Show buffers"){

        public void actionPerformed(ActionEvent e) {
            if (Main.this.bufferFrame == null) {
                Main.this.showBuffers();
            }
        }
    };
    private AbstractAction resetDamage = new AbstractAction("Reset damage"){

        public void actionPerformed(ActionEvent e) {
            if (Main.this.termPanel != null) {
                Main.this.termPanel.getBackBuffer().resetDamage();
            }
        }
    };
    private AbstractAction drawDamage = new AbstractAction("Draw from damage"){

        public void actionPerformed(ActionEvent e) {
            if (Main.this.termPanel != null) {
                Main.this.termPanel.redrawFromDamage();
            }
        }
    };

    private final JMenuBar getJMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu("File");
        m.add(this.openAction);
        mb.add(m);
        JMenu dm = new JMenu("Debug");
        dm.add(this.showBuffersAction);
        dm.add(this.resetDamage);
        dm.add(this.drawDamage);
        mb.add(dm);
        return mb;
    }

    public void openSession() {
        if (!this.terminal.isSessionRunning()) {
            this.terminal.setTty(new JSchTty());
            this.terminal.start();
        }
    }

    Main() {
        this.terminal = new GrittyTerminal();
        this.termPanel = this.terminal.getTermPanel();
        final JFrame frame = new JFrame("Gritty");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JMenuBar mb = this.getJMenuBar();
        frame.setJMenuBar(mb);
        this.sizeFrameForTerm(frame);
        frame.getContentPane().add("Center", this.terminal);
        frame.pack();
        this.termPanel.setVisible(true);
        frame.setVisible(true);
        frame.setResizable(true);
        this.termPanel.setResizePanelDelegate(new ResizePanelDelegate(){

            public void resizedPanel(Dimension pixelDimension, RequestOrigin origin) {
                if (origin == RequestOrigin.Remote) {
                    Main.this.sizeFrameForTerm(frame);
                }
            }
        });
    }

    private void sizeFrameForTerm(JFrame frame) {
        Dimension d = this.terminal.getPreferredSize();
        d.width += frame.getWidth() - frame.getContentPane().getWidth();
        d.height += frame.getHeight() - frame.getContentPane().getHeight();
        frame.setSize(d);
    }

    public static void main(String[] arg) {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        new Main();
    }

    private void showBuffers() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.this.bufferFrame = new JFrame("buffers");
                BufferPanel panel = new BufferPanel(Main.this.terminal);
                Main.this.bufferFrame.getContentPane().add(panel);
                Main.this.bufferFrame.pack();
                Main.this.bufferFrame.setVisible(true);
                Main.this.bufferFrame.setSize(800, 600);
                Main.this.bufferFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        (this).Main.this.bufferFrame = null;
                    }
                });
            }
        });
    }
}

