/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty.swing;

import com.wittams.gritty.BackBuffer;
import com.wittams.gritty.Emulator;
import com.wittams.gritty.ScrollBuffer;
import com.wittams.gritty.StyleState;
import com.wittams.gritty.TerminalWriter;
import com.wittams.gritty.Tty;
import com.wittams.gritty.TtyChannel;
import com.wittams.gritty.swing.ConnectedKeyHandler;
import com.wittams.gritty.swing.PreConnectHandler;
import com.wittams.gritty.swing.TermPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GrittyTerminal
extends JPanel {
    private static final Logger logger = Logger.getLogger(GrittyTerminal.class);
    private static final long serialVersionUID = -8213232075937432833L;
    private final StyleState styleState;
    private final BackBuffer backBuffer;
    private final ScrollBuffer scrollBuffer;
    private final TermPanel termPanel;
    private final JScrollBar scrollBar;
    private Tty tty;
    private TtyChannel ttyChannel;
    private TerminalWriter terminalWriter;
    private Emulator emulator;
    private Thread emuThread;
    private AtomicBoolean sessionRunning = new AtomicBoolean();
    private PreConnectHandler preconnectHandler;

    public GrittyTerminal() {
        super(new BorderLayout());
        this.styleState = new StyleState();
        this.backBuffer = new BackBuffer(80, 24, this.styleState);
        this.scrollBuffer = new ScrollBuffer();
        this.termPanel = new TermPanel(this.backBuffer, this.scrollBuffer, this.styleState);
        this.terminalWriter = new TerminalWriter(this.termPanel, this.backBuffer, this.styleState);
        this.preconnectHandler = new PreConnectHandler(this.terminalWriter);
        this.termPanel.setKeyHandler(this.preconnectHandler);
        this.scrollBar = new JScrollBar();
        this.add((Component)this.termPanel, "Center");
        this.add((Component)this.scrollBar, "East");
        this.scrollBar.setModel(this.termPanel.getBoundedRangeModel());
        this.sessionRunning.set(false);
    }

    public TermPanel getTermPanel() {
        return this.termPanel;
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public void setTty(Tty tty) {
        this.tty = tty;
        this.ttyChannel = new TtyChannel(tty);
        this.emulator = new Emulator(this.terminalWriter, this.ttyChannel);
        this.termPanel.setEmulator(this.emulator);
    }

    public void start() {
        if (!this.sessionRunning.get()) {
            this.emuThread = new Thread(new EmulatorTask());
            this.emuThread.start();
        } else {
            logger.error((Object)"Should not try to start session again at this point... ");
        }
    }

    public boolean isSessionRunning() {
        return this.sessionRunning.get();
    }

    public String getBufferText(BufferType type) {
        return type.getValue(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.termPanel.getPixelWidth() + this.scrollBar.getPreferredSize().width, this.termPanel.getPixelHeight());
    }

    public void sendCommand(String string) throws IOException {
        if (this.sessionRunning.get()) {
            this.ttyChannel.sendBytes(string.getBytes());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BufferType {
        Back{

            String getValue(GrittyTerminal term) {
                return term.getTermPanel().getBackBuffer().getLines();
            }
        }
        ,
        BackStyle{

            String getValue(GrittyTerminal term) {
                return term.getTermPanel().getBackBuffer().getStyleLines();
            }
        }
        ,
        Damage{

            String getValue(GrittyTerminal term) {
                return term.getTermPanel().getBackBuffer().getDamageLines();
            }
        }
        ,
        Scroll{

            String getValue(GrittyTerminal term) {
                return term.getTermPanel().getScrollBuffer().getLines();
            }
        };


        abstract String getValue(GrittyTerminal var1);
    }

    class EmulatorTask
    implements Runnable {
        EmulatorTask() {
        }

        public void run() {
            try {
                GrittyTerminal.this.sessionRunning.set(true);
                Thread.currentThread().setName(GrittyTerminal.this.tty.getName());
                if (GrittyTerminal.this.tty.init(GrittyTerminal.this.preconnectHandler)) {
                    Thread.currentThread().setName(GrittyTerminal.this.tty.getName());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GrittyTerminal.this.termPanel.setKeyHandler(new ConnectedKeyHandler(GrittyTerminal.this.emulator));
                            GrittyTerminal.this.termPanel.requestFocusInWindow();
                        }
                    });
                    GrittyTerminal.this.emulator.start();
                }
            }
            finally {
                try {
                    GrittyTerminal.this.tty.close();
                }
                catch (Exception exception) {}
                GrittyTerminal.this.sessionRunning.set(false);
                GrittyTerminal.this.termPanel.setKeyHandler(GrittyTerminal.this.preconnectHandler);
            }
        }
    }
}

