/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import java.util.HashMap;
import java.util.Map;

public class CharacterUtils {
    public static final int NUL = 0;
    public static final int SOH = 1;
    public static final int STX = 2;
    public static final int ETX = 3;
    public static final int EOT = 4;
    public static final int ENQ = 5;
    public static final int ACK = 6;
    public static final int BEL = 7;
    public static final int BS = 8;
    public static final int TAB = 9;
    public static final int LF = 10;
    public static final int VT = 11;
    public static final int FF = 12;
    public static final int CR = 13;
    public static final int SO = 14;
    public static final int SI = 15;
    public static final int DLE = 16;
    public static final int DC1 = 17;
    public static final int DC2 = 18;
    public static final int DC3 = 19;
    public static final int DC4 = 20;
    public static final int NAK = 21;
    public static final int SYN = 22;
    public static final int ETB = 23;
    public static final int CAN = 24;
    public static final int EM = 25;
    public static final int SUB = 26;
    public static final int ESC = 27;
    public static final int FS = 28;
    public static final int GS = 29;
    public static final int RS = 30;
    public static final int US = 31;
    public static final int DEL = 127;
    private static final String[] NONPRINTING_NAMES = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "TAB", "LF", "VT", "FF", "CR", "S0", "S1", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US"};
    public static byte[] deviceAttributesResponse = CharacterUtils.makeCode(27, 91, 63, 54, 99);
    private static final Map<Integer, byte[]> codes = new HashMap<Integer, byte[]>();

    static {
        CharacterUtils.putCode(10, 13);
        CharacterUtils.putCode(38, 27, 79, 65);
        CharacterUtils.putCode(40, 27, 79, 66);
        CharacterUtils.putCode(39, 27, 79, 67);
        CharacterUtils.putCode(37, 27, 79, 68);
        CharacterUtils.putCode(112, 27, 79, 80);
        CharacterUtils.putCode(113, 27, 79, 81);
        CharacterUtils.putCode(114, 27, 79, 82);
        CharacterUtils.putCode(115, 27, 79, 83);
        CharacterUtils.putCode(116, 27, 79, 116);
        CharacterUtils.putCode(117, 27, 79, 117);
        CharacterUtils.putCode(118, 27, 79, 118);
        CharacterUtils.putCode(119, 27, 79, 73);
        CharacterUtils.putCode(120, 27, 79, 119);
        CharacterUtils.putCode(121, 27, 79, 120);
    }

    private CharacterUtils() {
    }

    public static CharacterType appendChar(StringBuffer sb, CharacterType last, char c) {
        if (c <= '\u001f') {
            sb.append(' ');
            sb.append(NONPRINTING_NAMES[c]);
            return CharacterType.NONPRINTING;
        }
        if (c == '\u007f') {
            sb.append(" DEL");
            return CharacterType.NONPRINTING;
        }
        if (c > '\u001f' && c <= '~') {
            if (last != CharacterType.PRINTING) {
                sb.append(' ');
            }
            sb.append(c);
            return CharacterType.PRINTING;
        }
        sb.append(" 0x").append(Integer.toHexString(c));
        return CharacterType.NONASCII;
    }

    public static void appendBuf(StringBuffer sb, byte[] bs, int begin, int length) {
        CharacterType last = CharacterType.NONPRINTING;
        int end = begin + length;
        int i = begin;
        while (i < end) {
            char c = (char)bs[i];
            last = CharacterUtils.appendChar(sb, last, c);
            ++i;
        }
    }

    static void putCode(int code, int ... bytesAsInt) {
        codes.put(code, CharacterUtils.makeCode(bytesAsInt));
    }

    private static byte[] makeCode(int ... bytesAsInt) {
        byte[] bytes = new byte[bytesAsInt.length];
        int i = 0;
        int[] nArray = bytesAsInt;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int byteAsInt = nArray[n];
            bytes[i] = (byte)byteAsInt;
            ++i;
            ++n;
        }
        return bytes;
    }

    public static byte[] getCode(int key) {
        return codes.get(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CharacterType {
        NONPRINTING,
        PRINTING,
        NONASCII,
        NONE;

    }
}

