/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressionUtil {
    private static final Log log = LogFactory.getLog(CompressionUtil.class);
    public static final String[] GZIP_EXTENSION = new String[]{".gz", ".gzip"};
    public static final String[] TAR_GZIP_EXTENSION = new String[]{".tgz", ".tar.gz"};
    public static final String[] BZIP2_EXTENSION = new String[]{".bz2", ".bzip2"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTarGZipArchive(Collection<File> files, String archiveName, String base) throws Exception {
        FileOutputStream fileOut = null;
        FilterOutputStream bOut = null;
        DeflaterOutputStream gzipOut = null;
        TarArchiveOutputStream tarOut = null;
        try {
            fileOut = new FileOutputStream(new File(archiveName));
            bOut = new BufferedOutputStream(fileOut);
            gzipOut = new GZIPOutputStream(bOut);
            tarOut = new TarArchiveOutputStream((OutputStream)gzipOut);
            for (File file : files) {
                CompressionUtil.addArchiveEntry(file, base, tarOut);
            }
        }
        finally {
            tarOut.close();
            gzipOut.close();
            bOut.close();
            fileOut.close();
        }
    }

    public static void createTarGZipArchive(Collection<File> files, String archiveName) throws Exception {
        CompressionUtil.createTarGZipArchive(files, archiveName, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(File file) throws Exception {
        byte[] byArray;
        FileInputStream fIn = null;
        ByteArrayOutputStream bOut = null;
        try {
            fIn = new FileInputStream(file);
            bOut = new ByteArrayOutputStream();
            CompressionUtil.decompress(fIn, bOut);
            byArray = bOut.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fIn);
            IOUtils.closeQuietly(bOut);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fIn);
        IOUtils.closeQuietly((OutputStream)bOut);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompressToFile(File compressedFile, File file) throws Exception {
        FileInputStream fIn = null;
        FileOutputStream fOut = null;
        try {
            fIn = new FileInputStream(compressedFile);
            fOut = new FileOutputStream(file);
            CompressionUtil.decompress(fIn, fOut);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fIn);
            IOUtils.closeQuietly(fOut);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fIn);
        IOUtils.closeQuietly((OutputStream)fOut);
    }

    protected static void decompress(InputStream in, OutputStream out) throws Exception {
        BufferedInputStream bIn = null;
        BufferedOutputStream bOut = null;
        CompressorInputStream cIn = null;
        try {
            bIn = new BufferedInputStream(in);
            bOut = new BufferedOutputStream(out);
            cIn = new CompressorStreamFactory().createCompressorInputStream((InputStream)bIn);
            IOUtils.copy((InputStream)cIn, (OutputStream)bOut);
        }
        catch (CompressorException ex) {
            try {
                log.error((Object)ex);
                throw new Exception(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bIn);
                IOUtils.closeQuietly(cIn);
                IOUtils.closeQuietly(bOut);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bIn);
        IOUtils.closeQuietly((InputStream)cIn);
        IOUtils.closeQuietly((OutputStream)bOut);
    }

    private static void addArchiveEntry(File file, String base, TarArchiveOutputStream tarOut) throws Exception {
        TarArchiveEntry entry = new TarArchiveEntry(file, base + file.getName());
        entry.setGroupName("root");
        entry.setUserName("root");
        tarOut.putArchiveEntry((ArchiveEntry)entry);
        if (file.isFile()) {
            IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)tarOut);
            tarOut.closeArchiveEntry();
        } else if (file.isDirectory()) {
            tarOut.closeArchiveEntry();
            for (File child : file.listFiles()) {
                CompressionUtil.addArchiveEntry(child, entry.getName(), tarOut);
            }
        }
    }
}

