/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.uboot;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

public class UBootEnvironment
implements Serializable {
    Properties settings;
    int availableSize;
    int usedSize;

    public UBootEnvironment(Properties settings, int usedSize, int availableSize) {
        this.settings = settings;
        this.usedSize = usedSize;
        this.availableSize = availableSize;
    }

    public UBootEnvironment(Properties settings) {
        this.settings = settings;
    }

    protected UBootEnvironment(UBootEnvironment env) {
        this.settings = new Properties();
        this.settings.putAll((Map<?, ?>)env.getSettings());
        this.usedSize = env.usedSize;
        this.availableSize = env.availableSize;
    }

    public Object clone() {
        return new UBootEnvironment(this);
    }

    public int getAvailableSize() {
        return this.availableSize;
    }

    public String getGateway() {
        return this.settings.getProperty("gatewayip");
    }

    public String getIPAddress() {
        return this.settings.getProperty("ipaddr");
    }

    public String getNetmask() {
        return this.settings.getProperty("netmask");
    }

    public String getServerAddress() {
        return this.settings.getProperty("serverip");
    }

    public Properties getSettings() {
        return this.settings;
    }

    public float getUsed() {
        return 100.0f / (float)this.availableSize * (float)this.usedSize;
    }

    public int getUsedSize() {
        return this.usedSize;
    }
}

