/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote;

import com.jcraft.jsch.ChannelExec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelnetSession {
    private static final Log log = LogFactory.getLog(TelnetSession.class);
    private ChannelExec channel;
    private InputStream in;
    private OutputStream out;

    protected TelnetSession(ChannelExec channel, InputStream in, OutputStream out) {
        this.channel = channel;
        this.in = in;
        this.out = out;
    }

    public void close() {
        IOUtils.closeQuietly((InputStream)this.in);
        IOUtils.closeQuietly((OutputStream)this.out);
        this.channel.disconnect();
    }

    public String executeCommand(String command) throws IOException {
        int i;
        String ret = "";
        if (command == null) {
            throw new UnsupportedOperationException("command can not be null!");
        }
        if (command.trim().equals("")) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"command is empty, close session");
            }
            this.close();
            return null;
        }
        command = command.trim() + "\n";
        this.out.write(command.getBytes());
        this.out.flush();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        byte[] tmp = new byte[1024];
        while (this.in.available() > 0 && (i = this.in.read(tmp, 0, 1024)) >= 0) {
            ret = ret + new String(tmp, 0, i);
        }
        return ret;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }
}

