/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScpClient
extends Observable {
    private static final Log log = LogFactory.getLog(ScpClient.class);
    private boolean run = true;
    private int transferTimeout = 0;

    public void cancel() {
        this.run = false;
    }

    public int getTransferTimeout() {
        return this.transferTimeout;
    }

    public void notifyPercent(int percent) {
        this.setChanged();
        this.notifyObservers(percent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized File scpFrom(String remoteFile, String localTargetDirectory, Session session) throws IOException, IllegalStateException {
        block42: {
            block41: {
                block39: {
                    block40: {
                        if (!session.isConnected()) {
                            throw new IllegalStateException("connection to infoman is not established");
                        }
                        this.run = true;
                        fos = null;
                        try {
                            channel = (ChannelExec)session.openChannel("exec");
                        }
                        catch (JSchException ex) {
                            throw new IOException("Could not open execution channel!", ex);
                        }
                        prefix = null;
                        remoteFile = this.getNormalFilename(remoteFile);
                        file = new File(remoteFile);
                        filename = file.getName();
                        remoteFile = ScpClient.getUnixConformFilename(remoteFile);
                        if (new File(localTargetDirectory).isDirectory()) {
                            prefix = localTargetDirectory + File.separator;
                        }
                        command = "scp -f " + remoteFile;
                        channel.setCommand(command);
                        out = channel.getOutputStream();
                        in = channel.getInputStream();
                        try {
                            session.setTimeout(this.transferTimeout);
                            if (ScpClient.log.isDebugEnabled()) {
                                ScpClient.log.debug((Object)("transferTimeout in milliseconds: " + session.getTimeout()));
                            }
                            channel.connect();
                        }
                        catch (JSchException ex) {
                            throw new IOException("Could not connect to execution channel", ex);
                        }
                        buf = new byte[1024];
                        buf[0] = 0;
                        out.write(buf, 0, 1);
                        out.flush();
lbl34:
                        // 2 sources

                        while (true) {
                            if (this.run && (c = this.checkAck(in)) == 67) {
                                in.read(buf, 0, 5);
                                filesize = 0L;
                                break block39;
                            }
                            if (!this.run) {
                                var13_17 = null;
                                return var13_17;
                            }
                            break block40;
                            break;
                        }
                        finally {
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (Exception ignore) {}
                        }
                    }
                    if (prefix == null) {
                        v0 = localTargetDirectory;
                        return new File(v0);
                    }
                    v0 = prefix + filename;
                    return new File(v0);
                }
                while (this.run && in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                if (!this.run) {
                    var16_21 = null;
                    return var16_21;
                }
                fullSize = filesize;
                if (ScpClient.log.isDebugEnabled()) {
                    ScpClient.log.debug((Object)("fullSize = " + fullSize));
                }
                i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) {
                        filename = new String(buf, 0, i);
                        buf[0] = 0;
                        out.write(buf, 0, 1);
                        out.flush();
                        if (prefix == null) {
                            break;
                        }
                        break block41;
                    }
                    ++i;
                }
                v1 = localTargetDirectory;
                break block42;
            }
            v1 = prefix + filename;
        }
        fos = new FileOutputStream(v1);
        read = 0.0f;
        while (this.run) {
            foo = (long)buf.length < filesize ? buf.length : (int)filesize;
            foo = in.read(buf, 0, foo);
            percent = (int)((read += (float)foo) / (float)fullSize * 100.0f);
            this.notifyPercent(percent);
            if (foo < 0) break;
            fos.write(buf, 0, foo);
            if ((filesize -= (long)foo) != 0L) continue;
        }
        if (!this.run) {
            var20_25 = null;
            return var20_25;
        }
        fos.close();
        fos = null;
        if (this.checkAck(in) != 0) {
            var20_26 = null;
            return var20_26;
        }
        buf[0] = 0;
        out.write(buf, 0, 1);
        out.flush();
        ** continue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void scpTo(String localFile, String remoteTargetDirectory, Session session) throws IOException, IllegalStateException {
        ChannelExec channel;
        if (!session.isConnected()) {
            throw new IllegalStateException("connection to infoman is not established");
        }
        this.run = true;
        localFile = this.getNormalFilename(localFile);
        File fileToSend = new File(localFile);
        FileInputStream fis = null;
        try {
            channel = (ChannelExec)session.openChannel("exec");
        }
        catch (JSchException ex) {
            throw new IOException("Could not open execution channel!", ex);
        }
        try {
            int len;
            String remoteFile = remoteTargetDirectory + (remoteTargetDirectory.endsWith("/") ? "" : "/") + ScpClient.getUnixConformFilename(fileToSend.getName());
            String command = "scp -p -t " + remoteFile;
            channel.setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            session.setTimeout(this.transferTimeout);
            if (log.isDebugEnabled()) {
                log.debug((Object)("transferTimeout in milliseconds: " + session.getTimeout()));
            }
            channel.connect();
            if (this.checkAck(in) != 0) {
                return;
            }
            long filesize = fileToSend.length();
            if (log.isDebugEnabled()) {
                log.debug((Object)("ScpTo: filesize = " + filesize));
            }
            command = "C0644 " + filesize + " ";
            command = localFile.lastIndexOf(47) > 0 ? command + localFile.substring(localFile.lastIndexOf(47) + 1) : command + localFile;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (this.checkAck(in) != 0) {
                return;
            }
            fis = new FileInputStream(fileToSend);
            byte[] buf = new byte[1024];
            float read = 0.0f;
            while (this.run && (len = fis.read(buf, 0, buf.length)) >= 0) {
                int percent = (int)((read += (float)len) / (float)filesize * 100.0f);
                this.notifyPercent(percent);
                out.write(buf, 0, len);
            }
            if (!this.run) {
                return;
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.checkAck(in) != 0) {
                return;
            }
            out.close();
            return;
        }
        catch (Exception ex) {
            throw new IOException("ScpClient.scpTo(...): Error during scp", ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    public synchronized void setTransferTimeout(int transferTimeout) {
        this.transferTimeout = transferTimeout;
    }

    protected String getNormalFilename(String filename) throws UnsupportedOperationException {
        if (filename == null || filename.trim().equals("")) {
            throw new UnsupportedOperationException("filename can not be null!");
        }
        filename = StringUtils.replace((String)filename, (String)"\\ ", (String)" ");
        return filename;
    }

    protected static String getUnixConformFilename(String filename) throws UnsupportedOperationException {
        if (filename == null || filename.trim().equals("")) {
            throw new UnsupportedOperationException("filename can not be null!");
        }
        filename = StringUtils.replace((String)filename, (String)" ", (String)"\\ ");
        filename = StringUtils.replace((String)filename, (String)"\\\\ ", (String)"\\ ");
        return filename;
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        switch (b) {
            case -1: 
            case 0: {
                return b;
            }
            case 1: 
            case 2: {
                int c;
                StringBuilder sb = new StringBuilder();
                if (b == 1) {
                    sb.append("ERROR: ");
                } else {
                    sb.append("FATAL: ");
                }
                do {
                    c = in.read();
                    sb.append((char)c);
                } while (c != 10);
                throw new IOException(sb.toString());
            }
        }
        return b;
    }
}

