/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import de.proveo.infoman.remote.CommandResponse;
import de.proveo.infoman.remote.SSHUserInfo;
import de.proveo.infoman.remote.ScpClient;
import de.proveo.infoman.remote.ShellWrapper;
import de.proveo.infoman.remote.Tail;
import de.proveo.infoman.remote.TelnetSession;
import de.proveo.infoman.remote.chat.Chat;
import de.proveo.infoman.remote.ssh.JSchShellWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfomanRAS {
    private static final Log log = LogFactory.getLog(InfomanRAS.class);
    public static final String INFOMAN_HOME_DIR = "/home/infoman/";
    public static final String INFOMAN_LOG_DIR = "/var/log/";
    public static final String INFOMAN_TEMP_DIR = "/tmp/";
    public static final String LOG_FILE_TYPE = "infoman.log";
    public static final String DEBUG_LOG_FILE_TYPE = "infoman-debug.log";
    public static final String INFOMAN_LOG_FILE = "/tmp/infoman.log.all";
    public static final String INFOMAN_DEBUG_LOG_FILE = "/tmp/infoman-debug.log.all";
    public static final String SEPARATOR = File.separator;
    public static final String SYSTEM_TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static final String GPS_CONFIG_FILE = "test.gps.properties";
    public static final String GPS_CONFIG_LINK = "gps.properties";
    public static final String INFOMAN_CONFIG_LINK = "infoman.properties";
    private static final String INFOMAN_VERSION_FILE = "/home/infoman/infomanService.sh";
    public static final String INFOMAN_INIT_SCRIPT = "createMinit.sh";
    private static final int DEFAULT_CONTROL_SOCKET_PORT = 8079;
    private static final String HOME_DIR = "/home";
    private static final String EXIT_SUFFIX = "exitCode=";
    protected static final int DEFAULT_TIMEOUT = 120000;
    public static final String CONFIG_BACKUP_ARCHIVE_NAME = "config.backup.tgz";
    private ChannelExec execChannel;
    private JSch jsch;
    private SSHUserInfo ui;
    private ScpClient scpClient;
    private Session session;
    private String cHost;
    private String cUser;
    private String host;
    private String localTargetDir;
    private String localTempDir = SYSTEM_TEMP_DIR;
    private String password;
    private String rPass;
    private String rUser;
    private String tunnelHost;
    private String tunnelPassword;
    private String tunnelUrl;
    private String tunnelUser;
    private String userName;
    private Vector<PortForwarder> portForwarder;
    private Vector<Session> tunnelSessions;
    private boolean connected;
    private boolean connecting;
    private boolean usePortForwarding;
    private boolean userDataSet;
    private final int DEFAULT_SSH_PORT = 22;
    private final int TELNET_PORT = 8079;
    private int cPort;
    private int connectingTimeout = 20000;
    private int port = 22;
    private int timeout = 120000;
    private int tunnelPort = 22;

    public InfomanRAS() {
        this.jsch = new JSch();
        this.scpClient = new ScpClient();
    }

    public void addPrivateKey(InputStream privateKey) throws IOException {
        this.addPrivateKey(new InputStreamReader(privateKey));
    }

    public void addPrivateKey(String privateKey, String passphrase) throws IOException {
        try {
            this.jsch.addIdentity(privateKey, passphrase);
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    public void addPrivateKey(String name, byte[] privateKey, byte[] publicKey, byte[] passphrase) throws IOException {
        try {
            this.jsch.addIdentity(name, privateKey, publicKey, passphrase);
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    public void addPrivateKey(File privateKey) throws FileNotFoundException, IOException {
        this.addPrivateKey(new FileReader(privateKey));
    }

    public void connect() throws IllegalStateException, IOException {
        if (!this.isUserDataSet()) {
            throw new IllegalStateException("UserData not set! I'm missing a username or the host to connect to");
        }
        this.cUser = this.userName;
        this.cHost = this.host;
        this.cPort = this.port;
        this.rUser = this.userName;
        this.rPass = "";
        if (this.ui == null) {
            log.warn((Object)"UserInfo is null, using default SSHUserInfo");
            this.ui = new SSHUserInfo();
        }
        if (this.isPortForwardingEnabled()) {
            this.createSessionWithPortForwarding();
        }
        try {
            this.session = this.jsch.getSession(this.userName, this.host, this.port);
            this.session.setConfig("StrictHostKeyChecking", "no");
        }
        catch (JSchException ex) {
            this.connected = false;
            this.connecting = false;
            this.disconnect();
            throw new IOException("Unable to get session for " + this.userName + "@" + this.host + ":" + this.port, ex);
        }
        this.ui.reInit();
        this.ui.setConnetingToUrl(this.cUser + "@" + this.cHost + ":" + this.cPort);
        if (this.password != null && !this.password.equals("")) {
            this.session.setPassword(this.password);
            this.ui.setPasswd(this.password);
        } else if (this.rPass != null && !this.rPass.equals("")) {
            this.session.setPassword(this.rPass);
            this.ui.setPasswd(this.rPass);
        }
        this.ui.setType(0);
        this.session.setUserInfo((UserInfo)this.ui);
        this.connecting = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connecting to " + this.userName + "@" + this.host + ":" + this.port));
        }
        try {
            this.session.connect(this.connectingTimeout);
            if (log.isDebugEnabled()) {
                log.debug((Object)("connectingTimeout in milliseconds: " + this.connectingTimeout));
            }
        }
        catch (JSchException ex) {
            this.connected = false;
            this.connecting = false;
            this.disconnect();
            throw new IOException("Can't connect to " + this.userName + "@" + this.host + ":" + this.port, ex);
        }
        this.connecting = false;
        this.connected = true;
    }

    public void connectHardcoded() throws IllegalStateException, IOException {
        this.userName = "root";
        this.port = 22;
        this.host = "10.0.0.30";
        this.cUser = this.userName;
        this.cHost = this.host;
        this.cPort = this.port;
        this.rUser = this.userName;
        this.rPass = "root";
        if (this.ui == null) {
            log.warn((Object)"UserInfo is null, using default SSHUserInfo");
            this.ui = new SSHUserInfo();
        }
        if (this.isPortForwardingEnabled()) {
            this.createSessionWithPortForwarding();
        }
        try {
            this.session = this.jsch.getSession(this.userName, this.host, this.port);
            this.session.setConfig("StrictHostKeyChecking", "no");
        }
        catch (JSchException ex) {
            this.connected = false;
            this.connecting = false;
            this.disconnect();
            throw new IOException("Unable to get session for " + this.userName + "@" + this.host + ":" + this.port, ex);
        }
        this.ui.reInit();
        this.ui.setConnetingToUrl(this.cUser + "@" + this.cHost + ":" + this.cPort);
        if (this.password != null && !this.password.equals("")) {
            this.session.setPassword(this.password);
            this.ui.setPasswd(this.password);
        } else if (this.rPass != null && !this.rPass.equals("")) {
            this.session.setPassword(this.rPass);
            this.ui.setPasswd(this.rPass);
        }
        this.ui.setType(0);
        this.session.setUserInfo((UserInfo)this.ui);
        this.connecting = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connecting to " + this.userName + "@" + this.host + ":" + this.port));
        }
        try {
            this.session.connect(this.connectingTimeout);
            if (log.isDebugEnabled()) {
                log.debug((Object)("connectingTimeout in milliseconds: " + this.connectingTimeout));
            }
        }
        catch (JSchException ex) {
            this.connected = false;
            this.connecting = false;
            this.disconnect();
            throw new IOException("Can't connect to " + this.userName + "@" + this.host + ":" + this.port, ex);
        }
        this.connecting = false;
        this.connected = true;
    }

    public void disconnect() {
        if (this.execChannel != null) {
            this.execChannel.disconnect();
        }
        if (this.session != null) {
            if (this.portForwarder != null) {
                try {
                    for (int s = 0; s < this.tunnelSessions.size(); ++s) {
                        this.tunnelSessions.get(s).delPortForwardingL(this.portForwarder.get(s).getLocalPort());
                    }
                    this.session.delPortForwardingL(this.portForwarder.get(this.portForwarder.size() - 1).getLocalPort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.session.disconnect();
        }
        this.connected = false;
    }

    public int executeCommand(String command) throws IllegalStateException, IOException {
        log.debug((Object)"executeCommand(String)...");
        CommandResponse response = this.executeCommandWithResponse(command);
        int erg = response.getExitStatus();
        String errString = response.getError();
        if (log.isDebugEnabled() && errString != null && !errString.trim().equals("")) {
            log.debug((Object)("executeCommand: errString = " + errString + " (exitCode: " + erg + ")"));
        }
        log.debug((Object)"executeCommand(String) done");
        return erg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResponse executeCommandWithResponse(String command) throws IllegalStateException, IOException {
        CommandResponse response = null;
        try {
            if (!command.endsWith(";")) {
                command = command + ";";
            }
            command = command + "echo \"" + EXIT_SUFFIX + "\"$?";
            log.debug((Object)"executeCommandWithResponse(String) call");
            this.isConnectedCheck();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Execute command: " + command));
            }
            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            ByteArrayOutputStream extoutputStream = new ByteArrayOutputStream();
            this.execChannel = (ChannelExec)this.session.openChannel("exec");
            this.execChannel.setCommand(command);
            this.execChannel.setErrStream((OutputStream)errorStream);
            this.execChannel.setOutputStream((OutputStream)responseStream);
            this.execChannel.setExtOutputStream((OutputStream)extoutputStream);
            long startTime = System.currentTimeMillis();
            this.execChannel.connect(this.connectingTimeout);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    while (!InfomanRAS.this.execChannel.isClosed()) {
                        try {
                            1.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            thread.start();
            StringBuilder out = null;
            do {
                log.debug((Object)"waiting for exit code");
                thread.join(1000L);
                out = command.startsWith("shutdown -r now") ? new StringBuilder("exitCode=0") : new StringBuilder(new String(responseStream.toByteArray()).trim());
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("channel closed: " + this.execChannel.isClosed()));
                log.trace((Object)("errorStream: '" + new String(errorStream.toByteArray()) + "'"));
                log.trace((Object)("responseStream: '" + new String(responseStream.toByteArray()) + "'"));
                log.trace((Object)("extoutputStream: '" + new String(extoutputStream.toByteArray()) + "'"));
            } while (out.lastIndexOf(EXIT_SUFFIX) < 0 && System.currentTimeMillis() - startTime < (long)this.timeout);
            if (out.lastIndexOf(EXIT_SUFFIX) < 0) {
                throw new IOException("timeout");
            }
            response = new CommandResponse(out.toString(), new String(extoutputStream.toByteArray()), this.extractExitCode(out));
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
        catch (JSchException ex) {
            if (!command.startsWith("shutdown -r now")) {
                throw new IOException("Error while executing command: " + command);
            }
        }
        finally {
            if (this.execChannel != null) {
                this.execChannel.disconnect();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)response.toString());
        }
        return response;
    }

    public Tail tail(String filename, int n) {
        return new Tail(this, filename, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getCompressedLogfile(String filter) throws IOException, IllegalStateException, IllegalArgumentException {
        int exe1;
        Object[] logfiles;
        log.trace((Object)"getCompressedLogfile(filter) call");
        File compressedFile = null;
        this.isConnectedCheck();
        CommandResponse resp1 = this.executeCommandWithResponse("ls /tmp/infoman.log.all.gz");
        if (resp1.getResponse().toLowerCase().trim().equals("/tmp/infoman.log.all.gz")) {
            this.executeCommand("rm -rf /tmp/infoman.log.all.gz");
            if (log.isDebugEnabled()) {
                log.debug((Object)"comand executed: rm -rf /tmp/infoman.log.all.gz");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"comand NOT executed: rm -rf /tmp/infoman.log.all.gz");
        }
        String resp2Str = null;
        CommandResponse resp2 = this.executeCommandWithResponse("cd /home/infoman/;ls -t | grep \"infoman.log.*\"");
        if (resp2.getExitStatus() != 0) {
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)"No log files available on Infoman");
            return null;
        }
        resp2Str = resp2.getResponse();
        if (log.isDebugEnabled()) {
            log.debug((Object)("resp2Str=" + resp2Str));
        }
        if ((logfiles = this.toStringArrayRevert(resp2Str)).length <= 0) return compressedFile;
        String fileQueue = InfomanRAS.toString(logfiles, " ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("fileQueue: " + fileQueue));
        }
        String grepStr = "| grep -i \"" + filter + "\"";
        if (filter != null && !filter.equals("")) {
            exe1 = this.executeCommand("cd /home/infoman/;cat " + fileQueue + " " + grepStr + " | gzip -9 > " + INFOMAN_LOG_FILE + ".gz");
            if (log.isDebugEnabled()) {
                log.debug((Object)("with grep --> cd /home/infoman/;cat " + fileQueue + " " + grepStr + " | gzip -9 > " + INFOMAN_LOG_FILE + ".gz"));
            }
        } else {
            exe1 = this.executeCommand("cd /home/infoman/;cat " + fileQueue + " | gzip -9 > " + INFOMAN_LOG_FILE + ".gz");
            if (log.isDebugEnabled()) {
                log.debug((Object)("without grep --> cd /home/infoman/;cat " + fileQueue + " | gzip -9 > " + INFOMAN_LOG_FILE + ".gz"));
            }
        }
        if (exe1 != 0) throw new IOException("Can't compress the infoman log file /tmp/infoman.log.all");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating of compressed log file /tmp/infoman.log.all.gz successful");
        }
        if (this.localTargetDir == null || this.localTargetDir.equals("") || !new File(this.localTargetDir).exists()) throw new IllegalArgumentException("getCompressedLogfile(String filter): local target directory is not set or its name is \"\" (empty)");
        if (this.localTargetDir.startsWith(SYSTEM_TEMP_DIR)) {
            this.setLocalTempDir(this.localTargetDir);
            if (log.isDebugEnabled()) {
                log.debug((Object)("compressed log file will be downloaded to directory: " + this.getLocalTempDir()));
            }
        }
        compressedFile = this.scpClient.scpFrom("/tmp/infoman.log.all.gz", this.localTargetDir, this.session);
        if (this.localTargetDir.startsWith(SYSTEM_TEMP_DIR)) {
            log.debug((Object)"localTargetDir == temporary directory");
            compressedFile.deleteOnExit();
        } else {
            log.debug((Object)"localTargetDir != temporary directory");
        }
        if (compressedFile == null) throw new IOException("download of compressed infoman log file failed");
        int exe2 = this.executeCommand("rm -rf /tmp/infoman.log.all.gz");
        if (log.isDebugEnabled()) {
            log.debug((Object)("rm -rf /tmp/infoman.log.all.gz --> int exe2 = " + exe2));
        }
        if (exe2 != 0) throw new IOException("Can't remove /tmp/infoman.log.all.gz from infoman");
        if (!log.isDebugEnabled()) return compressedFile;
        log.debug((Object)"removed from infoman: /tmp/infoman.log.all");
        return compressedFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getCompressedLogfile(String filter, String logfileType) throws IOException, IllegalStateException, IllegalArgumentException {
        int exe1;
        log.trace((Object)"getCompressedLogfile(filter, fileType) call");
        File compressedFile = null;
        String logfileDir = "";
        String logfilePart = "";
        String logfileFullName = "";
        if (logfileType == null) return this.getCompressedLogfile(filter);
        if (logfileType.length() <= 0) return this.getCompressedLogfile(filter);
        if (logfileType.equals(LOG_FILE_TYPE)) {
            logfileDir = INFOMAN_HOME_DIR;
            logfileFullName = INFOMAN_LOG_FILE;
        } else {
            if (!logfileType.equals(DEBUG_LOG_FILE_TYPE)) throw new IllegalArgumentException("wrong logfile type: " + logfileType);
            logfileDir = INFOMAN_LOG_DIR;
            logfileFullName = INFOMAN_DEBUG_LOG_FILE;
        }
        logfilePart = logfileType + ".*";
        this.isConnectedCheck();
        CommandResponse resp1 = this.executeCommandWithResponse("ls " + logfileFullName + ".gz");
        if (resp1.getResponse().toLowerCase().trim().equals(logfileFullName + ".gz")) {
            this.executeCommand("rm -rf " + logfileFullName + ".gz");
            if (log.isDebugEnabled()) {
                log.debug((Object)("comand executed: rm -rf " + logfileFullName + ".gz"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("comand NOT executed: rm -rf " + logfileFullName + ".gz"));
        }
        CommandResponse resp2 = this.executeCommandWithResponse("cd " + logfileDir + ";ls -t | grep \"" + logfilePart + "\"");
        String resp2Str = resp2.getResponse();
        if (log.isDebugEnabled()) {
            log.debug((Object)("String resp2Str = " + resp2Str));
        }
        Object[] logfiles = null;
        if (resp2.getExitStatus() != 1) {
            logfiles = this.toStringArrayRevert(resp2Str);
        }
        if (logfiles == null || logfiles.length <= 0) throw new FileNotFoundException("infoman logfile isn't present on the infoman");
        String fileQueue = InfomanRAS.toString(logfiles, " ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("fileQueue: " + fileQueue));
        }
        String grepStr = "| grep -i \"" + filter + "\"";
        if (filter != null && !filter.equals("")) {
            exe1 = this.executeCommand("cd " + logfileDir + ";" + "cat " + fileQueue + " " + grepStr + " | gzip -9 > " + logfileFullName + ".gz");
            if (log.isDebugEnabled()) {
                log.debug((Object)("with grep --> cd " + logfileDir + ";" + "cat " + fileQueue + " " + grepStr + " | gzip -9 > " + logfileFullName + ".gz"));
            }
        } else {
            exe1 = this.executeCommand("cd " + logfileDir + ";" + "cat " + fileQueue + " | gzip -9 > " + logfileFullName + ".gz");
            if (log.isDebugEnabled()) {
                log.debug((Object)("without grep --> cd " + logfileDir + ";" + "cat " + fileQueue + " | gzip -9 > " + logfileFullName + ".gz"));
            }
        }
        if (exe1 != 0) throw new IOException("Can't compress the infoman log file " + logfileFullName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating of compressed log file " + logfileFullName + ".gz successful"));
        }
        if (this.localTargetDir == null || this.localTargetDir.equals("") || !new File(this.localTargetDir).exists()) throw new IllegalArgumentException("getCompressedLogfile(String filter): local target directory is not set or its name is \"\" (empty)");
        if (this.localTargetDir.startsWith(SYSTEM_TEMP_DIR)) {
            this.setLocalTempDir(this.localTargetDir);
            if (log.isDebugEnabled()) {
                log.debug((Object)("compressed log file will be downloaded to directory: " + this.getLocalTempDir()));
            }
        }
        compressedFile = this.scpClient.scpFrom(logfileFullName + ".gz", this.localTargetDir, this.session);
        if (this.localTargetDir.startsWith(SYSTEM_TEMP_DIR)) {
            log.debug((Object)"localTargetDir == temporary directory");
            compressedFile.deleteOnExit();
        } else {
            log.debug((Object)"localTargetDir != temporary directory");
        }
        if (compressedFile == null) throw new IOException("download of compressed infoman log file failed");
        int exe2 = this.executeCommand("rm -rf " + logfileFullName + ".gz");
        if (log.isDebugEnabled()) {
            log.debug((Object)("rm -rf " + logfileFullName + ".gz --> " + "int exe2 = " + exe2));
        }
        if (exe2 != 0) throw new IOException("Can't remove " + logfileFullName + ".gz from infoman");
        if (!log.isDebugEnabled()) return compressedFile;
        log.debug((Object)("removed from infoman: " + logfileFullName));
        return compressedFile;
    }

    public File getCompressedLogfileToSystemTempDir(String filter) throws IOException, IllegalStateException, IllegalArgumentException {
        this.setLocalTargetDir(SYSTEM_TEMP_DIR);
        return this.getCompressedLogfile(filter);
    }

    public File getCompressedLogfileToSystemTempDir(String filter, String logfileType) throws IOException, IllegalStateException, IllegalArgumentException {
        this.setLocalTargetDir(SYSTEM_TEMP_DIR);
        return this.getCompressedLogfile(filter, logfileType);
    }

    public File getCompressedLogfileToTempDir(String tmp, String filter) throws IOException, IllegalStateException, IllegalArgumentException {
        this.setLocalTempDir(tmp);
        this.setLocalTargetDir(this.localTempDir);
        return this.getCompressedLogfile(filter);
    }

    public File getCompressedLogfileToTempDir(String tmp, String filter, String logfileType) throws IOException, IllegalStateException, IllegalArgumentException {
        this.setLocalTempDir(tmp);
        this.setLocalTargetDir(this.localTempDir);
        return this.getCompressedLogfile(filter, logfileType);
    }

    public File getConfiguration() throws IOException, IllegalStateException, IllegalArgumentException {
        log.debug((Object)"getConfiguration() ...");
        File configFile = null;
        this.isConnectedCheck();
        CommandResponse response = this.executeCommandWithResponse("cd /home/infoman/;readlink infoman.properties");
        if (response.getExitStatus() != 0) {
            log.error((Object)("unable to get the real property name from link: " + (response.getError() != null && !response.getError().equals("") ? response.getError() : Integer.valueOf(response.getExitStatus())) + " (" + response.getResponse() + ")"));
            response = this.executeCommandWithResponse("cd /home/infoman/;ls infoman.properties");
            if (response.getExitStatus() != 0) {
                throw new IOException("unable to find the property: " + (response.getError() != null && !response.getError().equals("") ? response.getError() : Integer.valueOf(response.getExitStatus())) + " (" + response.getResponse() + ")");
            }
        }
        String realPropName = response.getResponse();
        if ((realPropName = ScpClient.getUnixConformFilename(realPropName)) != null || !realPropName.trim().equals("")) {
            if (realPropName.trim().equals("")) {
                return null;
            }
            if (!realPropName.startsWith(INFOMAN_HOME_DIR)) {
                realPropName = INFOMAN_HOME_DIR + realPropName;
            }
            if (this.localTargetDir == null || this.localTargetDir.equals("")) {
                throw new IllegalArgumentException("getConfiguration(): local target directory is not set or its name is \"\" (empty)");
            }
            configFile = this.scpClient.scpFrom(realPropName, this.localTargetDir, this.session);
            if (configFile != null && log.isDebugEnabled()) {
                log.debug((Object)("download of the current infoman configuration file " + configFile.getName() + " successful"));
            }
        } else {
            throw new IOException("Can't read the name of infoman configuration file");
        }
        log.debug((Object)"getConfiguration() done");
        return configFile;
    }

    public int getConnectingTimeout() {
        return this.connectingTimeout;
    }

    public Session getCurrentSession() {
        return this.session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getGPSConfiguration() throws IOException, IllegalStateException, IllegalArgumentException {
        File gpsConfigFile = null;
        this.isConnectedCheck();
        CommandResponse response = this.executeCommandWithResponse("cd /home/infoman/; readlink test.gps.properties");
        if (response.getExitStatus() != 0) {
            throw new IOException("unable to get the real property name from link" + response.getError() != null ? ": " + response.getError() : "");
        }
        String realPropName = response.getResponse();
        if ((realPropName = ScpClient.getUnixConformFilename(realPropName)) == null && realPropName.trim().equals("")) throw new IOException("Can't read the name of GPS configuration file");
        if (realPropName.trim().equals("")) {
            return null;
        }
        if (!realPropName.startsWith(INFOMAN_HOME_DIR)) {
            realPropName = INFOMAN_HOME_DIR + realPropName;
        }
        if (this.localTargetDir == null || this.localTargetDir.equals("")) throw new IllegalArgumentException("getGPSConfiguration(): local target directory is not set or its name is \"\" (empty)");
        gpsConfigFile = this.scpClient.scpFrom(realPropName, this.localTargetDir, this.session);
        if (gpsConfigFile != null && log.isDebugEnabled()) {
            log.debug((Object)("download of the current gps configuration file " + gpsConfigFile.getName() + " successful"));
        }
        if (this.localTargetDir.equalsIgnoreCase(SYSTEM_TEMP_DIR)) {
            log.debug((Object)"localTargetDir == SYSTEM_TEMP_DIR");
            gpsConfigFile.deleteOnExit();
            return gpsConfigFile;
        } else {
            log.debug((Object)"localTargetDir != SYSTEM_TEMP_DIR");
        }
        return gpsConfigFile;
    }

    public String getHost() {
        return this.host;
    }

    public String getInfomanVersion() throws IOException, IllegalStateException {
        String infomanVersion = null;
        File versionFile = null;
        this.isConnectedCheck();
        int exe1 = this.executeCommand("cd /home/infoman/");
        if (exe1 == 0) {
            versionFile = this.scpClient.scpFrom(INFOMAN_VERSION_FILE, SYSTEM_TEMP_DIR, this.session);
            if (log.isDebugEnabled()) {
                log.debug((Object)("download of the current infoman version file " + versionFile.getName() + " successful"));
            }
            FileReader in = new FileReader(versionFile);
            String fileText = InfomanRAS.file2String(in);
            in.close();
            int begin = InfomanRAS.indexOfString(fileText, "infoman-main-".trim());
            int end = InfomanRAS.indexOfString(fileText, ".jar".trim());
            infomanVersion = fileText.substring(begin + "infoman-main-".length(), end).trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("info: current infoman version = " + infomanVersion));
            }
        }
        return infomanVersion;
    }

    public int getLastPortInTunnel() {
        if (this.portForwarder == null) {
            return -1;
        }
        return this.portForwarder.get(this.portForwarder.size() - 1).getLocalPort();
    }

    public String getLocalTargetDir() {
        if (this.localTargetDir.startsWith(SEPARATOR)) {
            return this.localTargetDir;
        }
        return SEPARATOR + this.localTargetDir;
    }

    public String getLocalTempDir() {
        if (this.localTempDir.startsWith(SEPARATOR)) {
            return this.localTempDir;
        }
        return SEPARATOR + this.localTempDir;
    }

    public InputStream getLogInputStream(Object filter) throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("not supported in this version, maybe later");
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public Vector<PortForwarder> getPortForwarder() {
        return this.portForwarder;
    }

    public ScpClient getScpClient() {
        return this.scpClient;
    }

    public List<Properties> getStoredEvents() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("not supported in this version, maybe later");
    }

    public TelnetSession getTelnetSession() throws IllegalStateException, IOException {
        String command = "telnet localhost 8079";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStream telnetOut = null;
        InputStream telnetIn = null;
        this.isConnectedCheck();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Open telnet session");
        }
        try {
            this.execChannel = (ChannelExec)this.session.openChannel("exec");
            this.execChannel.setCommand(command);
            this.execChannel.setInputStream(null);
            this.execChannel.setOutputStream(null);
            this.execChannel.setErrStream((OutputStream)out);
            telnetOut = this.execChannel.getOutputStream();
            telnetIn = this.execChannel.getInputStream();
            this.execChannel.connect(this.connectingTimeout);
        }
        catch (JSchException ex) {
            throw new IOException("Error while opening telnet session", ex);
        }
        return new TelnetSession(this.execChannel, telnetIn, telnetOut);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTransferTimeout() {
        return this.scpClient.getTransferTimeout();
    }

    public String getTunnelHost() {
        if (this.portForwarder == null) {
            return null;
        }
        return this.tunnelHost;
    }

    public String getTunnelUrl() {
        return this.tunnelUrl;
    }

    public String getUser() {
        return this.userName;
    }

    public void installFiles(File updateArchive) throws IllegalStateException, IOException {
        log.debug((Object)"installFiles(File) ...");
        this.isConnectedCheck();
        this.scpClient.scpTo(new String(updateArchive.getAbsolutePath()), INFOMAN_TEMP_DIR, this.session);
        this.executeCommand("tar --directory=/ -xzf /tmp/" + updateArchive.getName());
        log.debug((Object)"untar file successful");
        log.debug((Object)"installation successful");
        log.debug((Object)"installFiles(File) done");
    }

    public boolean isConfigurationPresent() throws IOException, IllegalStateException, IllegalArgumentException {
        this.isConnectedCheck();
        log.debug((Object)"Checking if configuration is present");
        CommandResponse response = this.executeCommandWithResponse("cd /home/infoman/;readlink infoman.properties");
        if (response.getExitStatus() != 0) {
            return false;
        }
        String realPropName = response.getResponse();
        realPropName = ScpClient.getUnixConformFilename(realPropName);
        int ret = this.executeCommand("cd /home/infoman/;ls " + realPropName);
        if (ret == 0) {
            log.debug((Object)"Configuration seems to be present");
            return true;
        }
        log.error((Object)"Configuration seems not to be present");
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isPortForwardingEnabled() {
        return this.usePortForwarding;
    }

    public boolean isUserDataSet() {
        return this.userDataSet;
    }

    public ShellWrapper openShell(InputStream in, OutputStream out) throws IOException {
        try {
            Channel channel = this.session.openChannel("shell");
            channel.setInputStream(in);
            channel.setOutputStream(out);
            channel.connect(this.connectingTimeout);
            return new JSchShellWrapper(channel);
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    public void rebootInfoman(String message) throws IllegalStateException, IOException {
        log.debug((Object)"reboot infoman (String) ...");
        this.isConnectedCheck();
        String command = "SaveAndReboot";
        if (message != null && !message.trim().equals("")) {
            command = command + " " + message.trim();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Rebooting infoman");
        }
        TelnetSession telnet = this.getTelnetSession();
        try {
            telnet.executeCommand(command);
            boolean infomanIsStillConnected = true;
            try {
                this.executeCommand("readlink /home/infoman/infoman.properties");
            }
            catch (Exception ex) {
                infomanIsStillConnected = false;
            }
            if (infomanIsStillConnected) {
                throw new IOException("Could not reboot infoman via telnet!");
            }
        }
        catch (IOException ex) {
            throw new IOException("Error while rebooting infoman", ex);
        }
        finally {
            telnet.close();
            this.execChannel.disconnect();
        }
        this.disconnect();
        log.debug((Object)"infoman will reboot");
    }

    public void rebootInfoman() throws IllegalStateException, IOException {
        CommandResponse response;
        String errString;
        String command = "shutdown -r now";
        if (log.isDebugEnabled()) {
            log.debug((Object)"Rebooting infoman");
        }
        if (!(errString = (response = this.executeCommandWithResponse(command)).getError()).equals("")) {
            if (log.isErrorEnabled()) {
                log.error((Object)errString);
            }
        } else {
            this.disconnect();
            log.info((Object)"infoman will reboot");
        }
    }

    public void setConnectingTimeout(int timeout) {
        this.connectingTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfomanPassword(char[] newPassword) throws Exception {
        Channel shell = this.session.openChannel("shell");
        PipedInputStream pIn = new PipedInputStream();
        PipedOutputStream toInfoman = new PipedOutputStream(pIn);
        PipedOutputStream pOut2 = new PipedOutputStream();
        PipedInputStream fromInfoman = new PipedInputStream(pOut2);
        Chat chat = new Chat(fromInfoman, toInfoman);
        try {
            shell.setInputStream((InputStream)pIn);
            shell.setOutputStream((OutputStream)pOut2);
            shell.connect(60000);
            chat.start();
            chat.send(String.format("passwd %s\n", this.getUser()));
            chat.expect("Enter new password:", 60000);
            chat.send(new String(newPassword) + "\n");
            chat.expect("Re-enter new password:", 60000);
            chat.send(new String(newPassword) + "\n");
            chat.expect("Password changed.", 60000);
        }
        finally {
            chat.stop();
            toInfoman.close();
            fromInfoman.close();
            shell.disconnect();
        }
    }

    public void setKnownHosts(InputStream stream) throws IOException {
        try {
            this.jsch.setKnownHosts(stream);
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    public void setKnownHosts(String filename) throws IOException {
        try {
            this.jsch.setKnownHosts(filename);
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    public void setLocalTargetDir(String localTargetDir) {
        this.localTargetDir = localTargetDir;
    }

    public void setLocalTempDir(String tempDir) {
        this.localTempDir = tempDir == null || tempDir.equals("") ? SYSTEM_TEMP_DIR : (tempDir.startsWith(SYSTEM_TEMP_DIR) ? (!tempDir.trim().equals(SYSTEM_TEMP_DIR) ? tempDir.trim() : SYSTEM_TEMP_DIR) : (tempDir.startsWith(SEPARATOR) ? SYSTEM_TEMP_DIR + tempDir : SYSTEM_TEMP_DIR + SEPARATOR + tempDir));
    }

    public void setPortForwarder(Vector<PortForwarder> portForwarder) {
        this.portForwarder = portForwarder;
    }

    public void setPortForwardingEnabled(boolean usePortForwarding) {
        this.usePortForwarding = usePortForwarding;
    }

    public void setSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("parameter must not be null!");
        }
        this.session = session;
        this.connected = session.isConnected();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTransferTimeout(int transferTimeout) {
        this.scpClient.setTransferTimeout(transferTimeout);
    }

    public void setTunnelClient(String url) {
        this.tunnelUrl = url;
        if (url.contains("@")) {
            this.parseTunnelWithUser(url);
        } else {
            this.parseTunnelURL(url);
            this.tunnelUser = "root";
            this.tunnelPassword = null;
        }
    }

    public void setURL(String url) {
        if (url.contains("@")) {
            this.parseWithUser(url);
        } else {
            this.parseURL(url);
            this.setUser("root");
            this.setPassword(null);
        }
    }

    public void setUserInfo(SSHUserInfo userInfo) {
        this.ui = userInfo;
    }

    public void updateConfiguration(File configuration) throws IllegalStateException, IOException {
        this.uploadConfigFile(configuration, INFOMAN_CONFIG_LINK);
    }

    public void updateConfiguration(File configuration, File checksumFile) throws IllegalStateException, IOException {
        this.isConnectedCheck();
        if (configuration == null || !configuration.exists() || checksumFile == null || !checksumFile.exists()) {
            throw new IOException("updateConfiguration(File,File): parameters are null or don't exist");
        }
        this.scpClient.scpTo(checksumFile.getAbsolutePath(), INFOMAN_TEMP_DIR, this.session);
        this.uploadConfigFile(configuration, INFOMAN_CONFIG_LINK, checksumFile);
    }

    public void updateGPSconfiguration(File gpsConfiguration, File checksumFile) throws IllegalStateException, IOException {
        this.isConnectedCheck();
        if (gpsConfiguration == null || !gpsConfiguration.exists() || checksumFile == null || !checksumFile.exists()) {
            throw new IOException("updateGPSconfiguration(File,File): parameters are null or don't exist");
        }
        this.scpClient.scpTo(checksumFile.getAbsolutePath(), INFOMAN_TEMP_DIR, this.session);
        this.uploadConfigFile(gpsConfiguration, GPS_CONFIG_LINK, checksumFile);
    }

    public void updateGPSconfiguration(File gpsConfiguration) throws IllegalStateException, IOException {
        this.uploadConfigFile(gpsConfiguration, GPS_CONFIG_LINK);
    }

    public void updateInfomanSoftware(File infomanArchive) throws IOException, IllegalStateException {
        this.uploadInfomanSoftware(infomanArchive, null);
    }

    public void updateInfomanSoftware(File infomanArchive, boolean isInit) throws IOException, IllegalStateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateInfomanSoftware(File, isInit = " + isInit + ")"));
        }
        this.updateInfomanSoftware(infomanArchive);
        if (isInit) {
            this.startMinitScript();
        }
    }

    public void updateInfomanSoftware(File infomanArchive, File checksumFile) throws IOException, IllegalStateException {
        this.isConnectedCheck();
        if (infomanArchive == null || !infomanArchive.exists() || checksumFile == null || !checksumFile.exists()) {
            throw new IOException("updateInfomanSoftware (File,File): parameters are null or don't exist");
        }
        this.scpClient.scpTo(checksumFile.getAbsolutePath(), INFOMAN_TEMP_DIR, this.session);
        this.uploadInfomanSoftware(infomanArchive, checksumFile);
    }

    public void updateInfomanSoftware(File infomanArchive, File checksumFile, boolean isInit) throws IOException, IllegalStateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateInfomanSoftware(File, File, isInit = " + isInit + ")"));
        }
        this.updateInfomanSoftware(infomanArchive, checksumFile);
        if (isInit) {
            this.startMinitScript();
        }
    }

    protected int extractExitCode(StringBuilder out) {
        int exitCodePos = out.lastIndexOf(EXIT_SUFFIX);
        int exitCode = Integer.parseInt(out.substring(exitCodePos + EXIT_SUFFIX.length(), out.length()).trim());
        out.delete(exitCodePos, out.length());
        return exitCode;
    }

    protected void isConnectedCheck() {
        if (!this.isConnected()) {
            throw new IllegalStateException("infoman is not connected");
        }
    }

    protected boolean isFileExists(CommandResponse resp, String filename) {
        if (resp.getExitStatus() != 0) {
            return false;
        }
        return resp.getResponse().contains(filename);
    }

    protected boolean isFileExists(String filename) throws IOException, IllegalStateException {
        this.isConnectedCheck();
        CommandResponse resp = this.executeCommandWithResponse("ls " + filename);
        return this.isFileExists(resp, filename);
    }

    private int compareChecksum(File checksum) throws IllegalStateException, IOException {
        String checkSumFilename = ScpClient.getUnixConformFilename(checksum.getName());
        int check = -1;
        if (checksum.getName().endsWith("SHA") || checksum.getName().endsWith("sha")) {
            check = this.executeCommand("cd /tmp/;sha1sum -c " + checkSumFilename);
        } else if (checksum.getName().endsWith("MD5") || checksum.getName().endsWith("md5")) {
            check = this.executeCommand("cd /tmp/;md5sum -c " + checkSumFilename);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("int check = " + check));
        }
        return check;
    }

    private void createSessionWithPortForwarding() throws IllegalStateException, IOException {
        log.trace((Object)"createSessionWithPortForwarding() call");
        this.cUser = this.tunnelUser;
        this.cHost = this.tunnelHost;
        this.cPort = this.tunnelPort;
        this.tunnelSessions = new Vector();
        try {
            this.session = this.jsch.getSession(this.cUser, this.cHost, this.cPort);
            this.session.setConfig("StrictHostKeyChecking", "no");
        }
        catch (JSchException ex) {
            this.connected = false;
            this.connecting = false;
            this.disconnect();
            throw new IOException("Unable to get session for " + this.cUser + "@" + this.cHost + ":" + this.cPort, ex);
        }
        this.session.setPassword(this.tunnelPassword);
        this.ui.reInit();
        this.ui.setConnetingToUrl(this.cUser + "@" + this.cHost + ":" + this.cPort);
        this.ui.setPasswd(this.tunnelPassword);
        if (this.tunnelHost.equalsIgnoreCase("localhost") || this.tunnelHost.equals("127.0.0.1")) {
            this.ui.setType(3);
        } else {
            this.ui.setType(1);
        }
        this.session.setUserInfo((UserInfo)this.ui);
        this.connecting = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connecting to " + this.cUser + "@" + this.cHost + ":" + this.cPort));
        }
        try {
            this.session.connect(this.connectingTimeout);
        }
        catch (JSchException ex) {
            this.connected = false;
            this.connecting = false;
            this.disconnect();
            throw new IOException("Can't connect to " + this.cUser + "@" + this.cHost + ":" + this.cPort, ex);
        }
        this.tunnelSessions.add(this.session);
        for (int i = 0; i < this.portForwarder.size(); ++i) {
            PortForwarder p = this.portForwarder.get(i);
            int lPort = p.getLocalPort();
            String rHost = p.getRemoteHost();
            if (rHost.contains("@")) {
                this.rUser = rHost.split("@")[0];
                if (this.rUser.contains(":")) {
                    this.rPass = this.rUser.split(":")[1];
                    this.rUser = this.rUser.split(":")[0];
                }
                rHost = rHost.split("@")[1];
            }
            int rPort = p.getRemotePort();
            int assinged_port = lPort;
            try {
                assinged_port = this.session.setPortForwardingL(lPort, rHost, rPort);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("localhost:" + assinged_port + " -> " + rHost + ":" + rPort));
                }
            }
            catch (JSchException ex) {
                this.connected = false;
                this.connecting = false;
                this.disconnect();
                throw new IOException("Unable to add local port forwarding (localhost:" + assinged_port + " -> " + rHost + ":" + rPort + ")", ex);
            }
            this.cUser = this.rUser;
            this.cHost = rHost;
            this.cPort = rPort;
            if (i == this.portForwarder.size() - 1) break;
            try {
                this.session = this.jsch.getSession(this.cUser, "localhost", assinged_port);
                this.session.setConfig("StrictHostKeyChecking", "no");
            }
            catch (JSchException ex) {
                this.connected = false;
                this.connecting = false;
                this.disconnect();
                throw new IOException("Unable to get session for " + this.cUser + "@localhost:" + assinged_port, ex);
            }
            this.ui.reInit();
            this.ui.setType(2);
            this.ui.setConnetingToUrl(this.cUser + "@" + this.cHost + ":" + this.cPort);
            if (this.rPass != null && !this.rPass.equals("")) {
                this.session.setPassword(this.rPass);
                this.ui.setPasswd(this.rPass);
            }
            this.session.setUserInfo((UserInfo)this.ui);
            this.connecting = true;
            if (log.isDebugEnabled()) {
                log.info((Object)("Connecting to " + this.cUser + "@localhost:" + assinged_port));
            }
            try {
                this.session.connect(this.connectingTimeout);
            }
            catch (JSchException ex) {
                this.connected = false;
                this.connecting = false;
                this.disconnect();
                throw new IOException("Can't connect to " + this.cUser + "@localhost:" + assinged_port, ex);
            }
            this.rPass = this.ui.getPassword();
            this.tunnelSessions.add(this.session);
        }
        log.trace((Object)"createSessionWithPortForwarding() done");
    }

    private static String file2String(FileReader in) throws IOException {
        StringBuilder builder = new StringBuilder();
        int bytesCounter = 0;
        char[] bytesBlock = new char[512];
        while ((bytesCounter = in.read(bytesBlock)) > 0) {
            builder.append(bytesBlock, 0, bytesCounter);
        }
        return builder.toString();
    }

    private long getCompressedLogfileSize() throws IOException, IllegalArgumentException {
        long fileSize;
        CommandResponse resp = this.executeCommandWithResponse("ls -al /tmp/infoman.log.all.gz | awk '{ print $5}'");
        if (resp.getExitStatus() == 0) {
            fileSize = Long.parseLong(resp.getResponse().trim());
            if (log.isDebugEnabled()) {
                log.debug((Object)("resp.getResponse().trim(): " + resp.getResponse().trim()));
                log.debug((Object)("size of compressed logfile (bytes): " + fileSize));
            }
            if (fileSize == 0L) {
                throw new IllegalArgumentException("compressed infoman logfile is empty (file size is \"0\" ");
            }
        } else {
            throw new IOException("cannot get size of compressed infoman logfile");
        }
        return fileSize;
    }

    private static int indexOfString(String text, String searched) {
        return InfomanRAS.indexOfString(text, searched, 0);
    }

    private static int indexOfString(String text, String searched, int pos) {
        String version = null;
        int lenText = text.length();
        int lenSearched = searched.length();
        int found = pos;
        while (!((found = text.indexOf(searched.charAt(0), found)) == -1 || found + lenSearched <= lenText && (version = text.substring(found, found + lenSearched)).equals(searched))) {
            ++found;
        }
        return found;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkInfomanHomeDir() throws IOException {
        log.trace((Object)"\ncheckInfomanHomeDir() call");
        boolean homeDirExist = false;
        CommandResponse lsHomeDir = this.executeCommandWithResponse("ls -d /home");
        if (lsHomeDir.getError().trim().equalsIgnoreCase("ls: /home: No such file or directory")) {
            CommandResponse mkHomeInfomanDir;
            CommandResponse mkHomeDir = this.executeCommandWithResponse("mkdir -p /home");
            if (mkHomeDir.getExitStatus() != 0) throw new IOException("Can't create directory /home");
            if (log.isTraceEnabled()) {
                log.trace((Object)"directory /home created successful");
            }
            if ((mkHomeInfomanDir = this.executeCommandWithResponse("mkdir -p /home/infoman/")).getExitStatus() != 0) {
                throw new IOException("Can't create directory /home/infoman/");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"directory /home/infoman/ created successful");
            }
        } else if (lsHomeDir.getExitStatus() == 0) {
            CommandResponse lsHomeInfomanDir;
            if (log.isDebugEnabled()) {
                log.debug((Object)"directory /home is allready exists");
            }
            if ((lsHomeInfomanDir = this.executeCommandWithResponse("ls -d /home/infoman/")).getExitStatus() != 0) {
                CommandResponse mkHomeInfomanDir = this.executeCommandWithResponse("mkdir -p /home/infoman/");
                if (mkHomeInfomanDir.getExitStatus() != 0) {
                    throw new IOException("Can't create directory /home/infoman/");
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)"directory /home/infoman/ created successful");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"directory /home/infoman/ is allready exists");
            }
        }
        homeDirExist = true;
        log.trace((Object)"checkInfomanHomeDir() done\n");
        return homeDirExist;
    }

    private void parseURL(String url) {
        this.setHost(url.split(":")[0]);
        if (url.contains(":")) {
            this.setPort(Integer.parseInt(url.split(":")[1]));
        } else {
            this.setPort(22);
        }
    }

    private void parseWithUser(String url) {
        String user = url.split("@")[0];
        String rest = url.split("@")[1];
        if (user.contains(":")) {
            this.setUser(user.split(":")[0]);
            this.setPassword(user.split(":")[1]);
        } else {
            this.setUser(user);
            this.setPassword(null);
        }
        this.parseURL(rest);
    }

    private void setHost(String host) {
        this.host = host;
        this.validateUserData();
    }

    private void setPassword(String password) {
        this.password = password;
    }

    private void setPort(int port) {
        this.port = port;
    }

    private void setUser(String user) {
        this.userName = user;
        this.validateUserData();
    }

    private void sleepThread(int sleepTime) {
        long currentTime;
        long time = System.currentTimeMillis();
        while ((currentTime = System.currentTimeMillis()) - time < (long)sleepTime) {
        }
    }

    private void startMinitScript() throws IllegalStateException, IOException {
        log.debug((Object)"\nstartMinitScript()");
        this.isConnectedCheck();
        log.debug((Object)"Checking if createMinit.sh is present");
        CommandResponse response = this.executeCommandWithResponse("cd /home/infoman/;ls createMinit.sh");
        if (response.getExitStatus() != 0) {
            throw new IOException("createMinit.sh doesn't exist at Infoman! Check the Infoman Software!");
        }
        int exec = this.executeCommand("sh /home/infoman/createMinit.sh");
        if (exec != 0) {
            throw new IOException("Can't execute init script /home/infoman/createMinit.sh");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"init script createMinit.sh executed successfully");
        }
    }

    private static String toString(Object[] a, String separator) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(a[0].toString());
        for (int i = 1; i < a.length; ++i) {
            buf.append(separator);
            buf.append(a[i].toString());
        }
        return buf.toString();
    }

    private void addPrivateKey(Reader reader) throws IOException {
        BufferedReader br = null;
        String privateKey = "";
        try {
            br = new BufferedReader(reader);
            boolean len = false;
            while (br.ready()) {
                privateKey = privateKey + br.readLine() + "\n";
            }
        }
        catch (IOException ex) {
            privateKey = null;
            throw new IOException(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
        if (privateKey != null) {
            try {
                this.jsch.addIdentity(reader + "", privateKey.getBytes(), null, "".getBytes());
            }
            catch (JSchException ex) {
                throw new IOException(ex);
            }
        }
    }

    private void parseTunnelURL(String url) {
        if (url.contains(":")) {
            this.tunnelHost = url.split(":")[0];
            this.tunnelPort = Integer.parseInt(url.split(":")[1]);
        } else {
            this.tunnelHost = url;
            this.tunnelPort = 22;
        }
    }

    private void parseTunnelWithUser(String url) {
        String user = url.split("@")[0];
        String rest = url.split("@")[1];
        if (user.contains(":")) {
            this.tunnelUser = user.split(":")[0];
            this.tunnelPassword = user.split(":")[1];
        } else {
            this.tunnelUser = user;
            this.tunnelPassword = null;
        }
        this.parseTunnelURL(rest);
    }

    private String[] toStringArrayRevert(String source) throws IllegalArgumentException {
        String[] dest;
        if (source != null || !source.equals("")) {
            int i;
            StringTokenizer tn = new StringTokenizer(source);
            int count = tn.countTokens();
            String[] src = new String[count];
            while (tn.hasMoreTokens()) {
                for (i = 0; i < src.length; ++i) {
                    String s;
                    src[i] = s = tn.nextToken();
                }
            }
            dest = new String[count];
            for (i = 0; i < dest.length; ++i) {
                dest[i] = src[dest.length - i - 1];
            }
        } else {
            throw new IllegalArgumentException("toStringArrayRevert(String source): parameter source is NULL or empty (\"\")");
        }
        return dest;
    }

    private void uploadConfigFile(File configFile, String configLink) throws IllegalStateException, IOException {
        this.uploadConfigFile(configFile, configLink, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadConfigFile(File configFile, String configLink, File checksumFile) throws IllegalStateException, IOException {
        log.trace((Object)"\nuploadConfigFile (configFile, configLink, checksumFile) call");
        this.isConnectedCheck();
        String filename = ScpClient.getUnixConformFilename(configFile.getName());
        if (this.checkInfomanHomeDir()) {
            int move;
            int check;
            this.scpClient.scpTo(configFile.getAbsolutePath(), INFOMAN_TEMP_DIR, this.session);
            if (checksumFile != null && (check = this.compareChecksum(checksumFile)) != 0) {
                throw new IOException("configuration file " + configFile + " is corrupt. --> Update is interrupted, connection to infoman is closed!");
            }
            CommandResponse findLinkResp = this.executeCommandWithResponse("cd /home/infoman/;ls " + configLink);
            String remoteLinkName = findLinkResp.getResponse().trim();
            CommandResponse findOldConfResp = this.executeCommandWithResponse("cd /home/infoman/;readlink " + configLink);
            String oldConfFileName = null;
            if (findOldConfResp.getExitStatus() == 0) {
                oldConfFileName = ScpClient.getUnixConformFilename(findOldConfResp.getResponse().trim());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Symbolic link to old config file = " + oldConfFileName));
                }
            } else {
                log.debug((Object)(configLink + " is not a symbolic link, but a file."));
            }
            if (remoteLinkName.equalsIgnoreCase(configLink)) {
                if (filename.equalsIgnoreCase(configLink)) {
                    move = this.executeCommand("mv -f /tmp/" + filename + " " + INFOMAN_HOME_DIR);
                    if (move != 0) throw new IOException("Can't move /tmp/" + filename + " to " + INFOMAN_HOME_DIR);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("moving of /tmp/" + filename + " to " + INFOMAN_HOME_DIR + " successful"));
                    }
                } else {
                    int link;
                    move = this.executeCommand("mv -f /tmp/" + filename + " " + INFOMAN_HOME_DIR);
                    if (move != 0) throw new IOException("Can't move " + filename + " from " + INFOMAN_TEMP_DIR + " to " + INFOMAN_HOME_DIR);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("moving of " + filename + " from " + INFOMAN_TEMP_DIR + " to " + INFOMAN_HOME_DIR + " successful"));
                    }
                    if ((link = this.executeCommand("cd /home/infoman/;ln -sf " + filename + " " + configLink)) != 0) {
                        throw new IOException("Can't create link /home/infoman/" + configLink);
                    }
                }
            } else {
                int link;
                move = this.executeCommand("mv -f /tmp/" + filename + " " + INFOMAN_HOME_DIR);
                if (move != 0) throw new IOException("Can't move /tmp/" + filename + " to " + INFOMAN_HOME_DIR);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("moving of /tmp/" + filename + " to " + INFOMAN_HOME_DIR + " successful"));
                }
                if (!filename.equalsIgnoreCase(configLink) && (link = this.executeCommand("cd /home/infoman/;ln -sf " + filename + " " + configLink)) != 0) {
                    throw new IOException("Can't create link /home/infoman/" + configLink);
                }
            }
            if (oldConfFileName != null && !oldConfFileName.equals("") && !oldConfFileName.equals(filename)) {
                int del = this.executeCommand("rm -rf /home/infoman/" + oldConfFileName);
                if (del != 0) throw new IOException("Can't delete old infoman configuration file /home/infoman/" + oldConfFileName + " from infoman!");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("old configuration file /home/infoman/" + oldConfFileName + " deleted from infoman"));
                }
            }
        }
        log.trace((Object)"uploadConfigFile (configFile, configLink, checksumFile) done\n");
    }

    private void uploadInfomanSoftware(File infomanArchive, File checksumFile) throws IOException, IllegalStateException {
        int check;
        this.isConnectedCheck();
        this.scpClient.scpTo(infomanArchive.getAbsolutePath(), INFOMAN_TEMP_DIR, this.session);
        if (checksumFile != null && (check = this.compareChecksum(checksumFile)) != 0) {
            throw new IOException("infoman archive file " + infomanArchive + " is corrupt. --> Update is interrupted, connection to infoman is closed!");
        }
        if (this.isFileExists("/tmp/infomanPostInstall.sh")) {
            this.executeCommand("rm -rf /tmp/infomanPostInstall.sh");
        }
        this.executeCommand("touch /tmp/updateLockFile");
        CommandResponse response = this.executeCommandWithResponse("tar --directory=/ -xzf /tmp/" + ScpClient.getUnixConformFilename(infomanArchive.getName()));
        int exe1 = response.getExitStatus();
        String error = response.getError();
        if (error == null) {
            error = "";
        }
        if (exe1 == 0) {
            log.debug((Object)"Update of infoman software successful");
        } else if (error.trim().toLowerCase().equals("tar: invalid tar magic")) {
            log.debug((Object)"Update of infoman software successful");
            log.warn((Object)error.trim());
        } else {
            throw new IOException("Can't untar infoman software");
        }
        if (this.isFileExists("/tmp/infomanPostInstall.sh")) {
            log.trace((Object)"execute postInstallScript");
            this.executeCommand("/./tmp/infomanPostInstall.sh");
            log.trace((Object)"execute postInstallScript done");
        } else {
            log.trace((Object)"no infomanPostInstall script found");
        }
    }

    private void validateUserData() {
        this.userDataSet = this.userName != null && this.host != null;
    }

    public static class PortForwarder {
        String remoteHost;
        int localPort;
        int remotePort;

        public PortForwarder(int localPort, String remoteHost, int remotePort) {
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public int getRemotePort() {
            return this.remotePort;
        }
    }
}

