/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.io.IOException;
import java.sql.SQLException;
import java.text.NumberFormat;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.StatementInfo;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.cookies.LineCookie;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class SQLExecutionLoggerImpl
implements SQLExecutionLogger {
    private final LineCookie lineCookie;
    private final InputOutput inputOutput;
    private boolean inputOutputSelected = false;
    private int errorCount;

    public SQLExecutionLoggerImpl(String displayName, LineCookie lineCookie) {
        this.lineCookie = lineCookie;
        String ioName = NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_SQLFileExecution", (Object)displayName);
        this.inputOutput = IOProvider.getDefault().getIO(ioName, true);
    }

    public SQLExecutionLoggerImpl(String displayName) {
        this(displayName, null);
    }

    @Override
    public void log(SQLExecutionResult result) {
        if (result.hasExceptions()) {
            this.logException(result);
        } else {
            this.logSuccess(result);
        }
    }

    @Override
    public void finish(long executionTime) {
        OutputWriter writer = this.inputOutput.getOut();
        writer.println(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionFinished", (Object)String.valueOf(this.millisecondsToSeconds(executionTime)), (Object)String.valueOf(this.errorCount)));
        writer.println("");
        writer.close();
        this.inputOutput.select();
    }

    @Override
    public void cancel() {
        OutputWriter writer = this.inputOutput.getErr();
        writer.println(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionCancelled"));
        writer.println("");
        writer.close();
    }

    public void close() {
        this.inputOutput.closeInputOutput();
    }

    private void logException(SQLExecutionResult result) {
        ++this.errorCount;
        if (!this.inputOutputSelected) {
            this.inputOutputSelected = true;
            this.inputOutput.select();
        }
        OutputWriter writer = this.inputOutput.getErr();
        for (Throwable e : result.getExceptions()) {
            if (e instanceof SQLException) {
                this.writeSQLException((SQLException)e, writer);
                continue;
            }
            Exceptions.printStackTrace((Throwable)e);
        }
        this.printLineColumn(writer, result.getStatementInfo(), true);
        writer.println("");
        writer.close();
    }

    private void writeSQLException(SQLException e, OutputWriter writer) {
        while (e != null) {
            writer.println(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ErrorCodeStateMessage", (Object)String.valueOf(e.getErrorCode()), (Object)e.getSQLState(), (Object)e.getMessage()));
            e = e.getNextException();
        }
    }

    private void logSuccess(SQLExecutionResult result) {
        OutputWriter writer = this.inputOutput.getOut();
        String executionTimeStr = this.millisecondsToSeconds(result.getExecutionTime());
        String successLine = null;
        successLine = result.getUpdateCount() >= 0 ? NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfullyTimeRows", (Object)String.valueOf(executionTimeStr), (Object)String.valueOf(result.getUpdateCount())) : NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfullyTime", (Object)String.valueOf(executionTimeStr));
        writer.println(successLine);
        this.printLineColumn(writer, result.getStatementInfo(), false);
        writer.println("");
        writer.close();
    }

    private void printLineColumn(OutputWriter writer, StatementInfo statementInfo, boolean hyperlink) {
        String lineColumn = NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_LineColumn", (Object)String.valueOf(statementInfo.getStartLine() + 1), (Object)String.valueOf(statementInfo.getStartColumn() + 1));
        try {
            if (hyperlink) {
                writer.println(lineColumn, (OutputListener)new Hyperlink(statementInfo.getStartLine(), statementInfo.getStartColumn()));
            } else {
                writer.println(lineColumn);
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private String millisecondsToSeconds(long ms) {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(3);
        return fmt.format((double)ms / 1000.0);
    }

    private final class Hyperlink
    implements OutputListener {
        private final int line;
        private final int column;

        public Hyperlink(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public void outputLineSelected(OutputEvent ev) {
            this.goToLine(false);
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            this.goToLine(true);
        }

        private void goToLine(boolean focus) {
            Line l = SQLExecutionLoggerImpl.this.lineCookie.getLineSet().getOriginal(this.line);
            if (!l.isDeleted()) {
                l.show(focus ? 2 : 0, this.column);
            }
        }
    }
}

