/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;

public abstract class VCSStatusTable<T extends VCSStatusNode>
implements MouseListener,
ListSelectionListener {
    private final ETable table;
    private final JScrollPane component;
    protected final VCSStatusTableModel<T> tableModel;
    private final PropertyChangeSupport support;
    private static final Logger LOG = Logger.getLogger(VCSStatusTable.class.getName());
    public static final String PROP_SELECTED_FILES = "selectedFiles";
    protected static final Comparator NodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Node.Property p1 = (Node.Property)o1;
            Node.Property p2 = (Node.Property)o2;
            String sk1 = (String)p1.getValue("sortkey");
            if (sk1 != null) {
                String sk2 = (String)p2.getValue("sortkey");
                return sk1.compareToIgnoreCase(sk2);
            }
            try {
                String s1 = (String)p1.getValue();
                String s2 = (String)p2.getValue();
                return s1.compareToIgnoreCase(s2);
            }
            catch (Exception e) {
                LOG.log(Level.INFO, null, e);
                return 0;
            }
        }
    };

    public VCSStatusTable(VCSStatusTableModel<T> tableModel) {
        this.tableModel = tableModel;
        this.support = new PropertyChangeSupport(this);
        this.table = new ETable(tableModel);
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.table.addMouseListener((MouseListener)this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.component = new JScrollPane((Component)this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCSStatusTable.this.showPopup(Utils.getPositionForPopup((JTable)VCSStatusTable.this.table));
            }
        });
        this.initColumns();
    }

    protected final void setDefaultRenderer(TableCellRenderer renderer) {
        this.table.setDefaultRenderer(Node.Property.class, renderer);
    }

    public final void focus() {
        this.table.requestFocusInWindow();
    }

    protected abstract void setModelProperties();

    public final JComponent getComponent() {
        return this.component;
    }

    protected final JTable getTable() {
        return this.table;
    }

    public Map<File, T> getNodes() {
        VCSStatusNode[] nodes = this.tableModel.getNodes();
        HashMap<File, VCSStatusNode> nodesAsMap = new HashMap<File, VCSStatusNode>(nodes.length);
        for (VCSStatusNode node : nodes) {
            nodesAsMap.put(node.getFile(), node);
        }
        return nodesAsMap;
    }

    protected final T[] getSelectedNodes() {
        int[] selection = this.table.getSelectedRows();
        LinkedList<T> nodes = new LinkedList<T>();
        for (int i : selection) {
            T selectedNode = this.tableModel.getNode(this.table.convertRowIndexToModel(i));
            nodes.add(selectedNode);
        }
        return nodes.toArray((VCSStatusNode[])Array.newInstance(this.tableModel.getItemClass(), nodes.size()));
    }

    public final File[] getSelectedFiles() {
        int[] selection = this.table.getSelectedRows();
        LinkedList<File> files = new LinkedList<File>();
        for (int i : selection) {
            T selectedNode = this.tableModel.getNode(this.table.convertRowIndexToModel(i));
            files.add(((VCSStatusNode)((Object)selectedNode)).getFile());
        }
        return files.toArray(new File[files.size()]);
    }

    public final void setSelectedNodes(File[] selectedFiles) {
        HashSet<File> files = new HashSet<File>(Arrays.asList(selectedFiles));
        ListSelectionModel selection = this.table.getSelectionModel();
        selection.setValueIsAdjusting(true);
        selection.clearSelection();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            T node = this.tableModel.getNode(this.table.convertRowIndexToModel(i));
            if (!files.contains(((VCSStatusNode)((Object)node)).getFile())) continue;
            selection.addSelectionInterval(i, i);
        }
        selection.setValueIsAdjusting(false);
    }

    public void setNodes(T[] nodes) {
        File[] selectedFiles = this.getSelectedFiles();
        this.tableModel.setNodes((VCSStatusNode[])nodes);
        this.setSelectedNodes(selectedFiles);
        if (selectedFiles.length == 0 && nodes.length > 0) {
            this.table.getSelectionModel().addSelectionInterval(0, 0);
        }
    }

    public void updateNodes(List<T> toRemove, List<T> toRefresh, List<T> toAdd) {
        File[] selectedFiles = this.getSelectedFiles();
        for (VCSStatusNode node : toRefresh) {
            node.refresh();
        }
        this.tableModel.remove(toRemove);
        this.tableModel.add(toAdd);
        this.tableModel.fireTableDataChanged();
        this.setSelectedNodes(selectedFiles);
    }

    public File getNextFile(File file) {
        return this.getNeighbouringFile(file, 1);
    }

    public File getPrevFile(File file) {
        return this.getNeighbouringFile(file, -1);
    }

    public File getNeighbouringFile(File file, int indexDelta) {
        assert (EventQueue.isDispatchThread());
        int tableIndex = this.findIndex(file);
        File neighbour = null;
        if (tableIndex > -1 && (tableIndex += indexDelta) >= 0 && tableIndex < this.table.getRowCount()) {
            neighbour = ((VCSStatusNode)((Object)this.tableModel.getNode(this.table.convertRowIndexToModel(tableIndex)))).getFile();
        }
        return neighbour;
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.support.removePropertyChangeListener(list);
    }

    private void showPopup(final MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (VCSStatusTable.this.table.isShowing()) {
                    JPopupMenu menu = VCSStatusTable.this.getPopup();
                    menu.show((Component)VCSStatusTable.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.getPopup();
        menu.show((Component)this.table, p.x, p.y);
    }

    protected abstract JPopupMenu getPopup();

    protected void mouseClicked(VCSStatusNode node) {
        Action action = node.getPreferredAction();
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, node.getFile().getAbsolutePath()));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            T node = this.tableModel.getNode(this.table.convertRowIndexToModel(row));
            this.mouseClicked((VCSStatusNode)((Object)node));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ArrayList<T> selectedNodes = new ArrayList<T>();
        ListSelectionModel selection = this.table.getSelectionModel();
        final TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)this.table);
        if (tc == null) {
            return;
        }
        int min = selection.getMinSelectionIndex();
        if (min != -1) {
            int max = selection.getMaxSelectionIndex();
            for (int i = min; i <= max; ++i) {
                if (!selection.isSelectedIndex(i)) continue;
                int idx = this.table.convertRowIndexToModel(i);
                selectedNodes.add(this.tableModel.getNode(idx));
            }
        }
        final VCSStatusNode[] nodeArray = selectedNodes.toArray((VCSStatusNode[])Array.newInstance(this.tableModel.getItemClass(), selectedNodes.size()));
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                File[] selectedFiles = new File[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    selectedFiles[i] = nodeArray[i].getFile();
                }
                VCSStatusTable.this.support.firePropertyChange(VCSStatusTable.PROP_SELECTED_FILES, null, selectedFiles);
                tc.setActivatedNodes((Node[])nodeArray);
            }
        });
    }

    private void initColumns() {
        this.setModelProperties();
        this.table.setColumnHidingAllowed(false);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            ((ETableColumn)this.table.getColumnModel().getColumn(i)).setNestedComparator(NodeComparator);
        }
    }

    private int findIndex(File file) {
        int[] selection;
        for (int i : selection = this.table.getSelectedRows()) {
            T selectedNode = this.tableModel.getNode(this.table.convertRowIndexToModel(i));
            if (!((VCSStatusNode)((Object)selectedNode)).getFile().equals(file)) continue;
            return i;
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            T selectedNode = this.tableModel.getNode(this.table.convertRowIndexToModel(i));
            if (!((VCSStatusNode)((Object)selectedNode)).getFile().equals(file)) continue;
            return i;
        }
        return -1;
    }

    protected static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

