/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSCommitPanel;
import org.netbeans.modules.versioning.util.common.VCSCommitPanelModifier;
import org.netbeans.modules.versioning.util.common.VCSCommitTableModel;
import org.netbeans.modules.versioning.util.common.VCSFileInformation;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class VCSCommitTable<F extends VCSFileNode>
implements AncestorListener,
TableModelListener,
MouseListener {
    private VCSCommitTableModel<F> tableModel;
    private JTable table;
    private JComponent component;
    private TableSorter sorter;
    private String[] columns;
    private String[] sortByColumns;
    private Set<File> modifiedFiles = Collections.emptySet();
    private VCSCommitPanel commitPanel;
    private String errroMessage;
    private final boolean editable;
    private final VCSCommitPanelModifier modifier;

    public VCSCommitTable(VCSCommitTableModel<F> tableModel) {
        this(tableModel, true);
    }

    public VCSCommitTable(VCSCommitTableModel<F> tableModel, boolean isEditable) {
        this.editable = isEditable;
        this.modifier = tableModel.getCommitModifier();
        this.init(tableModel);
        this.sortByColumns = new String[]{"path"};
        this.setSortingStatus();
    }

    private void init(VCSCommitTableModel<F> tableModel) {
        this.tableModel = tableModel;
        tableModel.addTableModelListener(this);
        this.sorter = new TableSorter(tableModel);
        this.table = new SortedTable(this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new CommitStringsCellRenderer());
        this.table.setDefaultRenderer(Boolean.class, new CheckboxCellRenderer());
        this.table.setDefaultEditor(Boolean.class, new CheckboxCellEditor());
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 31);
        this.table.getAccessibleContext().setAccessibleName(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_ACCESSIBLE_NAME));
        this.table.getAccessibleContext().setAccessibleDescription(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_ACCESSIBLE_DESCRIPTION));
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCSCommitTable.this.showPopup(Utils.getPositionForPopup(VCSCommitTable.this.table));
            }
        });
        this.table.addMouseListener(this);
        this.setColumns(VCSCommitTableModel.COMMIT_COLUMNS);
    }

    void labelFor(JLabel label) {
        label.setLabelFor(this.table);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    public boolean containsCommitable() {
        List<F> list = this.getCommitFiles();
        for (VCSFileNode file : list) {
            if (file.getCommitOptions() == this.modifier.getExcludedOption()) continue;
            this.errroMessage = null;
            return true;
        }
        this.errroMessage = this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.MESSAGE_NO_FILES);
        return false;
    }

    public String getErrorMessage() {
        return this.errroMessage;
    }

    private void setDefaultColumnSizes() {
        block17: {
            TableColumnModel columnModel;
            int width;
            block18: {
                block16: {
                    width = this.table.getWidth();
                    columnModel = this.table.getColumnModel();
                    if (this.columns == null || columnModel == null) {
                        return;
                    }
                    if (columnModel.getColumnCount() != this.columns.length) {
                        return;
                    }
                    if (this.columns.length != 4) break block16;
                    for (int i = 0; i < this.columns.length; ++i) {
                        String col = this.columns[i];
                        this.sorter.setColumnComparator(i, null);
                        if (col.equals("commit")) {
                            columnModel.getColumn(i).setMinWidth(new JCheckBox().getMinimumSize().width);
                            columnModel.getColumn(i).setPreferredWidth(new JCheckBox().getPreferredSize().width);
                            continue;
                        }
                        if (col.equals("name")) {
                            this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                            columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
                            continue;
                        }
                        if (col.equals("action")) {
                            columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                            continue;
                        }
                        columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
                    }
                    break block17;
                }
                if (this.columns.length != 5) break block18;
                for (int i = 0; i < this.columns.length; ++i) {
                    String col = this.columns[i];
                    this.sorter.setColumnComparator(i, null);
                    if (col.equals("commit")) {
                        columnModel.getColumn(i).setMinWidth(new JCheckBox().getMinimumSize().width);
                        columnModel.getColumn(i).setPreferredWidth(new JCheckBox().getPreferredSize().width);
                        continue;
                    }
                    if (col.equals("name")) {
                        this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                        columnModel.getColumn(i).setPreferredWidth(width * 25 / 100);
                        continue;
                    }
                    if (col.equals("status")) {
                        this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                        columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                        continue;
                    }
                    if (col.equals("action")) {
                        columnModel.getColumn(i).setPreferredWidth(width * 20 / 100);
                        continue;
                    }
                    columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
                }
                break block17;
            }
            if (this.columns.length != 6) break block17;
            for (int i = 0; i < this.columns.length; ++i) {
                String col = this.columns[i];
                this.sorter.setColumnComparator(i, null);
                if (col.equals("commit")) {
                    columnModel.getColumn(i).setMinWidth(new JCheckBox().getMinimumSize().width);
                    columnModel.getColumn(i).setPreferredWidth(new JCheckBox().getPreferredSize().width);
                    continue;
                }
                if (col.equals("name")) {
                    this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                    columnModel.getColumn(i).setPreferredWidth(width * 25 / 100);
                    continue;
                }
                if (col.equals("status")) {
                    this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                    this.sorter.setSortingStatus(i, 1);
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                if (col.equals("action")) {
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
            }
        }
    }

    private void setSortingStatus() {
        block0: for (int i = 0; i < this.sortByColumns.length; ++i) {
            String sortByColumn = this.sortByColumns[i];
            for (int j = 0; j < this.columns.length; ++j) {
                String column = this.columns[j];
                if (!column.equals(sortByColumn)) continue;
                this.sorter.setSortingStatus(j, column.equals(sortByColumn) ? 1 : 0);
                continue block0;
            }
        }
    }

    public TableSorter getSorter() {
        return this.sorter;
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(this.columns, cols)) {
            return;
        }
        this.columns = cols;
        this.tableModel.setColumns(cols);
        this.setDefaultColumnSizes();
    }

    public void setNodes(F[] nodes) {
        this.tableModel.setNodes((VCSFileNode[])nodes);
    }

    public List<F> getCommitFiles() {
        return this.tableModel.getCommitFiles();
    }

    public JComponent getComponent() {
        return this.component;
    }

    JTable getTable() {
        return this.table;
    }

    void dataChanged() {
        int idx = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (idx != -1) {
            this.table.getSelectionModel().addSelectionInterval(idx, idx);
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.table.repaint();
    }

    public void setRootFile(String repositoryPath, String rootLocalPath) {
        this.tableModel.setRootFile(repositoryPath, rootLocalPath);
    }

    private void showPopup(final MouseEvent e) {
        int i;
        int row = this.table.rowAtPoint(e.getPoint());
        int col = this.table.columnAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        if (col != -1) {
            boolean makeColSelected = true;
            int[] selectedcols = this.table.getSelectedColumns();
            for (i = 0; i < selectedcols.length; ++i) {
                if (col != selectedcols[i]) continue;
                makeColSelected = false;
                break;
            }
            if (makeColSelected) {
                this.table.getColumnModel().getSelectionModel().setSelectionInterval(col, col);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (VCSCommitTable.this.table.isShowing()) {
                    JPopupMenu menu = VCSCommitTable.this.getPopup();
                    menu.show(VCSCommitTable.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.getPopup();
        menu.show(this.table, p.x, p.y);
    }

    private JPopupMenu getPopup() {
        JMenuItem item;
        JPopupMenu menu = new JPopupMenu();
        boolean containsExcluded = false;
        boolean containsIncluded = false;
        for (int rowIndex : this.table.getSelectedRows()) {
            if (this.modifier.getExcludedOption().equals(this.tableModel.getOption(this.sorter.modelIndex(rowIndex)))) {
                containsExcluded = true;
                continue;
            }
            containsIncluded = true;
        }
        if (containsExcluded) {
            item = menu.add(new AbstractAction(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_INCLUDE_ACTION_NAME)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VCSCommitTable.this.setIncluded(true);
                }

                @Override
                public boolean isEnabled() {
                    return VCSCommitTable.this.editable;
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
        if (containsIncluded) {
            item = menu.add(new AbstractAction(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_EXCLUDE_ACTION_NAME)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VCSCommitTable.this.setIncluded(false);
                }

                @Override
                public boolean isEnabled() {
                    return VCSCommitTable.this.editable;
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
        item = menu.add(new AbstractAction(NbBundle.getMessage(VCSCommitTable.class, (String)"CTL_CommitTable_DiffAction")){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCSCommitTable.this.openDiff();
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item.setEnabled(this.commitPanel != null);
        return menu;
    }

    private void setIncluded(boolean included) {
        int i;
        int[] rows = this.table.getSelectedRows();
        int rowCount = this.table.getRowCount();
        for (i = 0; i < rows.length; ++i) {
            rows[i] = this.sorter.modelIndex(rows[i]);
        }
        this.tableModel.setIncluded(rows, included);
        if (rowCount == this.table.getRowCount()) {
            for (i = 0; i < rows.length; ++i) {
                this.table.getSelectionModel().addSelectionInterval(this.sorter.viewIndex(rows[i]), this.sorter.viewIndex(rows[i]));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.openDiff();
        }
    }

    public void setCommitPanel(VCSCommitPanel panel) {
        this.commitPanel = panel;
    }

    public void setModifiedFiles(Set<File> modifiedFiles) {
        this.modifiedFiles = modifiedFiles;
    }

    VCSCommitPanelModifier getCommitModifier() {
        return this.modifier;
    }

    private void openDiff() {
        int[] rows = this.table.getSelectedRows();
        VCSFileNode[] nodes = new VCSFileNode[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            nodes[i] = this.tableModel.getNode(this.sorter.modelIndex(rows[i]));
        }
        this.commitPanel.openDiff(nodes);
    }

    private class CheckboxCellEditor
    extends DefaultCellEditor {
        public CheckboxCellEditor() {
            super(new JCheckBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JCheckBox checkbox = (JCheckBox)this.editorComponent;
            checkbox.setSelected(value == null ? false : (Boolean)value);
            checkbox.setHorizontalAlignment(2);
            checkbox.setEnabled(VCSCommitTable.this.editable);
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class CheckboxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();

        public CheckboxCellRenderer() {
            this.setToolTipText(VCSCommitTable.this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_HEADER_COMMIT_DESC));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value == null ? false : (Boolean)value);
            this.setEnabled(VCSCommitTable.this.editable);
            Color c = this.renderer.getTableCellRendererComponent(table, "value", isSelected, hasFocus, row, column).getBackground();
            this.setBackground(new Color(c.getRGB()));
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    private class CommitStringsCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private CommitStringsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col = table.convertColumnIndexToModel(column);
            if ("name".equals(VCSCommitTable.this.columns[col])) {
                TableSorter sorter = (TableSorter)table.getModel();
                VCSCommitTableModel model = (VCSCommitTableModel)sorter.getTableModel();
                Object node = model.getNode(sorter.modelIndex(row));
                VCSCommitOptions options = model.getOption(sorter.modelIndex(row));
                if (!isSelected) {
                    value = ((VCSFileInformation)((VCSFileNode)node).getInformation()).annotateNameHtml(((VCSFileNode)node).getFile().getName());
                }
                if (options == VCSCommitTable.this.modifier.getExcludedOption()) {
                    value = "<s>" + value + "</s>";
                }
                if (VCSCommitTable.this.modifiedFiles.contains(((VCSFileNode)node).getFile())) {
                    value = "<strong>" + value + "</strong>";
                }
                value = "<html>" + value + "</html>";
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if ("path".equals(VCSCommitTable.this.columns[col])) {
                return this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer row1 = (Integer)o1;
            Integer row2 = (Integer)o2;
            return ((VCSFileNode)VCSCommitTable.this.tableModel.getNode(row1)).getName().compareToIgnoreCase(((VCSFileNode)VCSCommitTable.this.tableModel.getNode(row2)).getName());
        }
    }

    private class StatusComparator
    extends VCSFileInformation.ByImportanceComparator {
        private StatusComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Integer row1 = (Integer)o1;
            Integer row2 = (Integer)o2;
            return super.compare((VCSFileInformation)((VCSFileNode)VCSCommitTable.this.tableModel.getNode(row1)).getInformation(), (VCSFileInformation)((VCSFileNode)VCSCommitTable.this.tableModel.getNode(row2)).getInformation());
        }
    }
}

