/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.Bundle;
import org.netbeans.modules.versioning.util.common.FileViewComponent;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.awt.MouseUtils;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public abstract class FileTreeView<T extends Node>
implements FileViewComponent<T>,
AncestorListener,
PropertyChangeListener,
MouseListener {
    protected final OutlineView view;
    private final ExplorerManager em;
    private boolean displayed;
    private EditorCookie[] editorCookies;
    private final ViewContainer viewComponent;
    private T[] nodes;
    private final Map<T, TreeFilterNode> nodeMapping = Collections.synchronizedMap(new WeakHashMap());

    public FileTreeView() {
        this.em = new ExplorerManager();
        this.view = new OutlineView(Bundle.CTL_FileTree_treeColumn_Name());
        this.view.getOutline().setShowHorizontalLines(true);
        this.view.getOutline().setShowVerticalLines(false);
        this.view.getOutline().setRootVisible(false);
        this.view.setVerticalScrollBarPolicy(22);
        this.view.setHorizontalScrollBarPolicy(30);
        this.view.setPopupAllowed(false);
        this.view.getOutline().addMouseListener((MouseListener)this);
        this.view.getOutline().getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.view.getOutline().getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTreeView.this.showPopup(Utils.getPositionForPopup((JTable)FileTreeView.this.view.getOutline()));
            }
        });
        this.viewComponent = new ViewContainer(this.em);
        this.viewComponent.add((Component)this.view, "Center");
        this.viewComponent.addAncestorListener(this);
        this.em.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public int getPreferredHeaderHeight() {
        return this.view.getOutline().getTableHeader().getPreferredSize().height;
    }

    @Override
    public JComponent getComponent() {
        return this.viewComponent;
    }

    @Override
    public int getPreferredHeight() {
        return this.view.getOutline().getPreferredSize().height;
    }

    private Node getNodeAt(int rowIndex) {
        Node result = null;
        TreePath path = this.view.getOutline().getOutlineModel().getLayout().getPathForRow(rowIndex);
        if (path != null) {
            result = Visualizer.findNode((Object)path.getLastPathComponent());
        }
        return result;
    }

    @Override
    public void setModel(T[] nodes, EditorCookie[] editorCookies, Object modelData) {
        this.editorCookies = editorCookies;
        this.nodes = nodes;
        this.em.setRootContext((Node)modelData);
        for (T n : nodes) {
            this.view.expandNode(this.toTreeNode(n));
        }
    }

    protected abstract void setDefaultColumnSizes();

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (!this.displayed) {
            this.displayed = true;
            this.setDefaultColumnSizes();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            T node;
            Node[] selectedNodes = this.em.getSelectedNodes();
            if (selectedNodes.length == 1 && (node = this.convertNode(this.em.getSelectedNodes()[0])) != null) {
                this.nodeSelected(node);
                return;
            }
            this.nodeSelected(null);
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)this.view);
            if (tc != null) {
                tc.setActivatedNodes(this.em.getSelectedNodes());
            }
        }
    }

    private void showPopup(final MouseEvent e) {
        int row = this.view.getOutline().rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.view.getOutline().getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.view.getOutline().getSelectionModel().setSelectionInterval(row, row);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPopupMenu menu = FileTreeView.this.getPopup();
                if (menu != null) {
                    menu.show((Component)FileTreeView.this.view.getOutline(), e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.getPopup();
        if (menu != null) {
            menu.show((Component)this.view.getOutline(), p.x, p.y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            Action action;
            int row = this.view.getOutline().rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            T n = this.convertNode(this.getNodeAt(this.view.getOutline().convertRowIndexToModel(row)));
            if (n != null && (action = n.getPreferredAction()) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    protected abstract T convertToAcceptedNode(Node var1);

    private T convertNode(Node node) {
        if (node instanceof TreeFilterNode) {
            return ((TreeFilterNode)node).getOriginal();
        }
        return this.convertToAcceptedNode(node);
    }

    protected abstract void nodeSelected(T var1);

    protected abstract JPopupMenu getPopup();

    @Override
    public T getSelectedNode() {
        T node = null;
        Node[] selectedNodes = this.em.getSelectedNodes();
        if (selectedNodes.length == 1) {
            node = this.convertNode(selectedNodes[0]);
        }
        return node;
    }

    public final List<Node> getSelectedNodes() {
        Node[] selectedNodes = this.em.getSelectedNodes();
        ArrayList<Node> nodeList = new ArrayList<Node>(selectedNodes.length);
        for (Node n : selectedNodes) {
            T converted = this.convertNode(n);
            if (converted == null) {
                nodeList.add(n);
                continue;
            }
            nodeList.add((Node)converted);
        }
        return nodeList;
    }

    protected final Node createFilterNode(T original) {
        TreeFilterNode<T> n = new TreeFilterNode<T>(original);
        this.nodeMapping.put(original, n);
        return n;
    }

    @Override
    public void setSelectedNode(T toSelect) {
        try {
            this.em.setSelectedNodes(new Node[]{this.toTreeNode(toSelect)});
        }
        catch (PropertyVetoException ex) {
            Logger.getLogger(FileTreeView.class.getName()).log(Level.FINE, null, ex);
        }
    }

    @Override
    public T getNodeAtPosition(int position) {
        for (int i = 0; i < this.view.getOutline().getRowCount(); ++i) {
            Node n = this.getNodeAt(this.view.getOutline().convertRowIndexToModel(i));
            T converted = this.convertNode(n);
            if (converted == null || position-- != 0) continue;
            return converted;
        }
        return null;
    }

    @Override
    public T[] getNeighbouringNodes(T node, int boundary) {
        assert (EventQueue.isDispatchThread());
        LinkedHashSet<T> neighbours = new LinkedHashSet<T>(5);
        neighbours.add(node);
        for (int i = 1; i < boundary; ++i) {
            T prev;
            T next = this.convertNode(this.findShiftNode(this.toTreeNode(node), i, false));
            if (next != null) {
                neighbours.add(next);
            }
            if ((prev = this.convertNode(this.findShiftNode(this.toTreeNode(node), -i, false))) == null) continue;
            neighbours.add(prev);
        }
        return neighbours.toArray((Node[])Array.newInstance(node.getClass(), neighbours.size()));
    }

    @Override
    public T getNextNode(T node) {
        Node nextNode = this.findShiftNode(this.toTreeNode(node), 1, true);
        return this.convertNode(nextNode);
    }

    @Override
    public T getPreviousNode(T node) {
        Node prevNode = this.findShiftNode(this.toTreeNode(node), -1, true);
        return this.convertNode(prevNode);
    }

    @Override
    public boolean hasNextNode(T node) {
        return this.convertNode(this.findShiftNode(this.toTreeNode(node), 1, false)) != null;
    }

    @Override
    public boolean hasPreviousNode(T node) {
        return this.convertNode(this.findShiftNode(this.toTreeNode(node), -1, false)) != null;
    }

    private Node toTreeNode(T n) {
        Node filterNode = (Node)this.nodeMapping.get(n);
        return filterNode == null ? n : filterNode;
    }

    private Node findShiftNode(Node startingNode, int direction, boolean canExpand) {
        return startingNode == null ? null : this.findDetailNode(startingNode, direction, this.view, canExpand);
    }

    private Node findDetailNode(Node fromNode, int direction, OutlineView outlineView, boolean canExpand) {
        return this.findUp(fromNode, direction, this.convertNode(fromNode) != null || direction < 0 ? direction : 0, outlineView, canExpand);
    }

    private Node findUp(Node node, int dir, int offset, OutlineView outlineView, boolean canExpand) {
        if (node == null) {
            return null;
        }
        Node parent = node.getParentNode();
        Node[] siblings = parent == null ? new Node[]{node} : FileTreeView.getChildren(parent, outlineView, canExpand);
        int nodeIndex = FileTreeView.findChildIndex(node, siblings);
        if (nodeIndex + offset < 0 || nodeIndex + offset >= siblings.length) {
            return this.findUp(parent, dir, dir, outlineView, canExpand);
        }
        int i = nodeIndex + offset;
        if (i >= 0 && i < siblings.length) {
            Node found = this.findDown(siblings[i], siblings, i, dir, outlineView, canExpand);
            return found;
        }
        return this.findUp(parent, dir, offset, outlineView, canExpand);
    }

    private Node findDown(Node node, Node[] siblings, int nodeIndex, int dir, OutlineView outlineView, boolean canExpand) {
        int i;
        Node[] children = FileTreeView.getChildren(node, outlineView, canExpand);
        int n = i = dir > 0 ? 0 : children.length - 1;
        while (i >= 0 && i < children.length) {
            Node found = this.findDown(children[i], children, i, dir, outlineView, canExpand);
            if (found != null) {
                return found;
            }
            i += dir;
        }
        for (i = nodeIndex; i >= 0 && i < siblings.length; i += dir) {
            T converted = this.convertNode(siblings[i]);
            if (converted == null) continue;
            return converted;
        }
        return null;
    }

    private static int findChildIndex(Node selectedNode, Node[] siblings) {
        int pos = -1;
        for (int i = 0; i < siblings.length; ++i) {
            if (siblings[i] != selectedNode) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private static Node[] getChildren(Node n, OutlineView outlineView, boolean canExpand) {
        if (outlineView != null) {
            if (!outlineView.isExpanded(n)) {
                if (canExpand) {
                    outlineView.expandNode(n);
                } else {
                    return n.getChildren().getNodes(true);
                }
            }
            return FileTreeView.getChildrenInDisplayedOrder(n, outlineView);
        }
        return n.getChildren().getNodes(true);
    }

    private static Node[] getChildrenInDisplayedOrder(Node parent, OutlineView outlineView) {
        Outline outline = outlineView.getOutline();
        Node[] unsortedChildren = parent.getChildren().getNodes(true);
        int rows = outlineView.getOutline().getRowCount();
        int start = FileTreeView.findRowIndexInOutline(parent, outline, rows);
        if (start == -1 && parent != ExplorerManager.find((Component)outlineView).getRootContext()) {
            return unsortedChildren;
        }
        LinkedList<Node> children = new LinkedList<Node>();
        for (int j = start + 1; j < rows; ++j) {
            int childModelIndex = outline.convertRowIndexToModel(j);
            if (childModelIndex == -1) continue;
            Object childObject = outline.getModel().getValueAt(childModelIndex, 0);
            Node childNode = Visualizer.findNode((Object)childObject);
            if (childNode.getParentNode() == parent) {
                children.add(childNode);
                continue;
            }
            if (children.size() == unsortedChildren.length) break;
        }
        return children.toArray(new Node[children.size()]);
    }

    private static int findRowIndexInOutline(Node node, Outline outline, int rows) {
        int startRow = Math.max(outline.getSelectedRow(), 0);
        int offset = 0;
        while (startRow + offset < rows || startRow - offset >= 0) {
            int up = startRow + offset + 1;
            int down = startRow - offset;
            if (up < rows && FileTreeView.testNodeInRow(outline, node, up)) {
                return up;
            }
            if (down >= 0 && FileTreeView.testNodeInRow(outline, node, down)) {
                return down;
            }
            ++offset;
        }
        return -1;
    }

    private static boolean testNodeInRow(Outline outline, Node node, int i) {
        Object o;
        Node n;
        int modelIndex = outline.convertRowIndexToModel(i);
        return modelIndex != -1 && (n = Visualizer.findNode((Object)(o = outline.getModel().getValueAt(modelIndex, 0)))) == node;
    }

    protected abstract class AbstractRenderDataProvider
    implements RenderDataProvider {
        protected AbstractRenderDataProvider() {
        }

        public String getDisplayName(Object o) {
            Node n = Visualizer.findNode((Object)o);
            String value = n.getDisplayName();
            Node leafNode = FileTreeView.this.convertNode(n);
            if (leafNode != null) {
                String htmlDisplayName = DiffUtils.getHtmlDisplayName(leafNode, this.isModified(leafNode), Arrays.asList(FileTreeView.this.em.getSelectedNodes()).contains(n));
                if ((htmlDisplayName = this.annotateName(leafNode, htmlDisplayName)) != null) {
                    value = "<html>" + htmlDisplayName;
                }
            }
            return value;
        }

        public boolean isHtmlDisplayName(Object o) {
            return true;
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            return null;
        }

        public String getTooltipText(Object o) {
            Node n = Visualizer.findNode((Object)o);
            File file = (File)n.getLookup().lookup(File.class);
            return file != null ? file.getAbsolutePath() : n.getShortDescription();
        }

        public Icon getIcon(Object o) {
            Node n = Visualizer.findNode((Object)o);
            return new ImageIcon(n.getIcon(1));
        }

        private boolean isModified(T node) {
            int index = Arrays.asList(FileTreeView.this.nodes).indexOf(node);
            EditorCookie editorCookie = index >= 0 ? FileTreeView.this.editorCookies[index] : null;
            return editorCookie != null ? editorCookie.isModified() : false;
        }

        protected abstract String annotateName(T var1, String var2);
    }

    private static class TreeFilterNode<T extends Node>
    extends FilterNode {
        public TreeFilterNode(T original) {
            super(original);
        }

        public T getOriginal() {
            return (T)super.getOriginal();
        }
    }

    private static class ViewContainer
    extends JPanel
    implements ExplorerManager.Provider {
        private final ExplorerManager em;

        private ViewContainer(ExplorerManager em) {
            this.em = em;
            this.setLayout(new BorderLayout());
        }

        public ExplorerManager getExplorerManager() {
            return this.em;
        }
    }
}

