/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.shelve.impl;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.shelve.impl.Bundle;
import org.netbeans.modules.versioning.shelve.impl.PatchStorage;
import org.netbeans.modules.versioning.shelve.impl.UnshelveChangesAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class ShelveChangesMenu
extends AbstractAction
implements Presenter.Menu {
    public static final String PREF_KEY_SHELVED_PATCHES = "shelvedPatches";

    public JMenuItem getMenuPresenter() {
        JMenu menu = this.createMenu();
        return menu;
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu(this);
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)Bundle.CTL_Menu_ShelveChanges());
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        menuItems.addAll(this.getShelveActions());
        menuItems.addAll(this.getUnshelveActions());
        for (JMenuItem item : menuItems) {
            menu.add(item);
        }
        this.enableMenu(menu);
        return menu;
    }

    private List<JMenuItem> getShelveActions() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        VCSContext ctx = VCSContext.forNodes((Node[])TopComponent.getRegistry().getActivatedNodes());
        VersioningSystem[] vs = Utils.getOwners(ctx);
        if (vs.length == 1) {
            Action action;
            ShelveChangesActionsRegistry.ShelveChangesActionProvider actionProvider = ShelveChangesActionsRegistry.getInstance().getActionProvider(vs[0]);
            if (actionProvider != null && (action = actionProvider.getAction()) != null && action.isEnabled()) {
                JMenuItem item = new JMenuItem();
                Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
                items.add(item);
            }
            for (Action a : Utilities.actionsForPath((String)"Actions/Versioning/ShelveChanges")) {
                JMenuItem item = new JMenuItem();
                Actions.connect((JMenuItem)item, (Action)a, (boolean)false);
                items.add(item);
            }
        }
        return items;
    }

    private List<JMenuItem> getUnshelveActions() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        List<String> list = Utils.getStringList(NbPreferences.forModule(ShelveChangesMenu.class), PREF_KEY_SHELVED_PATCHES);
        Action a = Utils.getAcceleratedAction("Actions/Versioning/UnshelveChanges/org-netbeans-modules-versioning-shelve-impl-UnshelveChangesAction.instance");
        if (a != null && !list.isEmpty()) {
            JMenuItem mItem = new JMenuItem();
            Actions.connect((JMenuItem)mItem, (Action)a, (boolean)false);
            items.add(mItem);
        }
        if (!list.isEmpty()) {
            List<PatchStorage.Patch> patches = PatchStorage.getInstance().getPatches();
            int i = 0;
            ListIterator<PatchStorage.Patch> it = patches.listIterator();
            while (it.hasNext() && ++i < 6) {
                PatchStorage.Patch patch = it.next();
                JMenuItem mItem = new JMenuItem();
                Actions.connect((JMenuItem)mItem, (Action)new UnshelveChangesAction(patch.getPatchName()), (boolean)false);
                items.add(mItem);
            }
        }
        return items;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void enableMenu(JMenu menu) {
        boolean enabled = false;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.isEnabled()) continue;
            enabled = true;
            break;
        }
        menu.setEnabled(enabled);
    }
}

