/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.versioning.diff.Bundle;
import org.netbeans.modules.versioning.diff.ExpandableMessage;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FilesModifiedConfirmation {
    private static final Object PROTOTYPE_LIST_CELL_VALUE = "Xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
    protected final JComponent mainComponent;
    protected final JList list;
    private final Listener listener = new Listener();
    private DialogDescriptor descriptor;
    protected final JButton btnSave;
    protected final JButton btnSaveAll = this.createSaveAllButton();
    private ArrayListModel<SaveCookie> listModel;
    private Dialog dialog;

    public FilesModifiedConfirmation(SaveCookie[] saveCookies) {
        this.btnSave = this.createSaveButton();
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveAll, (String)this.getInitialSaveAllButtonText());
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)this.getInitialSaveButtonText());
        this.list = this.createFilesList(saveCookies);
        JScrollPane scrollPane = new JScrollPane(this.list);
        if (!this.listModel.isEmpty()) {
            this.list.setSelectedIndex(0);
        } else {
            this.updateSaveButtonState();
        }
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.add(scrollPane);
        panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.mainComponent = panel;
    }

    protected JButton createSaveAllButton() {
        return new JButton();
    }

    protected JButton createSaveButton() {
        return new JButton();
    }

    private JList createFilesList(SaveCookie[] saveCookies) {
        this.listModel = new ArrayListModel<SaveCookie>(saveCookies);
        JList<SaveCookie> filesList = new JList<SaveCookie>(this.listModel);
        filesList.setVisibleRowCount(8);
        filesList.setPrototypeCellValue((SaveCookie)PROTOTYPE_LIST_CELL_VALUE);
        filesList.setSelectionMode(0);
        filesList.addListSelectionListener(this.listener);
        filesList.setCellRenderer(new ListCellRenderer());
        return filesList;
    }

    protected String getInitialSaveAllButtonText() {
        return this.getMessage("LBL_SaveAll", new Object[0]);
    }

    protected String getInitialSaveButtonText() {
        return this.getMessage("LBL_Save", new Object[0]);
    }

    private DialogDescriptor createDialogDescriptor() {
        DialogDescriptor desc = new DialogDescriptor(this.getMainDialogComponent(), this.getDialogTitle(), true, this.getDialogOptions(), null, 1, (HelpCtx)null, (ActionListener)this.listener);
        desc.setAdditionalOptions(this.getAdditionalOptions());
        desc.setClosingOptions(this.getDialogClosingOptions());
        return desc;
    }

    protected Object[] getDialogOptions() {
        return new Object[]{this.btnSaveAll, this.btnSave};
    }

    protected Object[] getAdditionalOptions() {
        return new Object[]{NotifyDescriptor.CANCEL_OPTION};
    }

    protected Object[] getDialogClosingOptions() {
        return new Object[]{NotifyDescriptor.CANCEL_OPTION};
    }

    protected Object getMainDialogComponent() {
        return this.mainComponent;
    }

    protected String getDialogTitle() {
        return this.getMessage("MSG_Title_UnsavedFiles", new Object[0]);
    }

    protected void tuneDialogDescriptor(DialogDescriptor descriptor) {
    }

    protected Dialog createDialog(DialogDescriptor descriptor) {
        return DialogDisplayer.getDefault().createDialog(descriptor);
    }

    public final Object displayDialog() {
        if (this.descriptor == null) {
            this.descriptor = this.createDialogDescriptor();
        }
        this.dialog = this.createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.descriptor.getValue();
    }

    protected void listSelectionChanged() {
        this.updateSaveButtonState();
    }

    private void updateSaveButtonState() {
        this.btnSave.setEnabled(this.list.getSelectedIndex() != -1);
    }

    protected void pressedSaveAll() {
        Collection<String> errMsgs = this.saveAll();
        if (errMsgs == null) {
            this.handleSaveAllSucceeded();
        } else {
            this.handleSaveAllFailed(errMsgs);
        }
    }

    protected void pressedSave() {
        String errMsg = this.save();
        if (errMsg != null) {
            this.handleSaveFailed(errMsg);
        }
        if (this.listModel.isEmpty()) {
            this.savedLastFile();
        }
    }

    protected Collection<String> saveAll() {
        ArrayList<String> errMsgs = null;
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            String itemErrMsg = this.save(i, false);
            if (itemErrMsg == null) continue;
            if (errMsgs == null) {
                errMsgs = new ArrayList<String>(this.listModel.getSize());
            }
            errMsgs.add(itemErrMsg);
        }
        this.listModel.removeAll();
        return errMsgs;
    }

    protected String save() {
        return this.save(this.list.getSelectedIndex(), true);
    }

    protected void handleSaveAllSucceeded() {
        this.closeDialog(this.btnSaveAll);
    }

    protected void handleSaveAllFailed(Collection<String> errMsgs) {
        JButton btnShowMoreInfo = new JButton();
        DialogDescriptor errDescr = new DialogDescriptor((Object)new ExpandableMessage("MSG_ExceptionWhileSavingMoreFiles_Intro", errMsgs, null, btnShowMoreInfo), this.getMessage("MSG_Title_SavingError", new Object[0]), true, -1, NotifyDescriptor.OK_OPTION, null);
        errDescr.setMessageType(0);
        errDescr.setOptions(new Object[]{NotifyDescriptor.OK_OPTION});
        errDescr.setAdditionalOptions(new Object[]{btnShowMoreInfo});
        errDescr.setClosingOptions(new Object[]{NotifyDescriptor.OK_OPTION});
        DialogDisplayer.getDefault().notify((NotifyDescriptor)errDescr);
        this.closeDialog(this.btnSaveAll);
    }

    protected void handleSaveFailed(String errMsg) {
        this.showSaveError(errMsg);
    }

    protected void showSaveError(String errMsg) {
        NotifyDescriptor.Message errDialog = new NotifyDescriptor.Message((Object)errMsg, 0);
        errDialog.setTitle(this.getMessage("MSG_Title_SavingError", new Object[0]));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)errDialog);
    }

    private String save(int index, boolean removeSavedFromList) {
        final SaveCookie saveCookie = this.listModel.getElementAt(index);
        final AtomicReference errMsg = new AtomicReference();
        ProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    saveCookie.save();
                }
                catch (IOException ex) {
                    String msg = Exceptions.findLocalizedMessage((Throwable)ex);
                    errMsg.set(msg);
                    if (msg == null) {
                        msg = FilesModifiedConfirmation.this.getMessage("MSG_exception_while_saving", saveCookie.toString());
                        ex = (IOException)Exceptions.attachLocalizedMessage((Throwable)ex, (String)msg);
                    }
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, (String)Bundle.MSG_SavingFile(saveCookie.toString()));
        if (errMsg.get() == null && removeSavedFromList) {
            this.listModel.removeItem(index);
        }
        return (String)errMsg.get();
    }

    protected void anotherActionPerformed(Object source) {
    }

    protected final void closeDialog(Object value) {
        this.descriptor.setValue(value);
        this.dialog.setVisible(false);
    }

    protected void savedLastFile() {
        this.handleSaveAllSucceeded();
    }

    protected String getMessage(String msgKey, Object ... params) {
        return FilesModifiedConfirmation.getMessage(this.getClass(), msgKey, params);
    }

    protected static String getMessage(Class<?> clazz, String msgKey, Object ... params) {
        return NbBundle.getMessage(clazz, (String)msgKey, (Object[])params);
    }

    private static class ArrayListModel<T>
    extends AbstractListModel {
        private T[] array;

        ArrayListModel(T[] array) {
            if (array == null) {
                throw new IllegalArgumentException("null");
            }
            this.array = array;
        }

        public boolean isEmpty() {
            return this.array.length == 0;
        }

        @Override
        public int getSize() {
            return this.array.length;
        }

        @Override
        public T getElementAt(int index) {
            return this.array[index];
        }

        void removeItem(int index) {
            this.array = CollectionUtils.removeItem(this.array, index);
            this.fireIntervalRemoved(this, index, index);
        }

        void removeAll() {
            int size = this.getSize();
            if (size != 0) {
                this.array = CollectionUtils.shortenArray(this.array, 0);
                this.fireIntervalRemoved(this, 0, size - 1);
            }
        }
    }

    class ListCellRenderer
    extends DefaultListCellRenderer {
        public ListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class Listener
    implements ActionListener,
    ListSelectionListener {
        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == FilesModifiedConfirmation.this.btnSaveAll) {
                FilesModifiedConfirmation.this.pressedSaveAll();
            } else if (source == FilesModifiedConfirmation.this.btnSave) {
                FilesModifiedConfirmation.this.pressedSave();
            } else {
                FilesModifiedConfirmation.this.anotherActionPerformed(source);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            assert (e.getSource() == FilesModifiedConfirmation.this.list);
            FilesModifiedConfirmation.this.listSelectionChanged();
        }
    }
}

