/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.turbo.Statistics;

final class Memory {
    private final int minimumSize;
    private final int maximumSize;
    private final Map minimalMap;
    private final Map liveEntitiesMap = new WeakHashMap(3571);
    public static final Object NULL = new Object();
    public static final ThreadLocal prepared = new ThreadLocal();
    private final Statistics statistics;
    private static final Random random = new Random(0L);

    public Memory(Statistics statistics, int minSize, int maxSize) {
        if (maxSize != -1 && (maxSize < minSize || maxSize < 1)) {
            throw new IllegalArgumentException();
        }
        this.minimumSize = minSize;
        this.maximumSize = maxSize;
        this.minimalMap = new LRU(this.minimumSize);
        this.statistics = statistics;
    }

    public synchronized void put(Object key, String name, Object value) {
        HashMap<String, Object> attributes = null;
        attributes = (HashMap<String, Object>)this.liveEntitiesMap.get(key);
        if (attributes == null && (attributes = (Map)this.minimalMap.get(key)) == null) {
            attributes = new HashMap<String, Object>(5);
        }
        if (value != null) {
            attributes.put(name, Memory.normalizeValue(value));
        } else {
            attributes.remove(name);
        }
        this.putLive(key, attributes);
        this.minimalMap.put(key, attributes);
        Entry entry = (Entry)prepared.get();
        if (entry != null && key.equals(entry.key) && name.equals(entry.name)) {
            if (value != null) {
                entry.value = Memory.normalizeValue(value);
            } else {
                prepared.set(null);
            }
        }
    }

    private void putLive(Object key, Map attributes) {
        if (this.maximumSize != -1 && this.liveEntitiesMap.size() >= this.maximumSize) {
            Set keySet = this.liveEntitiesMap.keySet();
            ArrayList l = new ArrayList(this.liveEntitiesMap.keySet());
            if (l.size() == this.maximumSize) {
                int limit = Math.min(7, this.maximumSize / 10);
                for (int i = 0; i < limit; ++i) {
                    int index = random.nextInt(this.maximumSize);
                    Object removed = l.get(index);
                    if (!keySet.remove(removed)) continue;
                    this.statistics.keyRemoved(removed);
                }
            }
        }
        this.liveEntitiesMap.put(key, attributes);
        this.statistics.keyAdded(key);
    }

    private static Object normalizeValue(Object value) {
        if (value == NULL) {
            return null;
        }
        return value;
    }

    public synchronized Object get(Object key, String name) {
        Map attributes = (Map)this.liveEntitiesMap.get(key);
        if (attributes != null) {
            return attributes.get(name);
        }
        attributes = (Map)this.minimalMap.get(key);
        if (attributes != null) {
            this.putLive(key, attributes);
            return attributes.get(name);
        }
        Entry entry = (Entry)prepared.get();
        if (entry != null && key.equals(entry.key) && name.equals(entry.name)) {
            prepared.set(null);
            return entry.value;
        }
        return null;
    }

    public synchronized boolean existsEntry(Object key, String name) {
        boolean isPrepared;
        Map attributes = (Map)this.liveEntitiesMap.get(key);
        if (attributes == null) {
            attributes = (Map)this.minimalMap.get(key);
        }
        boolean bl = isPrepared = attributes != null && attributes.keySet().contains(name);
        if (isPrepared) {
            Entry entry = (Entry)prepared.get();
            if (entry == null) {
                entry = new Entry();
            }
            entry.key = key;
            entry.name = name;
            entry.value = attributes.get(name);
            prepared.set(entry);
        } else {
            this.statistics.computeRemoved(this.liveEntitiesMap.keySet());
            prepared.set(null);
        }
        return isPrepared;
    }

    public synchronized Object getMonitoredKey(Object key) {
        Set keySet = this.liveEntitiesMap.keySet();
        if (keySet.contains(key)) {
            for (Object next : keySet) {
                if (!key.equals(next)) continue;
                return next;
            }
        }
        return null;
    }

    private class Entry {
        private Object key;
        private String name;
        private Object value;

        private Entry() {
        }
    }

    private static final class LRU
    extends LinkedHashMap {
        private final int maxSize;

        public LRU(int maxSize) {
            super(maxSize * 2, 0.5f, true);
            this.maxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }
}

