/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jquery.model;

import java.util.Collection;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;

public class JQueryWidgetInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("(\\$|jQuery)\\.widget");

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public void intercept(String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        String widgetName = null;
        int widgetNameOffset = -1;
        JsObject widget = null;
        for (FunctionArgument arg : args) {
            if (arg.getKind() == FunctionArgument.Kind.STRING) {
                widgetName = (String)arg.getValue();
                widgetNameOffset = arg.getOffset();
                continue;
            }
            if (arg.getKind() != FunctionArgument.Kind.ANONYMOUS_OBJECT) continue;
            widget = (JsObject)arg.getValue();
        }
        if (widgetName != null && widget != null) {
            JsObject newObject;
            String[] parts = widgetName.split("\\.");
            JsObject parent = globalObject;
            for (int i = 0; i < parts.length - 1; ++i) {
                newObject = factory.newObject(parent, parts[i], new OffsetRange(widgetNameOffset, widgetNameOffset + parts[i].length()), true);
                widgetNameOffset = widgetNameOffset + parts[i].length() + 1;
                parent.addProperty(parts[i], newObject);
                parent = newObject;
            }
            newObject = factory.newReference(parent, parts[parts.length - 1], new OffsetRange(widgetNameOffset, widgetNameOffset + parts[parts.length - 1].length()), widget, true, null);
            parent.addProperty(parts[parts.length - 1], newObject);
        }
    }
}

