/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.commons.Support;
import org.netbeans.modules.bugtracking.commons.TextUtils;
import org.openide.modules.Places;

public class IssueSettingsStorage {
    private static final Logger LOG = Logger.getLogger(IssueSettingsStorage.class.getName());
    private static final String PROP_COLLAPSED_COMMENT_PREFIX = "collapsed.comment";
    private static IssueSettingsStorage instance;
    private final File storage = this.getStorageRootFile();
    private static Map<String, String> loggedUrls;

    private IssueSettingsStorage() {
        if (!this.storage.exists()) {
            this.storage.mkdirs();
        }
    }

    public static synchronized IssueSettingsStorage getInstance() {
        if (instance == null) {
            instance = new IssueSettingsStorage();
        }
        return instance;
    }

    private File getStorageRootFile() {
        return new File(new File(Places.getUserDirectory(), "config"), "issue-tracking");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> loadCollapsedCommenst(String repoUrl, String id) {
        File file = this.getIssuePropertiesFile(repoUrl, id);
        FileLocks.FileLock l = FileLocks.getLock(file);
        try {
            Properties p = this.load(file, repoUrl, id);
            HashSet<Long> s = new HashSet<Long>();
            for (Object k : p.keySet()) {
                String key = k.toString();
                if (!key.startsWith(PROP_COLLAPSED_COMMENT_PREFIX) || !"true".equals(p.get(key))) continue;
                s.add(Long.parseLong(key.substring(PROP_COLLAPSED_COMMENT_PREFIX.length())));
            }
            HashSet<Long> hashSet = s;
            return hashSet;
        }
        catch (IOException ex) {
            Support.LOG.log(Level.WARNING, repoUrl + " " + id, ex);
        }
        finally {
            l.release();
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(File file, String repoUrl, String id) throws IOException {
        Properties p = new Properties();
        if (!file.exists()) {
            file.createNewFile();
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            p.load(fis);
        }
        finally {
            fis.close();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCollapsedComments(Collection<Long> collapsedComments, String repoUrl, String id) {
        File file = this.getIssuePropertiesFile(repoUrl, id);
        FileLocks.FileLock l = FileLocks.getLock(file);
        try {
            Properties p = this.load(file, repoUrl, id);
            this.clear(p, PROP_COLLAPSED_COMMENT_PREFIX);
            for (Long i : collapsedComments) {
                p.put(PROP_COLLAPSED_COMMENT_PREFIX + i, "true");
            }
            FileOutputStream fos = new FileOutputStream(file);
            try {
                p.store(fos, "");
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ex) {
            Support.LOG.log(Level.WARNING, repoUrl + " " + id, ex);
        }
        finally {
            l.release();
        }
    }

    private void clear(Properties p, String keyPrefix) {
        Iterator<Object> it = p.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.startsWith(keyPrefix)) continue;
            it.remove();
        }
    }

    private File getIssuePropertiesFile(String repoUrl, String id) {
        return new File(IssueSettingsStorage.getNameSpaceFolder(this.storage, repoUrl), id);
    }

    static File getNameSpaceFolder(File storage, String url) {
        File folderLegacy = new File(storage, TextUtils.encodeURL(url));
        File folder = new File(storage, TextUtils.getMD5(url));
        if (folderLegacy.exists()) {
            folderLegacy.renameTo(folder);
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (LOG.isLoggable(Level.FINE)) {
            String folderPath;
            if (loggedUrls == null) {
                loggedUrls = new HashMap<String, String>(1);
            }
            if ((folderPath = loggedUrls.get(url)) == null) {
                folderPath = folder.getAbsolutePath();
                loggedUrls.put(url, folderPath);
                LOG.log(Level.FINE, "storage folder for URL {0} is {1}", new Object[]{url, folderPath});
            }
        }
        return folder;
    }

    private static class FileLocks {
        private static FileLocks instance;
        private final Map<String, FileLock> locks = new HashMap<String, FileLock>();

        private FileLocks() {
        }

        private static synchronized FileLocks getInstance() {
            if (instance == null) {
                instance = new FileLocks();
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FileLock getLock(File file) {
            Map<String, FileLock> map = FileLocks.getInstance().locks;
            synchronized (map) {
                FileLock fl = FileLocks.getInstance().locks.get(file.getAbsolutePath());
                if (fl == null) {
                    FileLocks fileLocks = FileLocks.getInstance();
                    fileLocks.getClass();
                    fl = fileLocks.new FileLock(file);
                }
                FileLocks.getInstance().locks.put(file.getAbsolutePath(), fl);
                return fl;
            }
        }

        class FileLock {
            private final File file;

            public FileLock(File file) {
                this.file = file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void release() {
                Map map = FileLocks.getInstance().locks;
                synchronized (map) {
                    FileLocks.getInstance().locks.remove(this.file.getAbsolutePath());
                }
            }
        }
    }
}

