/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.util.Collection;
import java.util.regex.Matcher;
import javax.swing.text.Document;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public abstract class CssElementContext {
    public abstract boolean isRefactoringAllowed();

    public abstract String getElementName();

    public abstract FileObject getFileObject();

    public static abstract class AbstractFileContext
    extends CssElementContext {
        private FileObject fo;

        public AbstractFileContext(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public FileObject getFileObject() {
            return this.fo;
        }

        @Override
        public String getElementName() {
            return this.getFileObject().getName();
        }
    }

    public static class Editor
    extends CssElementContext {
        private int caretOffset;
        private int selectionFrom;
        private int selectionTo;
        private Node element;
        private CssParserResult result;
        private Snapshot topLevelSnapshot;

        public Editor(CssParserResult result, Snapshot topLevelSnapshot, int caretOffset, int selectionFrom, int selectionTo) {
            this.result = result;
            this.caretOffset = caretOffset;
            this.selectionFrom = selectionFrom;
            this.selectionTo = selectionTo;
            this.element = this.findCurrentElement();
            this.topLevelSnapshot = topLevelSnapshot;
            assert (this.element != null);
        }

        private Node findCurrentElement() {
            int astOffset;
            Node root = this.getParserResult().getParseTree();
            Node leaf = NodeUtil.findNodeAtOffset((Node)root, (int)(astOffset = this.getParserResult().getSnapshot().getEmbeddedOffset(this.caretOffset)));
            if (leaf != null) {
                leaf = leaf.parent();
            }
            return leaf == null ? root : leaf;
        }

        public Document getDocument() {
            return this.result.getSnapshot().getSource().getDocument(false);
        }

        public Snapshot getTopLevelSnapshot() {
            return this.topLevelSnapshot;
        }

        public CssParserResult getParserResult() {
            return this.result;
        }

        @Override
        public FileObject getFileObject() {
            return this.getParserResult().getSnapshot().getSource().getFileObject();
        }

        public int getCaret() {
            return this.caretOffset;
        }

        public int getSelectionFrom() {
            return this.selectionFrom;
        }

        public int getSelectionTo() {
            return this.selectionTo;
        }

        public Node getElement() {
            return this.element;
        }

        @Override
        public String getElementName() {
            switch (this.getElement().type()) {
                case resourceIdentifier: {
                    Node string = NodeUtil.getChildTokenNode((Node)this.getElement(), (CssTokenId)CssTokenId.STRING);
                    if (string != null) {
                        String ret = WebUtils.unquotedValue((CharSequence)string.image());
                        int dotIndex = ret.lastIndexOf(46);
                        if (dotIndex != -1) {
                            ret = ret.substring(0, dotIndex);
                        }
                        return ret;
                    }
                }
                case term: {
                    Matcher m;
                    Node uri = NodeUtil.getChildTokenNode((Node)this.getElement(), (CssTokenId)CssTokenId.URI);
                    if (uri != null && (m = Css3Utils.URI_PATTERN.matcher(uri.image())).matches()) {
                        int groupIndex = 1;
                        String content = m.group(groupIndex);
                        String ret = WebUtils.unquotedValue((CharSequence)content);
                        int dotIndex = ret.lastIndexOf(46);
                        if (dotIndex != -1) {
                            ret = ret.substring(0, dotIndex);
                        }
                        return ret;
                    }
                    return null;
                }
            }
            return this.getElement().image().toString().trim();
        }

        @Override
        public boolean isRefactoringAllowed() {
            switch (this.getElement().type()) {
                case resourceIdentifier: 
                case hexColor: {
                    return true;
                }
                case term: {
                    return null != NodeUtil.getChildTokenNode((Node)this.getElement(), (CssTokenId)CssTokenId.URI);
                }
            }
            return NodeUtil.isSelectorNode((Node)this.getElement());
        }
    }

    public static class File
    extends AbstractFileContext {
        private Collection<CssParserResult> results;

        public File(FileObject fileObject, Collection<CssParserResult> result) {
            super(fileObject);
            this.results = result;
        }

        public Collection<CssParserResult> getParserResults() {
            return this.results;
        }

        @Override
        public boolean isRefactoringAllowed() {
            return true;
        }
    }

    public static class Folder
    extends AbstractFileContext {
        public Folder(FileObject folder) {
            super(folder);
        }

        @Override
        public boolean isRefactoringAllowed() {
            return true;
        }
    }
}

