/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.refactoring.CssElementContext;
import org.netbeans.modules.css.refactoring.CssRenameRefactoringUI;
import org.netbeans.modules.css.refactoring.WhereUsedUI;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class CssActionsImplementationProvider
extends ActionsImplementationProvider {
    private static final RequestProcessor RP = new RequestProcessor(CssActionsImplementationProvider.class);
    private static final Logger LOG = Logger.getLogger(CssActionsImplementationProvider.class.getName());

    public boolean canRename(Lookup lookup) {
        Collection nodes = lookup.lookupAll(org.openide.nodes.Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        org.openide.nodes.Node node = (org.openide.nodes.Node)nodes.iterator().next();
        return CssActionsImplementationProvider.isCssFile(node) || CssActionsImplementationProvider.isRefactorableEditorElement(node);
    }

    public void doRename(Lookup selectedNodes) {
        UserTask task;
        EditorCookie ec = (EditorCookie)selectedNodes.lookup(EditorCookie.class);
        if (CssActionsImplementationProvider.isFromEditor(ec)) {
            task = new TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(CssElementContext context) {
                    return new CssRenameRefactoringUI(context);
                }
            };
        } else {
            Collection nodes = selectedNodes.lookupAll(org.openide.nodes.Node.class);
            assert (nodes.size() == 1);
            org.openide.nodes.Node currentNode = (org.openide.nodes.Node)nodes.iterator().next();
            task = new NodeToFileTask(currentNode){

                @Override
                protected RefactoringUI createRefactoringUI(CssElementContext context) {
                    return new CssRenameRefactoringUI(context);
                }
            };
        }
        RP.post((Runnable)task);
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection nodes = lookup.lookupAll(org.openide.nodes.Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        org.openide.nodes.Node node = (org.openide.nodes.Node)nodes.iterator().next();
        return CssActionsImplementationProvider.isCssFile(node) || CssActionsImplementationProvider.isRefactorableEditorElement(node);
    }

    public void doFindUsages(Lookup lookup) {
        UserTask task;
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (CssActionsImplementationProvider.isFromEditor(ec)) {
            task = new TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(CssElementContext context) {
                    return new WhereUsedUI(context);
                }
            };
        } else {
            Collection nodes = lookup.lookupAll(org.openide.nodes.Node.class);
            assert (nodes.size() == 1);
            org.openide.nodes.Node currentNode = (org.openide.nodes.Node)nodes.iterator().next();
            task = new NodeToFileTask(currentNode){

                @Override
                protected RefactoringUI createRefactoringUI(CssElementContext context) {
                    return new WhereUsedUI(context);
                }
            };
        }
        RP.post((Runnable)task);
    }

    private static boolean isCssFile(org.openide.nodes.Node node) {
        FileObject fo = CssActionsImplementationProvider.getFileObjectFromNode(node);
        if (fo == null) {
            return false;
        }
        return "text/css".equals(fo.getMIMEType());
    }

    private static boolean isRefactorableEditorElement(final org.openide.nodes.Node node) {
        class Context {
            public int caret;
            public Document document;

            Context() {
            }
        }
        final Context context = (Context)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Context>(){

            public Context run() {
                EditorCookie ec = CssActionsImplementationProvider.getEditorCookie(node);
                if (CssActionsImplementationProvider.isFromEditor(ec)) {
                    Context context = new Context();
                    context.document = ec.getDocument();
                    JEditorPane pane = ec.getOpenedPanes()[0];
                    context.caret = pane.getCaretPosition();
                    return context;
                }
                return null;
            }
        });
        if (context == null) {
            return false;
        }
        Source source = Source.create((Document)context.document);
        final AtomicBoolean res = new AtomicBoolean(false);
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){
                {
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    ResultIterator cssRi = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                    if (cssRi != null) {
                        CssParserResult result = (CssParserResult)cssRi.getParserResult();
                        int embeddedCaret = result.getSnapshot().getEmbeddedOffset(context.caret);
                        Node leaf = NodeUtil.findNonTokenNodeAtOffset((Node)result.getParseTree(), (int)embeddedCaret);
                        if (leaf != null) {
                            switch (leaf.type()) {
                                case resourceIdentifier: 
                                case elementName: 
                                case cssClass: 
                                case cssId: 
                                case hexColor: {
                                    res.set(true);
                                    break;
                                }
                                default: {
                                    res.set(false);
                                }
                            }
                        }
                    }
                }
            });
            return res.get();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private static FileObject getFileObjectFromNode(org.openide.nodes.Node node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    private static EditorCookie getEditorCookie(org.openide.nodes.Node node) {
        return (EditorCookie)node.getLookup().lookup(EditorCookie.class);
    }

    public static abstract class NodeToFileTask
    extends UserTask
    implements Runnable {
        private final org.openide.nodes.Node node;
        private CssElementContext context;
        private FileObject fileObject;

        public NodeToFileTask(org.openide.nodes.Node node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ResultIterator resultIterator) throws Exception {
            ArrayList<CssParserResult> results = new ArrayList<CssParserResult>();
            Snapshot snapshot = resultIterator.getSnapshot();
            try {
                if ("text/css".equals(snapshot.getMimeType())) {
                    results.add((CssParserResult)resultIterator.getParserResult());
                    return;
                }
                for (Embedding e : resultIterator.getEmbeddings()) {
                    this.run(resultIterator.getResultIterator(e));
                }
            }
            finally {
                this.context = new CssElementContext.File(this.fileObject, results);
            }
        }

        @Override
        public void run() {
            DataObject dobj = (DataObject)this.node.getLookup().lookup(DataObject.class);
            if (dobj != null) {
                Runnable task;
                this.fileObject = dobj.getPrimaryFile();
                if (this.fileObject.isFolder()) {
                    task = new Runnable(){

                        @Override
                        public void run() {
                            UI.openRefactoringUI((RefactoringUI)NodeToFileTask.this.createRefactoringUI(new CssElementContext.Folder(NodeToFileTask.this.fileObject)));
                        }
                    };
                } else {
                    Source source = Source.create((FileObject)this.fileObject);
                    try {
                        ParserManager.parse(Collections.singletonList(source), (UserTask)this);
                        task = new Runnable(){

                            @Override
                            public void run() {
                                UI.openRefactoringUI((RefactoringUI)NodeToFileTask.this.createRefactoringUI(NodeToFileTask.this.context));
                            }
                        };
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return;
                    }
                }
                EventQueue.invokeLater(task);
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CssElementContext var1);
    }

    public static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private final Document document;
        private final int caretOffset;
        private final int selectionStart;
        private final int selectionEnd;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie ec) {
            JEditorPane textC = ec.getOpenedPanes()[0];
            this.document = textC.getDocument();
            this.caretOffset = textC.getCaretPosition();
            this.selectionStart = textC.getSelectionStart();
            this.selectionEnd = textC.getSelectionEnd();
        }

        public void run(ResultIterator ri) throws ParseException {
            CssParserResult result;
            Snapshot topLevelSnapshot = ri.getSnapshot();
            ResultIterator cssri = WebUtils.getResultIterator((ResultIterator)ri, (String)"text/css");
            if (cssri != null && (result = (CssParserResult)cssri.getParserResult()).getParseTree() != null) {
                CssElementContext.Editor context = new CssElementContext.Editor(result, topLevelSnapshot, this.caretOffset, this.selectionStart, this.selectionEnd);
                this.ui = ((CssElementContext)context).isRefactoringAllowed() ? this.createRefactoringUI(context) : null;
            }
        }

        @Override
        public final void run() {
            try {
                Source source = Source.create((Document)this.document);
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TopComponent activetc = TopComponent.getRegistry().getActivated();
                    if (TextComponentTask.this.ui != null) {
                        UI.openRefactoringUI((RefactoringUI)TextComponentTask.this.ui, (TopComponent)activetc);
                    } else {
                        JOptionPane.showMessageDialog(null, NbBundle.getMessage(CssActionsImplementationProvider.class, (String)"ERR_CannotRefactorLoc"));
                    }
                }
            });
        }

        protected abstract RefactoringUI createRefactoringUI(CssElementContext var1);
    }
}

