/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.spi;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.CssTokenIdCategory;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;

public class CompletionContext
extends EditorFeatureContext {
    private final CodeCompletionHandler.QueryType queryType;
    private final int anchorOffset;
    private final int embeddedCaretOffset;
    private final int embeddedAnchorOffset;
    private final int activeTokenDiff;
    private final String prefix;
    private final Node activeNode;
    private final TokenSequence<CssTokenId> tokenSequence;
    private final Node activeTokenNode;
    private final int tsIndex;

    public CompletionContext(Node activeNode, Node activeTokeNode, CssParserResult result, TokenSequence<CssTokenId> tokenSequence, int tsIndex, int activeTokenDiff, CodeCompletionHandler.QueryType queryType, int caretOffset, int anchorOffset, int embeddedCaretOffset, int embeddedAnchorOffset, String prefix) {
        super(result, caretOffset);
        this.tokenSequence = tokenSequence;
        this.tsIndex = tsIndex;
        this.activeNode = activeNode;
        this.activeTokenNode = activeTokeNode;
        this.queryType = queryType;
        this.anchorOffset = anchorOffset;
        this.embeddedCaretOffset = embeddedCaretOffset;
        this.embeddedAnchorOffset = embeddedAnchorOffset;
        this.prefix = prefix;
        this.activeTokenDiff = activeTokenDiff;
    }

    @Override
    public TokenSequence<CssTokenId> getTokenSequence() {
        return this.tokenSequence;
    }

    public Node getActiveNode() {
        return this.activeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CssTokenId getActiveTokenId() {
        try {
            TokenSequence<CssTokenId> ts = this.getTokenSequence();
            CssTokenId cssTokenId = ts.token() == null ? null : (CssTokenId)ts.token().id();
            return cssTokenId;
        }
        finally {
            this.restoreTokenSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Node getNodeForNonWhiteTokenBackward() {
        TokenSequence<CssTokenId> ts = this.getTokenSequence();
        this.restoreTokenSequence();
        try {
            do {
                Token t;
                if ((t = ts.token()) == null) {
                    Node node = this.getParseTreeRoot();
                    return node;
                }
                if (CssTokenIdCategory.WHITESPACES.name().toLowerCase().equals(t.id().primaryCategory())) continue;
                Node node = NodeUtil.findNonTokenNodeAtOffset((Node)this.getParseTreeRoot(), (int)(ts.offset() + t.length()));
                return node;
            } while (ts.movePrevious());
            Node node = this.getParseTreeRoot();
            return node;
        }
        finally {
            this.restoreTokenSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CssTokenId getNonWhiteTokenIdBackward() {
        TokenSequence<CssTokenId> ts = this.getTokenSequence();
        this.restoreTokenSequence();
        try {
            do {
                Token t;
                if ((t = ts.token()) == null) {
                    CssTokenId cssTokenId = null;
                    return cssTokenId;
                }
                if (CssTokenIdCategory.WHITESPACES.name().toLowerCase().equals(((CssTokenId)t.id()).primaryCategory())) continue;
                CssTokenId cssTokenId = (CssTokenId)t.id();
                return cssTokenId;
            } while (ts.movePrevious());
            CssTokenId cssTokenId = null;
            return cssTokenId;
        }
        finally {
            this.restoreTokenSequence();
        }
    }

    public void restoreTokenSequence() {
        this.getTokenSequence().moveIndex(this.tsIndex);
        this.getTokenSequence().moveNext();
    }

    public Node getActiveTokenNode() {
        return this.activeTokenNode;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public int getEmbeddedCaretOffset() {
        return this.embeddedCaretOffset;
    }

    public int getEmbeddedAnchorOffset() {
        return this.embeddedAnchorOffset;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public CodeCompletionHandler.QueryType getQueryType() {
        return this.queryType;
    }

    public int getActiveTokenDiff() {
        return this.activeTokenDiff;
    }
}

