/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.editor.module.main.NamespaceCompletionItem;
import org.netbeans.modules.css.editor.module.main.NamespaceStructureItem;
import org.netbeans.modules.css.editor.module.main.TopLevelStructureItem;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssCompletionItem;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Namespace;
import org.netbeans.modules.css.model.api.Namespaces;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.web.common.api.LexerUtils;

public class NamespacesModule
extends CssEditorModule {
    private static final String NAMESPACE_KEYWORD = "@namespace";
    static ElementKind NAMESPACE_ELEMENT_KIND = ElementKind.GLOBAL;

    @Override
    public List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        Node activeNode = context.getActiveNode();
        boolean isError = false;
        block23: while (true) {
            switch (activeNode.type()) {
                case error: 
                case recovery: {
                    activeNode = activeNode.parent();
                    isError = true;
                    continue block23;
                }
            }
            break;
        }
        switch (activeNode.type()) {
            case namespacePrefix: 
            case elementName: {
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                break;
            }
            case namespaces: {
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                break;
            }
            case root: 
            case styleSheet: 
            case body: {
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
            }
            case bodyItem: {
                if (context.getActiveTokenId() != null && context.getActiveTokenId() != CssTokenId.WS && context.getActiveTokenId() != CssTokenId.AT_IDENT && (context.getActiveTokenId() != CssTokenId.ERROR || !context.getPrefix().startsWith("@"))) break;
                CssCompletionItem nsKeywordProposal = CssCompletionItem.createRAWCompletionItem(new CssElement(NAMESPACE_KEYWORD), NAMESPACE_KEYWORD, ElementKind.FIELD, context.getAnchorOffset(), false);
                proposals.add((CompletionProposal)nsKeywordProposal);
                break;
            }
            case media: 
            case combinator: 
            case selector: 
            case selectorsGroup: {
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                break;
            }
            case elementSubsequent: 
            case typeSelector: {
                switch (context.getActiveTokenId()) {
                    case WS: 
                    case NL: {
                        proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                    }
                    case AT_SIGN: {
                        if (!isError) break;
                        proposals.add((CompletionProposal)CssCompletionItem.createRAWCompletionItem(new CssElement(NAMESPACE_KEYWORD), NAMESPACE_KEYWORD, ElementKind.FIELD, context.getAnchorOffset(), false));
                    }
                }
                break;
            }
            case generic_at_rule: {
                proposals.add((CompletionProposal)CssCompletionItem.createRAWCompletionItem(new CssElement(NAMESPACE_KEYWORD), NAMESPACE_KEYWORD, ElementKind.FIELD, context.getAnchorOffset(), false));
                break;
            }
            case namespace: {
                CssTokenId tokenId = (CssTokenId)context.getTokenSequence().token().id();
                if (tokenId == CssTokenId.NAMESPACE_SYM) {
                    CssCompletionItem nsKeywordProposal = CssCompletionItem.createRAWCompletionItem(new CssElement(NAMESPACE_KEYWORD), NAMESPACE_KEYWORD, ElementKind.FIELD, context.getAnchorOffset(), false);
                    proposals.add((CompletionProposal)nsKeywordProposal);
                }
            }
            case simpleSelectorSequence: {
                if (!isError) break;
                Token token = context.getTokenSequence().token();
                switch ((CssTokenId)token.id()) {
                    case IDENT: {
                        if (LexerUtils.followsToken(context.getTokenSequence(), EnumSet.of(CssTokenId.LBRACKET, CssTokenId.COMMA), (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS}) == null) break;
                        proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                        break;
                    }
                    case WS: 
                    case LBRACKET: {
                        proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                    }
                }
                break;
            }
            case slAttribute: 
            case slAttributeName: 
            case namespacePrefixName: {
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
            }
        }
        return Utilities.filterCompletionProposals(proposals, context.getPrefix(), true);
    }

    private static List<CompletionProposal> getNamespaceCompletionProposals(final CompletionContext context) {
        final ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        Model sourceModel = context.getSourceModel();
        sourceModel.runReadTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                Namespaces namespaces = styleSheet.getNamespaces();
                if (namespaces == null) {
                    return;
                }
                for (Namespace ns : namespaces.getNamespaces()) {
                    proposals.add(new NamespaceCompletionItem(ns.getNamespacePrefixName().getContent().toString(), ns.getResourceIdentifier().getContent().toString(), context.getAnchorOffset()));
                }
            }
        });
        return proposals;
    }

    @Override
    public <T extends Map<OffsetRange, Set<ColoringAttributes>>> NodeVisitor<T> getSemanticHighlightingNodeVisitor(FeatureContext context, T result) {
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case namespacePrefix: {
                        ((Map)this.getResult()).put(Css3Utils.getOffsetRange(node), ColoringAttributes.CONSTRUCTOR_SET);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public <T extends Set<OffsetRange>> NodeVisitor<T> getMarkOccurrencesNodeVisitor(EditorFeatureContext context, T result) {
        return Utilities.createMarkOccurrencesNodeVisitor(context, result, NodeType.namespacePrefix);
    }

    @Override
    public <T extends List<StructureItem>> NodeVisitor<T> getStructureItemsNodeVisitor(final FeatureContext context, final T result) {
        final ArrayList items = new ArrayList();
        return new NodeVisitor<T>(){

            private void addItem(StructureItem si) {
                if (items.isEmpty()) {
                    result.add(new TopLevelStructureItem.Namespaces(items));
                }
                items.add(si);
            }

            public boolean visit(Node node) {
                if (node.type() == NodeType.namespace) {
                    this.addItem(new NamespaceStructureItem(context.getFileObject(), node));
                }
                return false;
            }
        };
    }
}

