/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.csl.CssNodeElement;
import org.netbeans.modules.parsing.api.Snapshot;

public class CssRuleStructureItem
implements StructureItem {
    private CharSequence name;
    private CssNodeElement element;
    private int from;
    private int to;

    private static String escape(String s) {
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        return s;
    }

    CssRuleStructureItem(CharSequence name, CssNodeElement element, Snapshot source) {
        this.name = name;
        this.element = element;
        this.from = source.getOriginalOffset(element.from());
        this.to = source.getOriginalOffset(element.to());
    }

    public String getName() {
        return this.name.toString();
    }

    public String getSortText() {
        return this.getName();
    }

    public String getHtml(HtmlFormatter formatter) {
        return CssRuleStructureItem.escape(this.getName());
    }

    public ElementHandle getElementHandle() {
        return this.element;
    }

    public ElementKind getKind() {
        return ElementKind.RULE;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean isLeaf() {
        return true;
    }

    public List<? extends StructureItem> getNestedItems() {
        return Collections.emptyList();
    }

    public long getPosition() {
        return this.from;
    }

    public long getEndPosition() {
        return this.to;
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssRuleStructureItem other = (CssRuleStructureItem)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }
}

