/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.swing.ImageIcon;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.CssProjectSupport;
import org.netbeans.modules.css.editor.HtmlTags;
import org.netbeans.modules.css.editor.URLRetriever;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.editor.csl.CssPropertyElement;
import org.netbeans.modules.css.editor.csl.CssValueElement;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssCompletionItem;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.CssTokenIdCategory;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.ResolvedProperty;
import org.netbeans.modules.css.lib.api.properties.UnitGrammarElement;
import org.netbeans.modules.css.lib.api.properties.ValueGrammarElement;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReferenceCompletion;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public class CssCompletion
implements CodeCompletionHandler {
    private static final Collection<String> AT_RULES = Arrays.asList("@media", "@page", "@import", "@charset", "@font-face");
    private static char firstPrefixChar;
    private static final String EMPTY_STRING = "";
    private static final String UNIVERSAL_SELECTOR = "*";
    private static final Collection<String> HIDDEN_UNITS;
    static String[] TEST_USED_COLORS;
    static String[] TEST_CLASSES;
    static String[] TEST_IDS;

    public CodeCompletionResult complete(CodeCompletionContext context) {
        int diff;
        String prefix;
        ArrayList<CompletionProposal> completionProposals = new ArrayList<CompletionProposal>();
        CssParserResult info = (CssParserResult)context.getParserResult();
        Snapshot snapshot = info.getSnapshot();
        FileObject file = snapshot.getSource().getFileObject();
        int caretOffset = context.getCaretOffset();
        String string = prefix = context.getPrefix() != null ? context.getPrefix() : EMPTY_STRING;
        if (firstPrefixChar != '\u0000') {
            prefix = firstPrefixChar + prefix;
        }
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(CssTokenId.language());
        assert (ts != null);
        CodeCompletionResult lexicalCompletionResult = this.handleLexicalBasedCompletion(file, (TokenSequence<CssTokenId>)ts, snapshot, caretOffset);
        if (lexicalCompletionResult != null) {
            return lexicalCompletionResult;
        }
        int offset = caretOffset - prefix.length();
        int astOffset = snapshot.getEmbeddedOffset(offset);
        int astCaretOffset = snapshot.getEmbeddedOffset(caretOffset);
        boolean unmappableClassOrId = false;
        if (astOffset == -1) {
            if (prefix.length() == 1 && prefix.charAt(0) == '.' || prefix.length() > 0 && prefix.charAt(0) == '#') {
                unmappableClassOrId = true;
            } else {
                return null;
            }
        }
        boolean tokenFound = (diff = ts.move(astCaretOffset)) == 0 ? (ts.movePrevious() ? true : ts.moveNext()) : (ts.moveNext() ? true : ts.movePrevious());
        Node root = info.getParseTree();
        if (root == null) {
            return CodeCompletionResult.NONE;
        }
        char charAfterCaret = snapshot.getText().length() > astCaretOffset + 1 ? (char)snapshot.getText().subSequence(astCaretOffset, astCaretOffset + 1).charAt(0) : (char)' ';
        Node tokenNode = NodeUtil.findNodeAtOffset((Node)root, (int)astCaretOffset);
        CssTokenId tokenNodeTokenId = tokenNode.type() == NodeType.token ? NodeUtil.getTokenNodeTokenId((Node)tokenNode) : null;
        Node node = NodeUtil.findNonTokenNodeAtOffset((Node)root, (int)astCaretOffset);
        if (node.type() == NodeType.ws) {
            node = node.parent();
        }
        CompletionContext completionContext = new CompletionContext(node, tokenNode, info, (TokenSequence<CssTokenId>)ts, ts.index(), diff, context.getQueryType(), caretOffset, offset, astCaretOffset, astOffset, prefix);
        List<CompletionProposal> cssModulesCompletionProposals = CssModuleSupport.getCompletionProposals(completionContext);
        completionProposals.addAll(cssModulesCompletionProposals);
        this.completeClassSelectors(completionContext, completionProposals, unmappableClassOrId);
        this.completeIdSelectors(completionContext, completionProposals, unmappableClassOrId);
        this.completeAtRulesAndHtmlSelectors(completionContext, completionProposals);
        this.completeHtmlSelectors(completionContext, completionProposals, (TokenId)tokenNodeTokenId);
        this.completeKeywords(completionContext, completionProposals, tokenFound);
        this.completePropertyName(completionContext, completionProposals);
        this.completePropertyValue(completionContext, completionProposals, charAfterCaret);
        return new DefaultCompletionResult(completionProposals, false);
    }

    private List<? extends CompletionProposal> completeImport(FileObject base, int offset, String prefix, boolean addQuotes, boolean addSemicolon) {
        CssLinkCompletion fileCompletion = new CssLinkCompletion(base, addQuotes, addSemicolon);
        return fileCompletion.getItems(base, offset - prefix.length(), prefix);
    }

    private List<CompletionProposal> completeHtmlSelectors(CompletionContext context, String prefix, int offset) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(20);
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(HtmlTags.getTags()));
        items.add(UNIVERSAL_SELECTOR);
        for (String tagName : items) {
            if (!tagName.startsWith(prefix.toLowerCase(Locale.ENGLISH))) continue;
            proposals.add((CompletionProposal)CssCompletionItem.createSelectorCompletionItem(new CssElement(context.getSource().getFileObject(), tagName), tagName, offset, true));
        }
        return proposals;
    }

    private Collection<CompletionProposal> wrapPropertyValues(CompletionContext context, String prefix, PropertyDefinition propertyDescriptor, Collection<ValueGrammarElement> props, int anchor, boolean addSemicolon, boolean addSpaceBeforeItem, boolean extendedItemsOnly) {
        HashMap<String, LinkedList<ValueGrammarElement>> value2GrammarElement = new HashMap<String, LinkedList<ValueGrammarElement>>();
        for (ValueGrammarElement element : props) {
            String elementValue = element.getValue().toString();
            LinkedList<ValueGrammarElement> col = (LinkedList<ValueGrammarElement>)value2GrammarElement.get(elementValue);
            if (col == null) {
                col = new LinkedList<ValueGrammarElement>();
                value2GrammarElement.put(elementValue, col);
            }
            col.add(element);
        }
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(props.size());
        boolean colorChooserAdded = false;
        for (Map.Entry entry : value2GrammarElement.entrySet()) {
            String elementValue = (String)entry.getKey();
            Collection elements = (Collection)entry.getValue();
            ValueGrammarElement element = (ValueGrammarElement)elements.iterator().next();
            CssValueElement handle = new CssValueElement(propertyDescriptor, (GrammarElement)element);
            String origin = element.origin();
            String visibleOrigin = element.getVisibleOrigin();
            if (element instanceof UnitGrammarElement) {
                UnitGrammarElement unit = (UnitGrammarElement)element;
                String unitName = unit.getValue();
                if (HIDDEN_UNITS.contains(unitName)) continue;
                if (unit.getFixedValues() != null) {
                    for (String fixedValue : unit.getFixedValues()) {
                        proposals.add((CompletionProposal)CssCompletionItem.createValueCompletionItem(handle, fixedValue, visibleOrigin, anchor, addSemicolon, addSpaceBeforeItem));
                    }
                    continue;
                }
                proposals.add(CssCompletionItem.createUnitCompletionItem((UnitGrammarElement)element));
                continue;
            }
            if (origin.endsWith("_operator")) continue;
            if ("@colors-list".equals(origin)) {
                if (!colorChooserAdded) {
                    proposals.add(CssCompletionItem.createColorChooserCompletionItem(anchor, visibleOrigin, addSemicolon));
                    proposals.addAll(this.getUsedColorsItems(context, prefix, handle, visibleOrigin, anchor, addSemicolon, addSpaceBeforeItem));
                    colorChooserAdded = true;
                }
                if (extendedItemsOnly) continue;
                proposals.add((CompletionProposal)CssCompletionItem.createColorValueCompletionItem(handle, (GrammarElement)element, anchor, addSemicolon, addSpaceBeforeItem));
                continue;
            }
            if (extendedItemsOnly) continue;
            String vo = null;
            boolean same = true;
            for (ValueGrammarElement e : elements) {
                if (vo == null) {
                    vo = e.getVisibleOrigin();
                    continue;
                }
                if (vo.equals(e.getVisibleOrigin())) continue;
                same = false;
                break;
            }
            proposals.add((CompletionProposal)CssCompletionItem.createValueCompletionItem(handle, element, same ? visibleOrigin : "...", anchor, addSemicolon, addSpaceBeforeItem));
        }
        return proposals;
    }

    private Collection<CompletionProposal> getUsedColorsItems(CompletionContext context, String prefix, CssElement element, String origin, int anchor, boolean addSemicolon, boolean addSpaceBeforeItem) {
        FileObject current;
        HashSet<CompletionProposal> proposals = new HashSet<CompletionProposal>();
        if (TEST_USED_COLORS != null) {
            for (String color : TEST_USED_COLORS) {
                proposals.add((CompletionProposal)CssCompletionItem.createHashColorCompletionItem(element, color, origin, anchor, addSemicolon, addSpaceBeforeItem, true));
            }
        }
        if ((current = context.getParserResult().getSnapshot().getSource().getFileObject()) == null) {
            return proposals;
        }
        CssProjectSupport support = CssProjectSupport.findFor(current);
        if (support == null) {
            return proposals;
        }
        CssIndex index = support.getIndex();
        Map<FileObject, Collection<String>> result = index.findAll(RefactoringElementType.COLOR);
        ArrayList<FileObject> resortedKeys = new ArrayList<FileObject>(result.keySet());
        if (resortedKeys.remove(current)) {
            resortedKeys.add(0, current);
        }
        for (FileObject file : resortedKeys) {
            Collection<String> colors = result.get(file);
            boolean usedInCurrentFile = file.equals(current);
            for (String color : colors) {
                if (!color.startsWith(prefix)) continue;
                proposals.add((CompletionProposal)CssCompletionItem.createHashColorCompletionItem(element, color, origin, anchor, addSemicolon, addSpaceBeforeItem, usedInCurrentFile));
            }
        }
        return proposals;
    }

    private Collection<String> filterStrings(Collection<String> values, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<String> filtered = new ArrayList<String>();
        for (String value : values) {
            if (!value.toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private Collection<ValueGrammarElement> filterElements(Collection<ValueGrammarElement> values, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<ValueGrammarElement> filtered = new ArrayList<ValueGrammarElement>();
        for (ValueGrammarElement value : values) {
            if (!value.toString().toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private Collection<PropertyDefinition> filterProperties(Collection<PropertyDefinition> props, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<PropertyDefinition> filtered = new ArrayList<PropertyDefinition>();
        for (PropertyDefinition p : props) {
            if (!p.getName().toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(p);
        }
        return filtered;
    }

    public String document(ParserResult info, ElementHandle element) {
        block5: {
            FileObject fileObject = info.getSnapshot().getSource().getFileObject();
            HelpResolver resolver = CssModuleSupport.getHelpResolver();
            if (resolver != null) {
                if (element instanceof CssPropertyElement) {
                    CssPropertyElement e = (CssPropertyElement)element;
                    PropertyDefinition property = e.getPropertyDescriptor();
                    return resolver.getHelp(fileObject, property);
                }
                if (element instanceof ElementHandle.UrlHandle) {
                    try {
                        return URLRetriever.getURLContentAndCache(new URL(element.getName()));
                    }
                    catch (MalformedURLException e) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
        }
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle elementHandle) {
        if (elementHandle instanceof CssPropertyElement) {
            URL url;
            CssPropertyElement e = (CssPropertyElement)elementHandle;
            PropertyDefinition property = e.getPropertyDescriptor();
            HelpResolver helpResolver = CssModuleSupport.getHelpResolver();
            if (helpResolver != null && (url = helpResolver.resolveLink(elementHandle.getFileObject(), property, link)) != null) {
                return new ElementHandle.UrlHandle(url.toExternalForm());
            }
        }
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        boolean inPropertyDeclaration;
        CssParserResult result = (CssParserResult)info;
        Snapshot snapshot = info.getSnapshot();
        int embeddedCaretOffset = snapshot.getEmbeddedOffset(caretOffset);
        TokenHierarchy hi = snapshot.getTokenHierarchy();
        String prefix = this.getPrefix((TokenSequence<CssTokenId>)hi.tokenSequence(CssTokenId.language()), embeddedCaretOffset);
        if (prefix == null) {
            return null;
        }
        Node leaf = NodeUtil.findNonTokenNodeAtOffset((Node)result.getParseTree(), (int)embeddedCaretOffset);
        boolean bl = inPropertyDeclaration = NodeUtil.getAncestorByType((Node)leaf, (NodeType)NodeType.propertyDeclaration) != null;
        if (!(inPropertyDeclaration || prefix.length() <= 0 || prefix.charAt(0) != '.' && prefix.charAt(0) != '#')) {
            firstPrefixChar = prefix.charAt(0);
            return prefix.substring(1);
        }
        firstPrefixChar = '\u0000';
        return prefix;
    }

    private String getPrefix(TokenSequence<CssTokenId> ts, int caretOffset) {
        if (ts == null) {
            return null;
        }
        int diff = ts.move(caretOffset);
        if (diff == 0) {
            if (!ts.movePrevious()) {
                return EMPTY_STRING;
            }
        } else if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        switch (((CssTokenId)t.id()).getTokenCategory()) {
            case KEYWORDS: 
            case OPERATORS: 
            case BRACES: {
                return EMPTY_STRING;
            }
        }
        int skipPrefixChars = 0;
        switch ((CssTokenId)t.id()) {
            case COLON: 
            case DCOLON: 
            case COMMA: 
            case LBRACKET: {
                return EMPTY_STRING;
            }
            case STRING: {
                skipPrefixChars = 1;
                break;
            }
            case URI: {
                String text;
                Matcher m;
                if (diff <= 0 || !(m = Css3Utils.URI_PATTERN.matcher(text = ts.token().text().toString())).matches()) break;
                int groupIndex = 1;
                String value = m.group(groupIndex);
                int valueStart = m.start(groupIndex);
                int cutIndex = diff - valueStart;
                int lastSeparatorIndex = (value = value.substring(0, cutIndex)).lastIndexOf(Css3Utils.FILE_SEPARATOR);
                if (lastSeparatorIndex != -1) {
                    skipPrefixChars = valueStart + lastSeparatorIndex + 1;
                    break;
                }
                skipPrefixChars = valueStart;
                if (value.isEmpty() || value.charAt(0) != '\"' && value.charAt(0) != '\'') break;
                ++skipPrefixChars;
            }
        }
        return t.text().subSequence(skipPrefixChars, diff == 0 ? t.text().length() : diff).toString().trim();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        int offset = component.getCaretPosition();
        if (typedText == null || typedText.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char c = typedText.charAt(typedText.length() - 1);
        TokenSequence ts = LexerUtils.getJoinedTokenSequence((Document)component.getDocument(), (int)offset, (Language)CssTokenId.language());
        if (ts != null) {
            int diff = ts.move(offset);
            TokenId currentTokenId = null;
            if (diff == 0 && ts.movePrevious() || ts.moveNext()) {
                currentTokenId = ts.token().id();
            }
            if (currentTokenId == CssTokenId.IDENT) {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
            if (typedText.length() == 1 && c == ' ' && currentTokenId != CssTokenId.COMMENT) {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        switch (c) {
            case '\n': 
            case ';': 
            case '}': {
                return CodeCompletionHandler.QueryType.STOP;
            }
            case '#': 
            case ',': 
            case '.': 
            case ':': {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private CodeCompletionResult handleLexicalBasedCompletion(FileObject file, TokenSequence<CssTokenId> ts, Snapshot snapshot, int caretOffset) {
        int tokenDiff = ts.move(snapshot.getEmbeddedOffset(caretOffset));
        if (ts.moveNext() || ts.movePrevious()) {
            boolean addSemicolon = true;
            switch ((CssTokenId)ts.token().id()) {
                case SEMI: {
                    addSemicolon = false;
                }
                case WS: 
                case NL: {
                    if (addSemicolon) {
                        Token semicolon = LexerUtils.followsToken(ts, (TokenId)CssTokenId.SEMI, (boolean)false, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL});
                        boolean bl = addSemicolon = semicolon == null;
                    }
                    if (null == LexerUtils.followsToken(ts, (TokenId)CssTokenId.IMPORT_SYM, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL})) break;
                    List<CompletionProposal> imports = this.completeImport(file, caretOffset, EMPTY_STRING, true, addSemicolon);
                    int moveBack = (addSemicolon ? 1 : 0) + 1;
                    return new CssFileCompletionResult(imports, moveBack);
                }
                case STRING: {
                    Token originalToken = ts.token();
                    addSemicolon = false;
                    if (null == LexerUtils.followsToken(ts, (TokenId)CssTokenId.IMPORT_SYM, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL})) break;
                    String valuePrefix = originalToken.text().toString().substring(1, tokenDiff);
                    List<CompletionProposal> imports = this.completeImport(file, caretOffset, valuePrefix, false, addSemicolon);
                    int moveBack = addSemicolon ? 1 : 0;
                    return new CssFileCompletionResult(imports, moveBack);
                }
                case URI: {
                    int lastSeparatorIndex;
                    String text = ts.token().text().toString();
                    Matcher m = Css3Utils.URI_PATTERN.matcher(text);
                    if (!m.matches()) break;
                    int groupIndex = 1;
                    String value = m.group(groupIndex);
                    int valueStart = m.start(groupIndex);
                    if (tokenDiff > 0) {
                        int cutIndex = tokenDiff - valueStart;
                        value = value.substring(0, cutIndex);
                    }
                    if (!(value.isEmpty() || value.charAt(0) != '\"' && value.charAt(0) != '\'')) {
                        value = value.substring(1);
                    }
                    if ((lastSeparatorIndex = value.lastIndexOf(Css3Utils.FILE_SEPARATOR)) != -1) {
                        String valuePrefix = value.substring(0, lastSeparatorIndex);
                        FileObject base = WebUtils.resolve((FileObject)file, (String)valuePrefix);
                        if (base == null) break;
                        String prefix = value.substring(lastSeparatorIndex + 1);
                        List<CompletionProposal> imports = this.completeImport(base, caretOffset, prefix, false, false);
                        return new CssFileCompletionResult(imports, 0);
                    }
                    List<CompletionProposal> imports = this.completeImport(file, caretOffset, value, false, false);
                    return new CssFileCompletionResult(imports, 0);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void completeClassSelectors(CompletionContext context, List<CompletionProposal> completionProposals, boolean unmappableClassOrId) {
        node = context.getActiveNode();
        file = context.getSnapshot().getSource().getFileObject();
        prefix = context.getPrefix();
        offset = context.getAnchorOffset();
        nodeType = node.type();
        block1 : switch (4.$SwitchMap$org$netbeans$modules$css$lib$api$NodeType[nodeType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (NodeUtil.getAncestorByType((Node)node, (NodeType)NodeType.rule) == null) break;
                try {
                    tokenSequence = context.getTokenSequence();
                    switch (4.$SwitchMap$org$netbeans$modules$css$lib$api$CssTokenId[((CssTokenId)tokenSequence.token().id()).ordinal()]) {
                        case 10: {
                            ** break;
lbl16:
                            // 1 sources

                            break block1;
                        }
                        case 11: {
                            if (tokenSequence.movePrevious() && tokenSequence.token().id() == CssTokenId.DOT) {
                                ** break;
lbl20:
                                // 1 sources

                                break block1;
                            }
                        }
                        default: {
                            return;
                        }
                    }
                }
                finally {
                    context.restoreTokenSequence();
                }
            }
            default: {
                return;
            }
        }
        allclasses = new HashSet<String>();
        refclasses = new HashSet<String>();
        if (prefix.length() == 1 && prefix.charAt(0) == '.') {
            prefix = "";
            ++offset;
        }
        if (file != null && (sup = CssProjectSupport.findFor(file)) != null) {
            index = sup.getIndex();
            deps = index.getDependencies(file);
            refered = deps.getAllReferedFiles();
            search = index.findClassesByPrefix(prefix);
            for (FileObject fo : search.keySet()) {
                allclasses.addAll(search.get(fo));
                if (!refered.contains(fo)) continue;
                refclasses.addAll(search.get(fo));
            }
        }
        if (CssCompletion.TEST_CLASSES != null) {
            allclasses.addAll(Arrays.asList(CssCompletion.TEST_CLASSES));
        }
        proposals = new ArrayList<CssCompletionItem>(refclasses.size());
        for (String clazz : allclasses) {
            proposals.add(CssCompletionItem.createSelectorCompletionItem(new CssElement(context.getFileObject(), clazz), clazz, offset, refclasses.contains(clazz)));
        }
        completionProposals.addAll(proposals);
    }

    private void completeIdSelectors(CompletionContext context, List<CompletionProposal> completionProposals, boolean unmappableClassOrId) {
        Node node = context.getActiveNode();
        FileObject file = context.getSnapshot().getSource().getFileObject();
        String prefix = context.getPrefix();
        int offset = context.getAnchorOffset();
        NodeType nodeType = node.type();
        if (prefix.length() > 0 && (node.type() == NodeType.cssId || (unmappableClassOrId || nodeType == NodeType.error) && prefix.charAt(0) == '#')) {
            CssProjectSupport sup;
            HashSet<String> allids = new HashSet<String>();
            HashSet<String> refids = new HashSet<String>();
            prefix = prefix.length() == 1 && prefix.charAt(0) == '#' ? EMPTY_STRING : prefix.substring(1);
            ++offset;
            if (file != null && (sup = CssProjectSupport.findFor(file)) != null) {
                CssIndex index = sup.getIndex();
                DependenciesGraph deps = index.getDependencies(file);
                Collection refered = deps.getAllReferedFiles();
                Map<FileObject, Collection<String>> search = index.findIdsByPrefix(prefix);
                for (FileObject fo : search.keySet()) {
                    allids.addAll(search.get(fo));
                    if (!refered.contains(fo)) continue;
                    refids.addAll(search.get(fo));
                }
            }
            if (TEST_IDS != null) {
                allids.addAll(Arrays.asList(TEST_IDS));
            }
            ArrayList<CssCompletionItem> proposals = new ArrayList<CssCompletionItem>(allids.size());
            for (String id : allids) {
                proposals.add(CssCompletionItem.createSelectorCompletionItem(new CssElement(context.getFileObject(), id), id, offset, refids.contains(id)));
            }
            completionProposals.addAll(proposals);
        }
    }

    private void completeAtRulesAndHtmlSelectors(CompletionContext context, List<CompletionProposal> completionProposals) {
        if (!context.getPrefix().trim().isEmpty()) {
            return;
        }
        Node node = context.getActiveNode();
        block6: while (true) {
            switch (node.type()) {
                case error: 
                case recovery: {
                    node = node.parent();
                    continue block6;
                }
            }
            break;
        }
        switch (node.type()) {
            case root: 
            case styleSheet: 
            case body: 
            case moz_document: 
            case imports: 
            case namespaces: {
                TokenSequence<CssTokenId> ts = context.getTokenSequence();
                if (ts.movePrevious() && ((CssTokenId)ts.token().id()).getTokenCategory() == CssTokenIdCategory.AT_RULE_SYMBOL) {
                    return;
                }
                ArrayList<CompletionProposal> all = new ArrayList<CompletionProposal>();
                all.addAll(Utilities.createRAWCompletionProposals(AT_RULES, ElementKind.FIELD, context.getAnchorOffset()));
                all.addAll(this.completeHtmlSelectors(context, context.getPrefix(), context.getAnchorOffset()));
                completionProposals.addAll(all);
            }
        }
    }

    private void completeHtmlSelectors(CompletionContext completionContext, List<CompletionProposal> completionProposals, TokenId tokenNodeTokenId) {
        String prefix = completionContext.getPrefix();
        int caretOffset = completionContext.getCaretOffset();
        Node node = completionContext.getActiveNode();
        block0 : switch (node.type()) {
            case media: {
                if (null == LexerUtils.followsToken(completionContext.getTokenSequence(), (TokenId)CssTokenId.LBRACE, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL})) break;
            }
            case mediaBody: {
                if (null == LexerUtils.followsToken(completionContext.getTokenSequence(), EnumSet.of(CssTokenId.SEMI, CssTokenId.LBRACE, CssTokenId.RBRACE), (boolean)true, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL})) break;
                completionProposals.addAll(this.completeHtmlSelectors(completionContext, completionContext.getPrefix(), completionContext.getCaretOffset()));
                break;
            }
            case elementName: {
                completionProposals.addAll(this.completeHtmlSelectors(completionContext, prefix, completionContext.getSnapshot().getOriginalOffset(completionContext.getActiveNode().from())));
                break;
            }
            case typeSelector: 
            case elementSubsequent: {
                completionProposals.addAll(this.completeHtmlSelectors(completionContext, prefix, caretOffset));
                break;
            }
            case rule: 
            case selector: 
            case selectorsGroup: 
            case simpleSelectorSequence: 
            case combinator: {
                TokenSequence<CssTokenId> tokenSequence;
                CssTokenId activeTokenId = completionContext.getActiveTokenId();
                if (activeTokenId != CssTokenId.WS && activeTokenId != CssTokenId.NL && activeTokenId.getTokenCategory() != CssTokenIdCategory.OPERATORS || null != LexerUtils.followsToken(tokenSequence = completionContext.getTokenSequence(), (TokenId)CssTokenId.LBRACE, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL})) break;
                completionProposals.addAll(this.completeHtmlSelectors(completionContext, prefix, caretOffset));
                break;
            }
            case declarations: {
                if (NodeUtil.getAncestorByType((Node)node, (NodeType)NodeType.cp_mixin_block) == null) break;
            }
            case cp_mixin_block: {
                completionProposals.addAll(this.completeHtmlSelectors(completionContext, prefix, caretOffset));
                break;
            }
            case error: {
                Node parentNode = completionContext.getActiveNode().parent();
                if (parentNode == null) break;
                switch (completionContext.getActiveTokenId()) {
                    case WS: {
                        switch (parentNode.type()) {
                            case bodyItem: 
                            case rule: 
                            case typeSelector: 
                            case selector: 
                            case selectorsGroup: 
                            case simpleSelectorSequence: {
                                completionProposals.addAll(this.completeHtmlSelectors(completionContext, prefix, caretOffset));
                            }
                        }
                        break block0;
                    }
                    case IDENT: {
                        switch (parentNode.type()) {
                            case declaration: {
                                if (NodeUtil.getAncestorByType((Node)parentNode, (NodeType)NodeType.cp_mixin_block) == null) break block0;
                                completionProposals.addAll(this.completeHtmlSelectors(completionContext, prefix, caretOffset));
                            }
                        }
                    }
                }
            }
        }
    }

    private void completeKeywords(CompletionContext completionContext, List<CompletionProposal> completionProposals, boolean tokenFound) {
        if (!tokenFound) {
            return;
        }
        Node node = completionContext.getActiveNode();
        block17: while (true) {
            switch (node.type()) {
                case error: 
                case recovery: {
                    node = node.parent();
                    continue block17;
                }
            }
            break;
        }
        switch (node.type()) {
            case imports: 
            case bodyItem: 
            case media: 
            case page: 
            case charSet: 
            case generic_at_rule: 
            case fontFace: {
                switch ((CssTokenId)completionContext.getTokenSequence().token().id()) {
                    case IMPORTANT_SYM: 
                    case MEDIA_SYM: 
                    case PAGE_SYM: 
                    case CHARSET_SYM: 
                    case AT_IDENT: 
                    case FONT_FACE_SYM: 
                    case ERROR: {
                        Collection<String> possibleValues = this.filterStrings(AT_RULES, completionContext.getPrefix());
                        completionProposals.addAll(Utilities.createRAWCompletionProposals(possibleValues, ElementKind.FIELD, completionContext.getSnapshot().getOriginalOffset(completionContext.getActiveNode().from())));
                    }
                }
                break;
            }
            case elementSubsequent: {
                Collection<String> possibleValues;
                switch ((CssTokenId)completionContext.getTokenSequence().token().id()) {
                    case AT_SIGN: {
                        possibleValues = this.filterStrings(AT_RULES, completionContext.getPrefix());
                        completionProposals.addAll(Utilities.createRAWCompletionProposals(possibleValues, ElementKind.FIELD, completionContext.getSnapshot().getOriginalOffset(completionContext.getActiveNode().from())));
                    }
                }
            }
            case styleSheet: {
                Collection<String> possibleValues;
                switch ((CssTokenId)completionContext.getTokenSequence().token().id()) {
                    case ERROR: {
                        possibleValues = this.filterStrings(AT_RULES, completionContext.getPrefix());
                        completionProposals.addAll(Utilities.createRAWCompletionProposals(possibleValues, ElementKind.FIELD, completionContext.getSnapshot().getOriginalOffset(completionContext.getActiveNode().from())));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completePropertyName(CompletionContext cc, List<CompletionProposal> completionProposals) {
        Collection<PropertyDefinition> possibleProps;
        Node node = cc.getActiveNode();
        NodeType nodeType = node.type();
        String prefix = cc.getPrefix();
        Collection defs = Properties.getPropertyDefinitions((FileObject)cc.getFileObject());
        if (nodeType == NodeType.property && (prefix.length() > 0 || cc.getEmbeddedCaretOffset() == cc.getActiveNode().from())) {
            possibleProps = this.filterProperties(defs, prefix);
            completionProposals.addAll(Utilities.wrapProperties(possibleProps, cc.getSnapshot().getOriginalOffset(cc.getActiveNode().from())));
        } else if (nodeType == NodeType.elementName && NodeUtil.getAncestorByType((Node)node, (NodeType)NodeType.cp_mixin_block) != null) {
            possibleProps = this.filterProperties(defs, prefix);
            completionProposals.addAll(Utilities.wrapProperties(possibleProps, cc.getSnapshot().getOriginalOffset(cc.getActiveNode().from())));
        }
        if (nodeType == NodeType.recovery || nodeType == NodeType.error) {
            Node parent = cc.getActiveNode().parent();
            if (parent != null && parent.type() == NodeType.error) {
                parent = parent.parent();
            }
            if (parent != null && (parent.type() == NodeType.property || parent.type() == NodeType.declarations || parent.type() == NodeType.declaration || parent.type() == NodeType.propertyDeclaration || parent.type() == NodeType.cp_mixin_block || parent.type() == NodeType.moz_document)) {
                CssTokenId nonWhiteTokenIdBackward = cc.getNonWhiteTokenIdBackward();
                if (nonWhiteTokenIdBackward != null) {
                    switch (nonWhiteTokenIdBackward) {
                        case COLON: 
                        case DCOLON: 
                        case SASS_INCLUDE: {
                            return;
                        }
                        case IDENT: {
                            TokenSequence<CssTokenId> ts = cc.getTokenSequence();
                            int index = ts.index();
                            try {
                                if (!ts.movePrevious()) break;
                                switch ((CssTokenId)ts.token().id()) {
                                    case COLON: 
                                    case DCOLON: {
                                        if (!ts.movePrevious()) break;
                                        switch ((CssTokenId)ts.token().id()) {
                                            case LESS_AND: {
                                                return;
                                            }
                                        }
                                        break;
                                    }
                                }
                                break;
                            }
                            finally {
                                ts.moveIndex(index);
                            }
                        }
                    }
                }
                boolean bug204821 = false;
                if (prefix.length() == 0 && cc.getActiveTokenId() == CssTokenId.MINUS) {
                    bug204821 = true;
                }
                if (bug204821) {
                    Collection<PropertyDefinition> possibleProps2 = this.filterProperties(Properties.getPropertyDefinitions((FileObject)cc.getFileObject()), "-");
                    completionProposals.addAll(Utilities.wrapProperties(possibleProps2, cc.getCaretOffset(), 1));
                } else {
                    Collection<PropertyDefinition> possibleProps3 = this.filterProperties(defs, prefix);
                    completionProposals.addAll(Utilities.wrapProperties(possibleProps3, cc.getAnchorOffset()));
                }
            }
        }
        switch (nodeType) {
            case declarations: {
                Node nodeBw = cc.getNodeForNonWhiteTokenBackward();
                if (NodeUtil.getAncestorByType((Node)nodeBw, (NodeType)NodeType.propertyDeclaration) != null) {
                    return;
                }
            }
            case moz_document: 
            case rule: 
            case cp_mixin_block: {
                completionProposals.addAll(Utilities.wrapProperties(defs, cc.getCaretOffset()));
                return;
            }
        }
    }

    private void completePropertyValue(CompletionContext context, List<CompletionProposal> completionProposals, char charAfterCaret) {
        Node node = context.getActiveNode();
        String prefix = context.getPrefix();
        NodeType nodeType = node.type();
        switch (nodeType) {
            case declarations: {
                Node declarationNode;
                Node propertyDeclaration;
                Node[] declarations;
                if (context.getActiveTokenId() == CssTokenId.SEMI || LexerUtils.followsToken(context.getTokenSequence(), (TokenId)CssTokenId.SEMI, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL}) != null || (declarations = NodeUtil.getChildrenByType((Node)node, (NodeType)NodeType.declaration)).length <= 0 || (propertyDeclaration = NodeUtil.getChildByType((Node)(declarationNode = declarations[declarations.length - 1]), (NodeType)NodeType.propertyDeclaration)) == null) break;
            }
            case declaration: 
            case propertyDeclaration: {
                PropertyDefinition prop;
                final Node[] result = new Node[3];
                NodeVisitor propertySearch = new NodeVisitor(){

                    public boolean visit(Node node) {
                        switch (node.type()) {
                            case property: {
                                result[0] = node;
                                break;
                            }
                            case propertyValue: 
                            case cp_propertyValue: {
                                result[1] = node;
                                break;
                            }
                            case error: {
                                result[2] = node;
                            }
                        }
                        return false;
                    }
                };
                propertySearch.visitChildren(node);
                Node property = result[0];
                if (property == null) {
                    return;
                }
                String expressionText = EMPTY_STRING;
                if (result[1] != null) {
                    expressionText = LexerUtils.followsToken(context.getTokenSequence(), EnumSet.of(CssTokenId.COLON), (boolean)true, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL}) != null ? EMPTY_STRING : result[1].image().toString();
                }
                if (result[2] != null) {
                    int eolIndex;
                    int semiIndex;
                    int colonIndex;
                    String propertyImage = node.image().toString().trim();
                    if (propertyImage.endsWith("}")) {
                        propertyImage = propertyImage.substring(0, propertyImage.length() - 1);
                    }
                    if ((colonIndex = propertyImage.indexOf(58)) >= 0) {
                        expressionText = propertyImage.substring(colonIndex + 1);
                    }
                    if ((semiIndex = expressionText.lastIndexOf(59)) > 0) {
                        expressionText = expressionText.substring(0, semiIndex);
                    }
                    if ((eolIndex = expressionText.indexOf(10)) > 0) {
                        expressionText = expressionText.substring(0, eolIndex);
                    }
                }
                if ((prop = Properties.getPropertyDefinition((String)property.image().toString().trim())) == null) break;
                ResolvedProperty propVal = new ResolvedProperty(context.getFileObject(), prop, (CharSequence)expressionText);
                Set alts = propVal.getAlternatives();
                Set filteredByPrefix = this.filterElements(alts, prefix);
                int completionItemInsertPosition = prefix.trim().length() == 0 ? context.getCaretOffset() : context.getSnapshot().getOriginalOffset(node.from());
                boolean addSpaceBeforeItem = false;
                if (alts.size() > 0 && filteredByPrefix.isEmpty() && Character.isWhitespace(charAfterCaret)) {
                    completionItemInsertPosition = context.getCaretOffset();
                    filteredByPrefix = alts;
                    addSpaceBeforeItem = true;
                }
                completionProposals.addAll(this.wrapPropertyValues(context, prefix, prop, filteredByPrefix, completionItemInsertPosition, false, addSpaceBeforeItem, false));
                break;
            }
            case recovery: {
                Node parent = node.parent();
                if (parent.type() != NodeType.error) break;
                node = parent;
            }
            case error: {
                Node parentNode = node.parent();
                NodeType parentType = parentNode.type();
                if (parentType != NodeType.propertyValue && parentType != NodeType.term && parentType != NodeType.expression && parentType != NodeType.operator && parentType != NodeType.propertyDeclaration && parentType != NodeType.declaration) break;
            }
            case propertyValue: 
            case hexColor: 
            case function: 
            case functionName: 
            case term: 
            case expression: 
            case operator: {
                Node siblingBefore;
                Node parentNode = node.parent();
                NodeType parentType = parentNode.type();
                Node declarationNode = null;
                if (parentType != null && parentType == NodeType.declaration && (siblingBefore = NodeUtil.getSibling((Node)parentNode, (boolean)true)) != null && siblingBefore.type() == NodeType.declaration) {
                    declarationNode = NodeUtil.getChildByType((Node)siblingBefore, (NodeType)NodeType.propertyDeclaration);
                }
                final Node[] result = new Node[1];
                if (declarationNode == null) {
                    NodeVisitor declarationSearch = new NodeVisitor(){

                        public boolean visit(Node node) {
                            if (node.type() == NodeType.propertyDeclaration) {
                                result[0] = node;
                            }
                            return false;
                        }
                    };
                    declarationSearch.visitAncestors(node);
                    declarationNode = result[0];
                }
                if (declarationNode == null) break;
                result[0] = null;
                NodeVisitor propertySearch = new NodeVisitor(){

                    public boolean visit(Node node) {
                        if (node.type() == NodeType.property) {
                            result[0] = node;
                        }
                        return false;
                    }
                };
                propertySearch.visitChildren(declarationNode);
                Node property = result[0];
                if (property == null) {
                    return;
                }
                String propertyName = property.image().toString();
                PropertyDefinition propertyDefinition = Properties.getPropertyDefinition((String)propertyName);
                if (propertyDefinition == null) {
                    return;
                }
                Node value = NodeUtil.query((Node)declarationNode, (String)NodeType.propertyValue.name());
                if (value == null && (value = NodeUtil.query((Node)declarationNode, (String)NodeType.cp_propertyValue.name())) == null) {
                    return;
                }
                String expressionText = context.getSnapshot().getText().subSequence(value.from(), context.getEmbeddedAnchorOffset()).toString();
                int eolIndex = expressionText.indexOf(10);
                if (eolIndex > 0) {
                    expressionText = expressionText.substring(0, eolIndex);
                }
                ResolvedProperty propVal = new ResolvedProperty(context.getFileObject(), propertyDefinition, (CharSequence)expressionText);
                Set alts = propVal.getAlternatives();
                Set filteredByPrefix = this.filterElements(alts, prefix);
                int completionItemInsertPosition = context.getAnchorOffset();
                boolean addSpaceBeforeItem = false;
                boolean includePrefixInTheExpression = false;
                boolean extendedItemsOnly = false;
                if (prefix.startsWith("#")) {
                    completionItemInsertPosition = context.getCaretOffset() - prefix.length();
                    filteredByPrefix = alts;
                    extendedItemsOnly = true;
                } else if (Character.isWhitespace(charAfterCaret)) {
                    if (!prefix.isEmpty() && filteredByPrefix.isEmpty()) {
                        includePrefixInTheExpression = true;
                    } else {
                        for (ValueGrammarElement vge : filteredByPrefix) {
                            if (!vge.getValue().toString().equals(prefix)) continue;
                            includePrefixInTheExpression = true;
                            break;
                        }
                    }
                }
                if (includePrefixInTheExpression) {
                    expressionText = context.getSnapshot().getText().subSequence(value.from(), context.getEmbeddedCaretOffset()).toString();
                    eolIndex = expressionText.indexOf(10);
                    if (eolIndex > 0) {
                        expressionText = expressionText.substring(0, eolIndex);
                    }
                    propVal = new ResolvedProperty(context.getFileObject(), propertyDefinition, (CharSequence)expressionText);
                    filteredByPrefix = alts = propVal.getAlternatives();
                    completionItemInsertPosition = context.getCaretOffset();
                    addSpaceBeforeItem = true;
                }
                completionProposals.addAll(this.wrapPropertyValues(context, prefix, propertyDefinition, filteredByPrefix, completionItemInsertPosition, false, addSpaceBeforeItem, extendedItemsOnly));
            }
        }
    }

    static {
        HIDDEN_UNITS = new HashSet<String>(Arrays.asList("!hash_color_code"));
    }

    private static class CssFileCompletionResult
    extends DefaultCompletionResult {
        private int moveCaretBack;

        public CssFileCompletionResult(List<CompletionProposal> list, int moveCaretBack) {
            super(list, false);
            this.moveCaretBack = moveCaretBack;
        }

        public void afterInsert(CompletionProposal item) {
            Caret c = EditorRegistry.lastFocusedComponent().getCaret();
            if (this.moveCaretBack > 0) {
                c.setDot(c.getDot() - this.moveCaretBack);
            }
        }
    }

    private static class CssLinkCompletion
    extends FileReferenceCompletion<CssCompletionItem> {
        private static final String GO_UP_TEXT = "../";
        private final boolean addQuotes;
        private final boolean addSemicolon;
        private final FileObject file;

        public CssLinkCompletion(FileObject file, boolean addQuotes, boolean addSemicolon) {
            this.file = file;
            this.addQuotes = addQuotes;
            this.addSemicolon = addSemicolon;
        }

        public CssCompletionItem createFileItem(FileObject file, int anchor) {
            String name = file.getNameExt();
            Color color = file.isFolder() ? Color.BLUE : null;
            ImageIcon icon = FileReferenceCompletion.getIcon((FileObject)file);
            return CssCompletionItem.createFileCompletionItem(new CssElement(file, name), name, anchor, color, icon, this.addQuotes, this.addSemicolon);
        }

        public CssCompletionItem createGoUpItem(int anchor, Color color, ImageIcon icon) {
            return CssCompletionItem.createFileCompletionItem(new CssElement(this.file, GO_UP_TEXT), GO_UP_TEXT, anchor, color, icon, this.addQuotes, this.addSemicolon);
        }
    }
}

