/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.ide;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.team.ide.spi.IDEProject;
import org.netbeans.modules.team.ide.spi.ProjectServices;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ProjectServicesImpl
implements ProjectServices {
    private static ProjectOpenListener projectOpenListener;
    private static List<Reference<IDEProject.OpenListener>> ideProjectOpenListeners;

    public FileObject[] getOpenProjectsDirectories() {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        FileObject[] directories = new FileObject[openProjects.length];
        for (int i = 0; i < openProjects.length; ++i) {
            Project project = openProjects[i];
            directories[i] = project.getProjectDirectory();
        }
        return directories;
    }

    public FileObject getMainProjectDirectory() {
        Project p = OpenProjects.getDefault().getMainProject();
        return p != null ? p.getProjectDirectory() : null;
    }

    public FileObject getFileOwnerDirectory(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return project != null ? project.getProjectDirectory() : null;
    }

    public FileObject[] getCurrentSelection() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes == null) {
            return null;
        }
        ArrayList<FileObject> ret = new ArrayList<FileObject>();
        for (Node node : nodes) {
            FileObject fileObj;
            Lookup nodeLookup = node.getLookup();
            Collection projects = nodeLookup.lookupAll(Project.class);
            if (projects != null && !projects.isEmpty()) {
                for (Project project : projects) {
                    ret.add(project.getProjectDirectory());
                }
                continue;
            }
            DataObject dataObj = (DataObject)nodeLookup.lookup(DataObject.class);
            if (dataObj == null || (fileObj = dataObj.getPrimaryFile()) == null) continue;
            ret.add(fileObj);
        }
        return ret.toArray(new FileObject[ret.size()]);
    }

    public FileObject[] getProjectDirectories(Lookup lookup) {
        Collection projects = lookup.lookupAll(Project.class);
        if (projects == null) {
            return null;
        }
        ArrayList<FileObject> ret = new ArrayList<FileObject>();
        for (Project project : projects) {
            ret.add(project.getProjectDirectory());
        }
        return ret.toArray(new FileObject[ret.size()]);
    }

    public <T> T runAfterProjectOpenFinished(Callable<T> operation) throws Exception {
        OpenProjects.getDefault().openProjects().get();
        return operation.call();
    }

    public boolean openProject(URL url) {
        Project p = ProjectServicesImpl.getProject(url);
        if (p == null) {
            return false;
        }
        OpenProjects.getDefault().open(new Project[]{p}, false);
        TopComponent projectsTC = WindowManager.getDefault().findTopComponent("projectTabLogical_tc");
        projectsTC.requestActive();
        ExplorerManager em = ((ExplorerManager.Provider)projectsTC).getExplorerManager();
        Node root = em.getRootContext();
        Node projNode = null;
        for (Node n : root.getChildren().getNodes()) {
            Project prj = (Project)n.getLookup().lookup(Project.class);
            if (prj == null || !prj.getProjectDirectory().equals(p.getProjectDirectory())) continue;
            projNode = n;
            break;
        }
        if (projNode == null) {
            projNode = root.getChildren().findChild(ProjectUtils.getInformation((Project)p).getName());
        }
        if (projNode != null) {
            try {
                em.setSelectedNodes(new Node[]{projNode});
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return true;
    }

    public void openOtherProject(File workingDir) {
        this.chooseAndOpenProjects(workingDir, true);
    }

    public File[] chooseProjects(File workingDir) {
        return this.chooseAndOpenProjects(workingDir, false);
    }

    private File[] chooseAndOpenProjects(File workingDir, boolean open) {
        File[] projectDirs;
        if (workingDir != null) {
            ProjectChooser.setProjectsFolder((File)workingDir);
        }
        JFileChooser chooser = ProjectChooser.projectChooser();
        if (workingDir != null) {
            chooser.setCurrentDirectory(workingDir);
        }
        chooser.setMultiSelectionEnabled(true);
        int option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (option == 0) {
            projectDirs = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
            if (open) {
                ArrayList<Project> projects = new ArrayList<Project>(projectDirs.length);
                for (File d : projectDirs) {
                    try {
                        Project p = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)d));
                        if (p == null) continue;
                        projects.add(p);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (!projects.isEmpty()) {
                    OpenProjects.getDefault().open(projects.toArray(new Project[projects.size()]), false);
                }
                WindowManager.getDefault().findTopComponent("projectTabLogical_tc").requestActive();
            }
        } else {
            projectDirs = new File[]{};
        }
        return projectDirs;
    }

    public void reopenProjectsFromNewLocation(File[] oldLocations, File[] newLocations) {
        Project prj;
        int i;
        ArrayList<Project> projectsToClose = new ArrayList<Project>();
        ArrayList<Project> projectsToOpen = new ArrayList<Project>();
        ProjectManager.getDefault().clearNonProjectCache();
        for (i = 0; i < oldLocations.length; ++i) {
            prj = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)oldLocations[i]));
            if (prj == null) continue;
            projectsToClose.add(prj);
        }
        for (i = 0; i < newLocations.length; ++i) {
            prj = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)newLocations[i]));
            if (prj == null) continue;
            projectsToOpen.add(prj);
        }
        projectsToClose.remove(null);
        projectsToOpen.remove(null);
        OpenProjects.getDefault().close(projectsToClose.toArray(new Project[projectsToClose.size()]));
        OpenProjects.getDefault().open(projectsToOpen.toArray(new Project[projectsToOpen.size()]), false);
    }

    public void createNewProject(File workingDir) {
        Action newProjectAction = CommonProjectActions.newProjectAction();
        if (newProjectAction != null) {
            ProjectChooser.setProjectsFolder((File)workingDir);
            newProjectAction.actionPerformed(new ActionEvent(this, 1001, "command"));
        }
    }

    public IDEProject getIDEProject(URL url) {
        Project p = ProjectServicesImpl.getProject(url);
        return p != null ? ProjectServicesImpl.createIDEProject(p) : null;
    }

    public IDEProject[] getOpenProjects() {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        IDEProject[] ideProjects = new IDEProject[openProjects.length];
        for (int i = 0; i < openProjects.length; ++i) {
            ideProjects[i] = ProjectServicesImpl.createIDEProject(openProjects[i]);
        }
        return ideProjects;
    }

    private static Project getProject(URL url) {
        try {
            return FileOwnerQuery.getOwner((URI)url.toURI());
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static IDEProject createIDEProject(Project p) {
        ProjectInformation pi = ProjectUtils.getInformation((Project)p);
        return new NbProject(pi.getDisplayName(), pi.getIcon(), p.getProjectDirectory().toURL());
    }

    public synchronized void addProjectOpenListener(IDEProject.OpenListener listener) {
        if (ideProjectOpenListeners == null) {
            ideProjectOpenListeners = new LinkedList<Reference<IDEProject.OpenListener>>();
        } else {
            Iterator<Reference<IDEProject.OpenListener>> it = ideProjectOpenListeners.iterator();
            while (it.hasNext()) {
                Reference<IDEProject.OpenListener> r = it.next();
                IDEProject.OpenListener l = r.get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
        ideProjectOpenListeners.add(new WeakReference<IDEProject.OpenListener>(listener));
        if (projectOpenListener == null) {
            projectOpenListener = new ProjectOpenListener();
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)projectOpenListener);
        }
    }

    public synchronized void removeProjectOpenListener(IDEProject.OpenListener listener) {
        if (ideProjectOpenListeners != null) {
            Iterator<Reference<IDEProject.OpenListener>> it = ideProjectOpenListeners.iterator();
            while (it.hasNext()) {
                Reference<IDEProject.OpenListener> r = it.next();
                IDEProject.OpenListener l = r.get();
                if (l != null && l != listener) continue;
                it.remove();
            }
            if (ideProjectOpenListeners.isEmpty()) {
                ideProjectOpenListeners = null;
                if (projectOpenListener != null) {
                    OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)projectOpenListener);
                    projectOpenListener = null;
                }
            }
        }
    }

    private static synchronized IDEProject.OpenListener[] getIDEProjectOpenListeners() {
        if (ideProjectOpenListeners == null) {
            return null;
        }
        ArrayList<IDEProject.OpenListener> listenerList = new ArrayList<IDEProject.OpenListener>(ideProjectOpenListeners.size());
        Iterator<Reference<IDEProject.OpenListener>> it = ideProjectOpenListeners.iterator();
        while (it.hasNext()) {
            Reference<IDEProject.OpenListener> r = it.next();
            IDEProject.OpenListener l = r.get();
            if (l == null) {
                it.remove();
                continue;
            }
            listenerList.add(l);
        }
        if (ideProjectOpenListeners.isEmpty()) {
            ideProjectOpenListeners = null;
            if (projectOpenListener != null) {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)projectOpenListener);
                projectOpenListener = null;
            }
            return null;
        }
        return listenerList.toArray(new IDEProject.OpenListener[listenerList.size()]);
    }

    private static class NbProject
    extends IDEProject {
        private ProjectDeleteListener projectDeleteListener;

        NbProject(String displayName, Icon icon, URL url) {
            super(displayName, icon, url);
        }

        public synchronized boolean addDeleteListener(IDEProject.DeleteListener l) {
            boolean added = super.addDeleteListener(l);
            if (added && this.projectDeleteListener == null) {
                Project p = ProjectServicesImpl.getProject(this.getURL());
                if (p != null) {
                    FileObject projDir = p.getProjectDirectory();
                    this.projectDeleteListener = new ProjectDeleteListener(projDir.toURL(), this);
                    projDir.addFileChangeListener((FileChangeListener)this.projectDeleteListener);
                } else {
                    super.removeDeleteListener(l);
                    added = false;
                }
            }
            return added;
        }

        public synchronized boolean removeDeleteListener(IDEProject.DeleteListener l) {
            Project p;
            boolean removed = super.removeDeleteListener(l);
            if (removed && this.getDeleteListeners().isEmpty() && this.projectDeleteListener != null && (p = ProjectServicesImpl.getProject(this.getURL())) != null) {
                FileObject projDir = p.getProjectDirectory();
                projDir.removeFileChangeListener((FileChangeListener)this.projectDeleteListener);
                this.projectDeleteListener = null;
            }
            return removed;
        }
    }

    private static class ProjectDeleteListener
    extends FileChangeAdapter {
        private URL url;
        private Reference<NbProject> projectRef;

        ProjectDeleteListener(URL url, NbProject ideProject) {
            this.url = url;
            this.projectRef = new WeakReference<NbProject>(ideProject);
        }

        public void fileDeleted(FileEvent fe) {
            if (fe.getFile().toURL().equals(this.url)) {
                NbProject project = this.projectRef.get();
                if (project != null) {
                    project.notifyDeleted();
                } else {
                    fe.getFile().removeFileChangeListener((FileChangeListener)this);
                }
            }
        }
    }

    private static class ProjectOpenListener
    implements PropertyChangeListener {
        private ProjectOpenListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List<Project> openedList;
            if (!"openProjects".equals(evt.getPropertyName()) || evt.getNewValue() == null) {
                return;
            }
            IDEProject.OpenListener[] listeners = ProjectServicesImpl.getIDEProjectOpenListeners();
            if (listeners == null) {
                return;
            }
            Project[] newProjects = (Project[])evt.getNewValue();
            Project[] oldProjects = (Project[])evt.getOldValue();
            if (oldProjects == null) {
                openedList = Arrays.asList(newProjects);
            } else {
                openedList = new ArrayList<Project>();
                openedList.addAll(Arrays.asList(newProjects));
                openedList.removeAll(Arrays.asList(oldProjects));
            }
            if (!openedList.isEmpty()) {
                IDEProject[] newlyOpened = new IDEProject[openedList.size()];
                for (int i = 0; i < newlyOpened.length; ++i) {
                    newlyOpened[i] = ProjectServicesImpl.createIDEProject(openedList.get(i));
                }
                for (IDEProject.OpenListener l : listeners) {
                    l.projectsOpened(newlyOpened);
                }
            }
        }
    }
}

