/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.ide;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.icon.PainterIcon;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.Painter;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.diff.PatchUtils;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.jumpto.type.TypeBrowser;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.favorites.api.Favorites;
import org.netbeans.modules.team.ide.Bundle;
import org.netbeans.modules.team.ide.JXDatePickerImpl;
import org.netbeans.modules.team.ide.PatchContextChooser;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.netbeans.modules.versioning.util.SearchHistorySupport;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class IDEServicesImpl
implements IDEServices {
    private static final Logger LOG = Logger.getLogger(IDEServicesImpl.class.getName());
    private final RequestProcessor RP = new RequestProcessor("Netbeans IDE Services for Team");

    public boolean providesOpenDocument() {
        return true;
    }

    public void openDocument(final String path, final int offset) {
        final FileObject fo = this.findFile(path);
        if (fo != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        DataObject od = DataObject.find((FileObject)fo);
                        boolean ret = NbDocument.openDocument((Lookup.Provider)od, (int)offset, (int)-1, (Line.ShowOpenType)Line.ShowOpenType.OPEN, (Line.ShowVisibilityType)Line.ShowVisibilityType.FOCUS);
                        if (!ret) {
                            IDEServicesImpl.notifyError(Bundle.LBL_OpenDocument(), Bundle.MSG_CannotOpen(path));
                        }
                    }
                    catch (DataObjectNotFoundException e) {
                        LOG.log(Level.SEVERE, null, e);
                    }
                }
            });
        } else {
            IDEServicesImpl.notifyError(Bundle.LBL_OpenDocument(), Bundle.MSG_CannotFind(path));
        }
    }

    public boolean providesJumpTo() {
        return true;
    }

    public void jumpTo(String resourcePath, String title) {
        TypeDescriptor td = TypeBrowser.browse((String)title, (String)resourcePath, null, (TypeProvider[])new TypeProvider[0]);
        if (td != null) {
            td.open();
        }
    }

    public boolean providesPluginUpdate() {
        return true;
    }

    public IDEServices.Plugin getPluginUpdates(String cnb, final String pluginName) {
        List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        for (UpdateUnit u : units) {
            boolean isInstalled;
            if (!u.getCodeName().equals(cnb)) continue;
            List elements = u.getAvailableUpdates();
            boolean bl = isInstalled = u.getInstalled() != null;
            if (elements != null) {
                Iterator i$ = elements.iterator();
                if (!i$.hasNext()) continue;
                final UpdateElement updateElement = (UpdateElement)i$.next();
                return new IDEServices.Plugin(){

                    public String getDescription() {
                        return updateElement.getDescription();
                    }

                    public boolean installOrUpdate() {
                        OperationContainer oc;
                        OperationContainer operationContainer = oc = isInstalled ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
                        if (oc.canBeAdded(updateElement.getUpdateUnit(), updateElement)) {
                            oc.add(updateElement);
                            return PluginManager.openInstallWizard((OperationContainer)oc);
                        }
                        IDEServicesImpl.notifyError(Bundle.LBL_Error(), Bundle.MSG_CannotBeInstalled(pluginName));
                        return false;
                    }
                };
            }
            return null;
        }
        return null;
    }

    private static void notifyError(String title, String message) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(nd);
    }

    public boolean providesPatchUtils() {
        return true;
    }

    public void applyPatch(File patchFile) {
        File context = this.selectPatchContext();
        if (context != null) {
            try {
                PatchUtils.applyPatch((File)patchFile, (File)context);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, ex.getMessage(), ex);
            }
        }
    }

    public boolean isPatch(File patchFile) throws IOException {
        return PatchUtils.isPatch((File)patchFile);
    }

    private File selectPatchContext() {
        PatchContextChooser chooser = new PatchContextChooser();
        ResourceBundle bundle = NbBundle.getBundle(IDEServicesImpl.class);
        JButton ok = new JButton(bundle.getString("LBL_Apply"));
        JButton cancel = new JButton(bundle.getString("LBL_Cancel"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)chooser, bundle.getString("LBL_ApplyPatch"), true, 2, (Object)ok, null);
        descriptor.setOptions(new Object[]{ok, cancel});
        descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.bugtracking.patchContextChooser"));
        File context = null;
        DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
        if (descriptor.getValue() == ok) {
            context = chooser.getSelectedFile();
        }
        return context;
    }

    public boolean providesOpenHistory() {
        return true;
    }

    public boolean openHistory(String resourcePath, int line) {
        File file;
        FileObject fo = this.findFile(resourcePath);
        File file2 = file = fo != null ? FileUtil.toFile((FileObject)fo) : null;
        if (file == null) {
            LOG.log(Level.INFO, "No file available for path {0}", resourcePath);
            return false;
        }
        try {
            SearchHistorySupport support = SearchHistorySupport.getInstance((File)file);
            if (support != null) {
                return support.searchHistory(line);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private FileObject findFile(String resourcePath) {
        return GlobalPathRegistry.getDefault().findResource(resourcePath);
    }

    public IDEServices.BusyIcon createBusyIcon() {
        return new SwingXBusyIcon();
    }

    public boolean canOpenInFavorites() {
        return true;
    }

    public void openInFavorites(File workingDir) {
        WindowManager.getDefault().findTopComponent("favorites").requestActive();
        try {
            FileObject fo = FileUtil.toFileObject((File)workingDir);
            Favorites.getDefault().selectWithAddition(fo);
        }
        catch (IOException ex) {
            Logger.getLogger(IDEServicesImpl.class.getName()).log(Level.FINE, ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(IDEServicesImpl.class.getName()).log(Level.FINE, ex.getMessage(), ex);
        }
        catch (NullPointerException ex) {
            Logger.getLogger(IDEServicesImpl.class.getName()).log(Level.FINE, ex.getMessage(), ex);
        }
    }

    public IDEServices.DatePickerComponent createDatePicker() {
        return new JXDatePickerImpl();
    }

    public boolean isPluginInstalled(String cnb) {
        List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        for (UpdateUnit u : units) {
            if (!u.getCodeName().equals(cnb) || u.getInstalled() == null) continue;
            return true;
        }
        return false;
    }

    public boolean providesShutdown(boolean restart) {
        return true;
    }

    public void shutdown(boolean restart) {
        if (restart) {
            LifecycleManager.getDefault().markForRestart();
        }
        LifecycleManager.getDefault().exit();
    }

    private static class SwingXBusyIcon
    extends PainterIcon
    implements IDEServices.BusyIcon {
        private static final int SIZE = 16;
        private static final int POINTS = 8;
        private int currentFrame;
        private BusyPainter busyPainter = new BusyPainter(16);

        SwingXBusyIcon() {
            super(new Dimension(16, 16));
            this.busyPainter.setPoints(8);
            this.setPainter((Painter)this.busyPainter);
        }

        public void tick() {
            this.currentFrame = (this.currentFrame + 1) % 8;
            this.busyPainter.setFrame(this.currentFrame);
        }
    }
}

