/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.spi.RepositoryController;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.team.TeamRepositoryPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RepositoryFormPanel
extends JPanel {
    private Collection<String> cardNames = new ArrayList<String>(6);
    private RepositoryImpl selectedRepository = null;
    private RepositoryController selectedFormController = null;
    private boolean isValidData = false;
    private JComponent cardsPanel;
    private JLabel errorLabel;
    private final FormDataListener formDataListener = new FormDataListener();
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(4);
    private final ChangeEvent changeEvent = new ChangeEvent(this);
    private JPanel emptyPanel;
    private static final Color ERROR_COLOR;

    public RepositoryFormPanel() {
        this.initComponents();
    }

    public RepositoryFormPanel(RepositoryImpl repository, String initialErrorMessage) {
        this();
        this.displayForm(repository, initialErrorMessage);
    }

    private void initComponents() {
        this.cardsPanel = new JPanel(new CardLayout());
        this.errorLabel = new JLabel();
        this.errorLabel.setForeground(ERROR_COLOR);
        this.errorLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/error.gif")));
        this.updateErrorMessage(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.cardsPanel).addComponent(this.errorLabel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.cardsPanel).addGap(6, 14, 14).addComponent(this.errorLabel));
        layout.setHonorsVisibility(false);
    }

    public boolean displayForm(RepositoryImpl repository, String initialErrMsg) {
        if (repository == this.selectedRepository) {
            return false;
        }
        boolean wasValid = this.isValidData;
        boolean firstTimeUse = this.displayFormPanel(repository, initialErrMsg);
        if (this.isValidData != wasValid) {
            this.fireValidityChanged();
        }
        return firstTimeUse;
    }

    void displayErrorMessage(String message) {
        this.updateErrorMessage(message);
    }

    public RepositoryImpl getSelectedRepository() {
        return this.selectedRepository;
    }

    private void checkDataValidity() {
        assert (this.selectedFormController != null);
        boolean valid = this.selectedFormController.isValid();
        this.updateErrorMessage(this.selectedFormController.getErrorMessage());
        this.setDataValid(valid);
    }

    private void setDataValid(boolean valid) {
        if (valid != this.isValidData) {
            this.isValidData = valid;
            this.fireValidityChanged();
        }
    }

    private void updateErrorMessage(String errorMessage) {
        final String msg = errorMessage != null ? errorMessage.trim() : null;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (msg != null && msg.length() != 0) {
                    RepositoryFormPanel.this.errorLabel.setText(msg);
                    RepositoryFormPanel.this.errorLabel.setVisible(true);
                } else {
                    RepositoryFormPanel.this.errorLabel.setVisible(false);
                    RepositoryFormPanel.this.errorLabel.setText(" ");
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private boolean displayFormPanel(RepositoryImpl repositoryImpl, String initialErrMsg) {
        if (repositoryImpl == this.selectedRepository) {
            return false;
        }
        this.stopListeningOnController();
        if (repositoryImpl != null) {
            String cardName = RepositoryFormPanel.getCardName(repositoryImpl);
            RepositoryController controller = repositoryImpl.getController();
            boolean firstTimeUse = this.registerCard(cardName);
            if (firstTimeUse) {
                RepositoryInfo info = repositoryImpl.getInfo();
                JComponent cmp = info != null && repositoryImpl.isTeamRepository() ? new TeamRepositoryPanel(info) : controller.getComponent();
                this.cardsPanel.add((Component)cmp, cardName);
            }
            ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, cardName);
            this.selectedFormController = controller;
            this.selectedRepository = repositoryImpl;
            this.startListeningOnController();
            this.selectedFormController.populate();
            if (initialErrMsg != null && initialErrMsg.trim().length() != 0) {
                this.updateErrorMessage(initialErrMsg);
                this.setDataValid(false);
            } else {
                this.checkDataValidity();
            }
            return firstTimeUse;
        }
        String cardName = RepositoryFormPanel.getCardName(repositoryImpl);
        if (this.emptyPanel == null) {
            this.emptyPanel = new JPanel();
        }
        this.cardsPanel.add((Component)this.emptyPanel, cardName);
        ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, cardName);
        this.selectedFormController = null;
        this.selectedRepository = null;
        this.updateErrorMessage(NbBundle.getMessage(RepositoryFormPanel.class, (String)"LBL_CouldNotCreateRepository"));
        this.setDataValid(false);
        return true;
    }

    private void startListeningOnController() {
        this.selectedFormController.addChangeListener(this.formDataListener);
    }

    private void stopListeningOnController() {
        if (this.selectedFormController != null) {
            assert (this.formDataListener != null);
            this.selectedFormController.removeChangeListener(this.formDataListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopListeningOnController();
    }

    private static String getCardName(RepositoryImpl repository) {
        return Integer.toString(System.identityHashCode(repository), 36);
    }

    private boolean registerCard(String cardName) {
        if (!this.cardNames.contains(cardName)) {
            this.cardNames.add(cardName);
            return true;
        }
        return false;
    }

    public boolean isValidData() {
        return this.isValidData;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireValidityChanged() {
        if (!this.listeners.isEmpty()) {
            for (ChangeListener l : this.listeners) {
                l.stateChanged(this.changeEvent);
            }
        }
    }

    static {
        Color c = UIManager.getColor("nb.errorForeground");
        if (c == null) {
            c = new Color(153, 0, 0);
        }
        ERROR_COLOR = c;
    }

    class FormDataListener
    implements ChangeListener {
        FormDataListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RepositoryFormPanel.this.checkDataValidity();
        }
    }
}

