/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class IssueAction
extends SystemAction {
    private static final RequestProcessor rp = new RequestProcessor("Bugtracking IssueAction");

    public IssueAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(IssueAction.class, (String)"CTL_IssueAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IssueAction.class);
    }

    public void actionPerformed(ActionEvent ev) {
        IssueAction.createIssue();
    }

    public static void openIssue(final IssueImpl issue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIUtils.setWaitCursor((boolean)true);
                IssueTopComponent tc = IssueTopComponent.find(issue);
                tc.open();
                tc.requestActive();
                issue.setSeen(true);
                UIUtils.setWaitCursor((boolean)false);
            }
        });
    }

    private static void createIssue() {
        IssueAction.createIssue(null);
    }

    public static void createIssue(final RepositoryImpl repository) {
        BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                final File file = BugtrackingUtil.getLargerSelection();
                final boolean repositoryGiven = repository != null;
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        UIUtils.setWaitCursor((boolean)true);
                        try {
                            IssueTopComponent tc = new IssueTopComponent();
                            tc.initNewIssue(repository, !repositoryGiven, file);
                            tc.open();
                            tc.requestActive();
                        }
                        finally {
                            UIUtils.setWaitCursor((boolean)false);
                        }
                    }
                });
            }
        });
    }

    public static void openIssue(FileObject file, String issueId) {
        IssueAction.openIssueIntern(null, file, issueId);
    }

    public static void openIssue(RepositoryImpl repository, String issueId) {
        IssueAction.openIssueIntern(repository, null, issueId);
    }

    private static void openIssueIntern(final RepositoryImpl repositoryParam, final FileObject file, final String issueId) {
        assert (issueId != null);
        assert (file == null || repositoryParam == null && file != null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIUtils.setWaitCursor((boolean)true);
                final IssueTopComponent tc = IssueTopComponent.find(issueId);
                final boolean tcOpened = tc.isOpened();
                final IssueImpl issue = tc.getIssue();
                if (issue == null) {
                    tc.initNoIssue(issueId);
                }
                if (!tcOpened) {
                    tc.open();
                }
                tc.requestActive();
                rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle handle = null;
                        try {
                            if (issue != null) {
                                handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(IssueAction.class, (String)"LBL_REFRESING_ISSUE", (Object[])new Object[]{issueId}));
                                handle.start();
                                issue.refresh();
                            } else {
                                RepositoryImpl repository;
                                handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(IssueAction.class, (String)"LBL_OPENING_ISSUE", (Object[])new Object[]{issueId}));
                                handle.start();
                                if (repositoryParam == null) {
                                    repository = BugtrackingOwnerSupport.getInstance().getRepository(file, true);
                                    if (repository == null) {
                                        this.handleTC();
                                        return;
                                    }
                                    BugtrackingOwnerSupport.getInstance().setFirmAssociation(file, repository);
                                } else {
                                    repository = repositoryParam;
                                }
                                Collection<IssueImpl> impls = repository.getIssueImpls(issueId);
                                if (impls == null || impls.isEmpty()) {
                                    this.handleTC();
                                    return;
                                }
                                final IssueImpl impl = impls.iterator().next();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        tc.setIssue(impl);
                                    }
                                });
                                impl.setSeen(true);
                            }
                        }
                        finally {
                            if (handle != null) {
                                handle.finish();
                            }
                            UIUtils.setWaitCursor((boolean)false);
                        }
                    }

                    public void handleTC() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!tcOpened) {
                                    tc.close();
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public static void closeIssue(final IssueImpl issue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssueTopComponent tc = IssueTopComponent.find(issue);
                if (tc != null) {
                    tc.close();
                }
            }
        });
    }
}

