/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.dashboard;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.settings.DashboardSettings;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.tasks.TaskSorter;
import org.netbeans.modules.bugtracking.tasks.dashboard.CategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.Refreshable;
import org.netbeans.modules.bugtracking.tasks.dashboard.ShowNextNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.bugtracking.tasks.filter.AppliedFilters;
import org.netbeans.modules.team.commons.treelist.AsynchronousNode;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class TaskContainerNode
extends AsynchronousNode<List<IssueImpl>>
implements Refreshable {
    private List<TaskNode> taskNodes = new ArrayList<TaskNode>();
    private List<TaskNode> filteredTaskNodes = new ArrayList<TaskNode>();
    private TaskListener taskListener;
    private boolean refresh;
    private final Object LOCK = new Object();
    private Collection<TaskNode> toSelect;
    protected List<TreeLabel> labels;
    protected List<LinkButton> buttons;
    private int pageSize;
    private int pageCountShown;
    private boolean error;
    private RequestProcessor rp = new RequestProcessor("Tasks Dashboard - TaskContainerNode", 10);
    private final RequestProcessor.Task refilterNodes = this.rp.create(new Runnable(){

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskContainerNode.this.refilterTaskNodes();
                    TaskContainerNode.this.updateCounts();
                    TaskContainerNode.this.fireContentChanged();
                }
            });
        }
    });
    private final RequestProcessor.Task updateContent = this.rp.create(new Runnable(){

        @Override
        public void run() {
            TaskContainerNode.this.updateContent();
        }
    });

    public TaskContainerNode(boolean refresh, boolean expandable, TreeListNode parent, String title, Icon icon) {
        super(expandable, parent, title, icon);
        this.refresh = refresh;
        this.labels = new ArrayList<TreeLabel>();
        this.buttons = new ArrayList<LinkButton>();
        this.initPaging();
    }

    public abstract List<IssueImpl> getTasks(boolean var1);

    abstract void updateCounts();

    abstract boolean isTaskLimited();

    abstract void refreshTaskContainer();

    abstract Icon getIcon();

    void adjustTaskNode(TaskNode taskNode) {
    }

    Comparator<TaskNode> getSpecialComparator() {
        return null;
    }

    protected List<IssueImpl> load() {
        if (this.refresh) {
            this.refreshTaskContainer();
            this.refresh = false;
        }
        return this.getTasks(false);
    }

    protected void childrenLoadingFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TaskContainerNode.this.toSelect != null) {
                    DashboardViewer.getInstance().select(TaskContainerNode.this.toSelect);
                    TaskContainerNode.this.toSelect = null;
                }
            }
        });
    }

    protected void configure(JComponent component, Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowWidth) {
        for (JLabel jLabel : this.labels) {
            jLabel.setForeground(foreground);
        }
        for (LinkButton linkButton : this.buttons) {
            linkButton.setForeground(foreground, isSelected);
        }
    }

    protected void attach() {
        super.attach();
        this.addTaskListeners();
    }

    protected void dispose() {
        super.dispose();
        this.removeTaskListeners();
    }

    void updateContent() {
        this.updateContentAndSelect(null);
    }

    void updateContentAndSelect(Collection<TaskNode> toSelect) {
        this.toSelect = toSelect;
        List emptyList = Collections.emptyList();
        boolean childrenLoaded = this.getChildren() == emptyList;
        boolean expand = toSelect != null && !toSelect.isEmpty() && !this.isExpanded();
        this.updateNodes();
        this.updateCounts();
        this.fireContentChanged();
        if (expand) {
            this.setExpanded(true);
        }
        if (!childrenLoaded || !expand) {
            this.refreshChildren();
        }
    }

    @Override
    public final void refreshContent() {
        this.refresh = true;
        this.initPaging();
        this.refresh();
    }

    final List<TaskNode> getFilteredTaskNodes() {
        return this.filteredTaskNodes;
    }

    final List<TaskNode> getTaskNodes() {
        return this.taskNodes;
    }

    public final boolean isRefresh() {
        return this.refresh;
    }

    public final void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getChangedTaskCount() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = 0;
            for (TaskNode taskNode : this.filteredTaskNodes) {
                if (taskNode.getTask().getStatus() != IssueStatusProvider.Status.INCOMING_MODIFIED && taskNode.getTask().getStatus() != IssueStatusProvider.Status.INCOMING_NEW && taskNode.getTask().getStatus() != IssueStatusProvider.Status.CONFLICT) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getFilteredTaskCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.filteredTaskNodes != null ? this.filteredTaskNodes.size() : 0;
        }
    }

    final void updateNodes() {
        this.updateNodes(this.getTasks(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateNodes(List<IssueImpl> tasks) {
        Object object = this.LOCK;
        synchronized (object) {
            DashboardViewer dashboard = DashboardViewer.getInstance();
            AppliedFilters<TaskNode> appliedFilters = dashboard.getAppliedTaskFilters();
            this.removeTaskListeners();
            if (this.taskListener == null) {
                this.taskListener = new TaskListener();
            }
            if (this.taskNodes == null || this.taskNodes.isEmpty()) {
                this.taskNodes = new ArrayList<TaskNode>(tasks.size());
            }
            HashSet set = new HashSet<IssueImpl>(tasks);
            Iterator<TaskNode> it = this.taskNodes.iterator();
            while (it.hasNext()) {
                TaskNode n = it.next();
                if (set.contains(n.getTask())) continue;
                it.remove();
            }
            set = new HashSet(this.taskNodes.size());
            for (TaskNode n : this.taskNodes) {
                set.add(n.getTask());
            }
            for (IssueImpl task : tasks) {
                if (set.contains(task)) continue;
                TaskNode taskNode = new TaskNode(task, (TreeListNode)this);
                this.adjustTaskNode(taskNode);
                this.taskNodes.add(taskNode);
            }
            this.addTaskListeners();
            this.filteredTaskNodes = new ArrayList<TaskNode>(tasks.size());
            for (TaskNode taskNode : this.taskNodes) {
                if (!appliedFilters.isInFilter(taskNode)) continue;
                this.filteredTaskNodes.add(taskNode);
            }
        }
    }

    final String getTotalString() {
        String bundleName = DashboardViewer.getInstance().expandNodes() ? "LBL_Matches" : "LBL_Total";
        return this.getFilteredTaskCount() + " " + NbBundle.getMessage(TaskContainerNode.class, (String)bundleName);
    }

    final String getChangedString(int count) {
        return count + " " + NbBundle.getMessage(TaskContainerNode.class, (String)"LBL_Changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTaskListeners() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.taskListener != null && this.taskNodes != null) {
                for (TaskNode taskNode : this.taskNodes) {
                    taskNode.getTask().removePropertyChangeListener(this.taskListener);
                    taskNode.getTask().removeIssueStatusListener(this.taskListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaskListeners() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.taskListener != null && this.taskNodes != null) {
                for (TaskNode taskNode : this.taskNodes) {
                    taskNode.getTask().addPropertyChangeListener(this.taskListener);
                    taskNode.getTask().addIssueStatusListener(this.taskListener);
                }
            }
        }
    }

    final void showAdditionalPage() {
        ArrayList<TaskNode> list = new ArrayList<TaskNode>(1);
        list.add(this.filteredTaskNodes.get(this.getTaskCountToShow() - 1));
        ++this.pageCountShown;
        this.updateContentAndSelect(list);
    }

    protected List<TreeListNode> createChildren() {
        List<TaskNode> taskNodesToShow;
        List<TaskNode> filteredNodes = this.filteredTaskNodes;
        Comparator<TaskNode> specialComparator = this.getSpecialComparator();
        Collections.sort(filteredNodes, specialComparator == null ? TaskSorter.getInstance().getComparator() : specialComparator);
        boolean addShowNext = false;
        int taskCountToShow = this.getTaskCountToShow();
        if (!this.isTaskLimited() || filteredNodes.size() <= taskCountToShow) {
            taskNodesToShow = filteredNodes;
        } else {
            taskNodesToShow = new ArrayList<TaskNode>(filteredNodes.subList(0, taskCountToShow));
            addShowNext = true;
        }
        ArrayList<TaskNode> children = new ArrayList<TaskNode>(taskNodesToShow);
        if (addShowNext) {
            children.add((TaskNode)((Object)new ShowNextNode(this, Math.min(filteredNodes.size() - children.size(), this.pageSize))));
        }
        return children;
    }

    private int getTaskCountToShow() {
        return this.pageSize * this.pageCountShown;
    }

    final void initPaging() {
        this.pageSize = DashboardSettings.getInstance().isTasksLimit() ? DashboardSettings.getInstance().getTasksLimitValue() : Integer.MAX_VALUE;
        this.pageCountShown = 1;
    }

    final void handleError(Throwable throwable) {
        this.setRefresh(true);
        this.setError(true);
        DashboardViewer.LOG.log(Level.WARNING, "Tasks loading failed due to: {0}", throwable);
    }

    boolean isError() {
        return this.error;
    }

    void setError(boolean error) {
        this.error = error;
    }

    private void refilterTaskNodes() {
        DashboardViewer dashboard = DashboardViewer.getInstance();
        AppliedFilters<TaskNode> appliedFilters = dashboard.getAppliedTaskFilters();
        this.filteredTaskNodes.clear();
        for (TaskNode taskNode : this.taskNodes) {
            if (!appliedFilters.isInFilter(taskNode)) continue;
            this.filteredTaskNodes.add(taskNode);
        }
    }

    private class TaskListener
    implements PropertyChangeListener {
        private TaskListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CategoryNode cn;
            if (evt.getPropertyName().equals("issue.data_changed") || "issue.status_changed".equals(evt.getPropertyName())) {
                TaskContainerNode.this.refilterNodes.schedule(1000);
            } else if ("issue.deleted".equals(evt.getPropertyName()) && TaskContainerNode.this instanceof CategoryNode && !(cn = (CategoryNode)TaskContainerNode.this).getCategory().persist()) {
                TaskContainerNode.this.updateContent.schedule(500);
            }
        }
    }
}

