/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.settings.DashboardSettings;
import org.netbeans.modules.bugtracking.tasks.ActiveTaskPanel;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.CategoryNamePanel;
import org.netbeans.modules.bugtracking.tasks.CategoryPicker;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.FilterPanel;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardRefresher;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.bugtracking.tasks.filter.DisplayTextTaskFilter;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="DashboardTopComponent", iconBase="org/netbeans/modules/bugtracking/tasks/resources/dashboard.png", persistenceType=0)
public final class DashboardTopComponent
extends TopComponent {
    private static DashboardTopComponent instance;
    private final ComponentAdapter componentAdapter;
    private final JComponent dashboardComponent;
    private FilterDocumentListener filterListener;
    private CategoryNameDocumentListener categoryNameListener;
    private final Timer filterTimer;
    private ActiveTaskPanel activeTaskPanel;
    private final GridBagConstraints activeTaskConstrains;
    private FilterPanel filterPanel;
    private DisplayTextTaskFilter displayTextTaskFilter = null;
    private CategoryNamePanel categoryNamePanel;
    private NotifyDescriptor categoryNameDialog;
    private final DashboardActiveListener dashboardSelectionListener;
    private final Timer dashboardRefreshTime;
    private final DashboardRefresher refresher;
    private final DashboardViewer dashboard;
    private boolean firstStart = true;

    public DashboardTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(DashboardTopComponent.class, (String)"CTL_DashboardTopComponent"));
        this.filterTimer = new Timer(500, new FilterTimerListener());
        this.filterTimer.stop();
        this.refresher = DashboardRefresher.getInstance();
        this.filterPanel = FilterPanel.getInstance();
        if (this.filterListener == null) {
            this.filterListener = new FilterDocumentListener(this.filterTimer);
        }
        this.dashboard = DashboardViewer.getInstance();
        this.dashboardComponent = this.dashboard.getComponent();
        this.dashboardRefreshTime = new Timer(10000, new RefreshTimerListener());
        this.dashboardSelectionListener = new DashboardActiveListener();
        this.activeTaskConstrains = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 3, 0, 0), 0, 0);
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                if (DashboardTopComponent.this.activeTaskPanel != null) {
                    DashboardTopComponent.this.activeTaskPanel.setTaskNameText();
                }
            }
        };
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DashboardTopComponent.this.filterPanel != null) {
                    DashboardTopComponent.this.filterPanel.handleFilterShortcut();
                }
            }
        };
        this.getActionMap().put(DashboardUtils.getFindActionMapKey(), filterAction);
    }

    public static synchronized DashboardTopComponent getDefault() {
        if (instance == null) {
            instance = new DashboardTopComponent();
        }
        return instance;
    }

    public static synchronized DashboardTopComponent findInstance() {
        String PREFERRED_ID = "DashboardTopComponent";
        TopComponent win = WindowManager.getDefault().findTopComponent("DashboardTopComponent");
        if (win == null) {
            return DashboardTopComponent.getDefault();
        }
        if (win instanceof DashboardTopComponent) {
            return (DashboardTopComponent)win;
        }
        return DashboardTopComponent.getDefault();
    }

    public void activateTask(TaskNode taskNode) {
        this.deactivateTask();
        this.dashboard.setActiveTaskNode((TreeListNode)taskNode);
        if (this.activeTaskPanel == null) {
            this.activeTaskPanel = new ActiveTaskPanel(taskNode);
        } else {
            this.activeTaskPanel.setTaskNode(taskNode);
        }
        this.add(this.activeTaskPanel, this.activeTaskConstrains);
        this.repaint();
        this.validate();
    }

    public void deactivateTask() {
        if (this.activeTaskPanel != null) {
            this.dashboard.setActiveTaskNode(null);
            this.remove(this.activeTaskPanel);
            this.repaint();
            this.validate();
        }
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
    }

    public void componentOpened() {
        this.removeAll();
        this.filterPanel.addDocumentListener(this.filterListener);
        this.add(this.filterPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 1, 0, 0), 0, 0));
        this.add(this.dashboardComponent, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.8, 11, 1, new Insets(1, 1, 0, 0), 0, 0));
        RepositoryRegistry.getInstance().addPropertyChangeListener(this.dashboard);
        this.addComponentListener(this.componentAdapter);
        DashboardSettings.getInstance().addPropertyChangedListener(this.dashboard);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.dashboardSelectionListener);
        this.refresher.setRefreshEnabled(true);
        this.refresher.setDashboardBusy(false);
        if (this.firstStart) {
            this.firstStart = false;
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    DashboardTopComponent.this.dashboard.loadData();
                }
            });
        }
    }

    protected void componentClosed() {
        this.filterPanel.removeDocumentListener(this.filterListener);
        RepositoryRegistry.getInstance().removePropertyChangeListener(this.dashboard);
        DashboardSettings.getInstance().removePropertyChangedListener(this.dashboard);
        this.filterPanel.clear();
        this.dashboard.clearFilters();
        this.refresher.setRefreshEnabled(false);
        super.componentClosed();
    }

    public boolean requestFocusInWindow() {
        boolean b = super.requestFocusInWindow();
        if (this.dashboardComponent != null) {
            b = this.dashboardComponent.requestFocusInWindow();
        }
        return b;
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.dashboardComponent != null) {
            this.dashboardComponent.requestFocus();
        }
    }

    public Category createCategory() {
        this.categoryNamePanel = new CategoryNamePanel(NbBundle.getMessage(DashboardTopComponent.class, (String)"LBL_CreateCatNameLabel"), "");
        boolean confirm = this.showCategoryNameDialog(this.categoryNamePanel, NbBundle.getMessage(DashboardTopComponent.class, (String)"LBL_CreateCatTitle"));
        if (confirm) {
            Category category = new Category(this.categoryNamePanel.getCategoryName());
            this.dashboard.addCategory(category);
            return category;
        }
        return null;
    }

    public void renameCategory(Category category) {
        this.categoryNamePanel = new CategoryNamePanel(NbBundle.getMessage(DashboardTopComponent.class, (String)"LBL_RenameCatNameLabel"), category.getName());
        boolean confirm = this.showCategoryNameDialog(this.categoryNamePanel, NbBundle.getMessage(DashboardTopComponent.class, (String)"LBL_RenameCatTitle"));
        if (confirm) {
            this.dashboard.renameCategory(category, this.categoryNamePanel.getCategoryName());
        }
    }

    private boolean showCategoryNameDialog(CategoryNamePanel panel, String message) {
        this.categoryNameDialog = new NotifyDescriptor((Object)panel, message, 2, -1, null, NotifyDescriptor.OK_OPTION);
        this.categoryNameDialog.setValid(false);
        if (this.categoryNameListener == null) {
            this.categoryNameListener = new CategoryNameDocumentListener();
        }
        panel.addDocumentListener(this.categoryNameListener);
        boolean confirm = DialogDisplayer.getDefault().notify(this.categoryNameDialog) == NotifyDescriptor.OK_OPTION;
        panel.removeDocumentListener(this.categoryNameListener);
        return confirm;
    }

    public void addTask(IssueImpl issue) {
        this.addTask(new TaskNode(issue, null));
    }

    public void addTask(TaskNode ... taskNodes) {
        CategoryPicker picker = new CategoryPicker(taskNodes);
        final NotifyDescriptor nd = new NotifyDescriptor((Object)picker, NbBundle.getMessage(DashboardTopComponent.class, (String)"LBL_AddTaskToCat"), 2, -1, null, NotifyDescriptor.OK_OPTION);
        picker.setCategoryListener(new CategoryPicker.CategoryComboListener(){

            @Override
            public void comboItemsChanged(boolean categoryAvailable) {
                nd.setValid(categoryAvailable);
            }
        });
        nd.setValid(false);
        if (DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.OK_OPTION) {
            Category category = picker.getChosenCategory();
            this.dashboard.addTaskToCategory(category, taskNodes);
        }
    }

    public void select(RepositoryImpl repo, boolean activate) {
        this.dashboard.select(repo);
        if (activate) {
            this.activate();
        }
    }

    public void select(QueryImpl impl, boolean activate) {
        this.dashboard.select(impl, true);
        if (activate) {
            this.activate();
        }
    }

    public String getFilterText() {
        return this.filterPanel.getFilterText();
    }

    public void showTodayCategory() {
        this.filterPanel.showTodayCategory();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void activate() {
        if (!this.isOpened()) {
            this.open();
        }
        this.requestActive();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.bugtracking.tasks.DashboardTopComponent");
    }

    private class CategoryNameDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkCategoryName();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkCategoryName();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkCategoryName();
        }

        private void checkCategoryName() {
            if (DashboardTopComponent.this.categoryNamePanel.getCategoryName().isEmpty()) {
                DashboardTopComponent.this.categoryNamePanel.setErrorText(NbBundle.getMessage(DashboardTopComponent.class, (String)"LBL_CatNameErrEmpty"));
                DashboardTopComponent.this.categoryNameDialog.setValid(false);
            } else if (!DashboardTopComponent.this.dashboard.isCategoryNameUnique(DashboardTopComponent.this.categoryNamePanel.getCategoryName())) {
                DashboardTopComponent.this.categoryNamePanel.setErrorText(NbBundle.getMessage(DashboardTopComponent.class, (String)"LBL_CatNameErrUnique"));
                DashboardTopComponent.this.categoryNameDialog.setValid(false);
            } else {
                DashboardTopComponent.this.categoryNamePanel.setErrorText("");
                DashboardTopComponent.this.categoryNameDialog.setValid(true);
            }
        }
    }

    private class DashboardActiveListener
    implements PropertyChangeListener {
        private DashboardActiveListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("activated".equals(evt.getPropertyName())) {
                if (DashboardTopComponent.this == TopComponent.getRegistry().getActivated()) {
                    DashboardTopComponent.this.refresher.setDashboardBusy(true);
                    DashboardTopComponent.this.dashboardRefreshTime.stop();
                } else {
                    DashboardTopComponent.this.dashboardRefreshTime.restart();
                }
            }
        }
    }

    private class FilterDocumentListener
    implements DocumentListener {
        private Timer timer;

        public FilterDocumentListener(Timer timer) {
            this.timer = timer;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.timer.restart();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.timer.restart();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.timer.restart();
        }
    }

    private class FilterTimerListener
    implements ActionListener {
        private final RequestProcessor RP = new RequestProcessor(FilterTimerListener.class.getName());

        private FilterTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DashboardTopComponent.this.filterTimer) {
                DashboardTopComponent.this.filterTimer.stop();
                this.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!DashboardTopComponent.this.filterPanel.getFilterText().isEmpty()) {
                            DisplayTextTaskFilter newTaskFilter = new DisplayTextTaskFilter(DashboardTopComponent.this.filterPanel.getFilterText());
                            int hits = DashboardTopComponent.this.dashboard.updateTaskFilter(DashboardTopComponent.this.displayTextTaskFilter, newTaskFilter);
                            DashboardTopComponent.this.displayTextTaskFilter = newTaskFilter;
                            DashboardTopComponent.this.filterPanel.setHitsCount(hits);
                        } else {
                            if (DashboardTopComponent.this.displayTextTaskFilter != null) {
                                DashboardTopComponent.this.dashboard.removeTaskFilter(DashboardTopComponent.this.displayTextTaskFilter, true);
                                DashboardTopComponent.this.displayTextTaskFilter = null;
                            }
                            DashboardTopComponent.this.filterPanel.clear();
                        }
                    }
                });
            }
        }
    }

    private class RefreshTimerListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DashboardTopComponent.this.dashboardRefreshTime) {
                DashboardTopComponent.this.dashboardRefreshTime.stop();
                DashboardTopComponent.this.refresher.setDashboardBusy(false);
            }
        }
    }
}

