/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CategoryPicker
extends JPanel {
    private List<Category> categories;
    private final Action newCatAction;
    private CategoryComboListener listener;
    private final TaskNode[] taskNodes;
    private final DashboardViewer dashboardViewer = DashboardViewer.getInstance();
    private JButton btnNewCat;
    private JComboBox cbCategory;
    private JLabel jLabel1;

    public CategoryPicker(TaskNode ... taskNodes) {
        this.taskNodes = taskNodes;
        this.newCatAction = this.getNewCatAction();
        this.initComponents();
        this.initCombo();
    }

    public Category getChosenCategory() {
        return this.categories.get(this.cbCategory.getSelectedIndex());
    }

    public void setCategoryListener(CategoryComboListener listener) {
        this.listener = listener;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbCategory = new JComboBox();
        this.btnNewCat = new LinkButton("", this.newCatAction);
        this.jLabel1.setText(NbBundle.getMessage(CategoryPicker.class, (String)"CategoryPicker.jLabel1.text"));
        this.btnNewCat.setText(NbBundle.getMessage(CategoryPicker.class, (String)"LBL_New"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.cbCategory, -2, 193, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNewCat).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbCategory, -2, -1, -2).addComponent(this.btnNewCat)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private Action getNewCatAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Category category = DashboardTopComponent.findInstance().createCategory();
                if (category == null) {
                    return;
                }
                CategoryPicker.this.categories.add(category);
                CategoryPicker.this.initCombo();
                CategoryPicker.this.cbCategory.setSelectedItem(category.getName());
            }
        };
    }

    private void initCombo() {
        this.cbCategory.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(CategoryPicker.class, (String)"LBL_Loading")}));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                CategoryPicker.this.initCategories();
            }
        });
    }

    private void initCategories() throws MissingResourceException {
        TaskNode taskNode;
        this.categories = this.dashboardViewer.preloadCategories();
        if (this.taskNodes.length == 1 && (taskNode = this.taskNodes[0]).isCategorized()) {
            this.categories.remove(taskNode.getCategory());
        }
        String[] names = new String[this.categories.size()];
        int i = 0;
        boolean categoryAvailable = true;
        for (Category category : this.categories) {
            names[i++] = category.getName();
        }
        if (this.categories.isEmpty()) {
            names = new String[]{NbBundle.getMessage(CategoryPicker.class, (String)"LBL_NoCategoryAvailable")};
            categoryAvailable = false;
        }
        final String[] namesF = names;
        final boolean categoryAvailableF = categoryAvailable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CategoryPicker.this.cbCategory.setModel(new DefaultComboBoxModel<String>(namesF));
                if (CategoryPicker.this.listener != null) {
                    CategoryPicker.this.listener.comboItemsChanged(categoryAvailableF);
                }
            }
        });
    }

    public static interface CategoryComboListener {
        public void comboItemsChanged(boolean var1);
    }
}

