/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Query;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.team.TeamRepositories;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.IssueFinderUtils;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.openide.filesystems.FileObject;

public final class Util {
    private Util() {
    }

    public static void openIssue(Repository repository, String issueId) {
        IssueAction.openIssue(repository.getImpl(), issueId);
    }

    public static void openIssue(FileObject context, String issueId) {
        IssueAction.openIssue(context, issueId);
    }

    public static void selectQuery(Query query) {
        QueryImpl queryImpl = APIAccessor.IMPL.getImpl(query);
        DashboardTopComponent.findInstance().select(queryImpl, true);
    }

    public static void closeQuery(Query query) {
        QueryAction.closeQuery(APIAccessor.IMPL.getImpl(query));
    }

    public static void createNewQuery(Repository repository) {
        if (!Util.checkTeamLogin(repository)) {
            return;
        }
        QueryAction.createNewQuery(repository.getImpl());
    }

    public static void createNewQuery(Repository repository, boolean suggestedRepositoryOnly) {
        QueryAction.createNewQuery(APIAccessor.IMPL.getImpl(repository), suggestedRepositoryOnly);
    }

    public static void createNewIssue(Repository repository) {
        if (!Util.checkTeamLogin(repository)) {
            return;
        }
        IssueAction.createIssue(repository.getImpl());
    }

    public static void createIssue(Repository repository, String summary, String description) {
        repository.getImpl().createNewIssue(summary, description);
    }

    public static Repository createRepository() {
        RepositoryImpl repoImpl = BugtrackingUtil.createRepository(false);
        return repoImpl != null ? repoImpl.getRepository() : null;
    }

    public static Repository getTeamRepository(String url, String projectName) {
        RepositoryImpl impl = TeamRepositories.getInstance().getRepository(url, projectName);
        return impl != null ? impl.getRepository() : null;
    }

    public static void edit(Repository repository) {
        BugtrackingUtil.editRepository(repository);
    }

    public static int[] getIssueSpans(String text) {
        return IssueFinderUtils.getIssueSpans(text);
    }

    public static String getIssueId(String issueHyperlinkText) {
        return IssueFinderUtils.getIssueId(issueHyperlinkText);
    }

    public static List<Issue> getRecentIssues() {
        return Util.toIssues(BugtrackingManager.getInstance().getAllRecentIssues());
    }

    private static boolean checkTeamLogin(Repository repository) {
        return !repository.getImpl().isTeamRepository() || TeamAccessorUtils.isLoggedIn((String)repository.getUrl()) || !repository.getImpl().getConnectorId().toLowerCase().contains("jira") || TeamAccessorUtils.showLogin((String)repository.getUrl());
    }

    static List<Issue> toIssues(Collection<IssueImpl> c) {
        ArrayList<Issue> ret = new ArrayList<Issue>(c.size());
        for (IssueImpl i : c) {
            ret.add(i.getIssue());
        }
        return ret;
    }
}

