/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.awt;

import java.awt.event.ActionListener;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.tools.Diagnostic;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.awt.ActionReferences;
import org.openide.awt.ActionRegistration;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class ActionProcessor
extends LayerGeneratingProcessor {
    private static final String IDENTIFIER = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
    private static final Pattern FQN = Pattern.compile("(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)(?:[.](?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*))*");
    private static final String[] DEFAULT_COMPLETIONS = new String[]{"Menu", "Toolbars", "Shortcuts", "Loaders"};
    private Processor COMPLETIONS;

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hash = new HashSet<String>();
        hash.add(ActionRegistration.class.getCanonicalName());
        hash.add(ActionID.class.getCanonicalName());
        hash.add(ActionReference.class.getCanonicalName());
        hash.add(ActionReferences.class.getCanonicalName());
        return hash;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        if (annotation.getAnnotationType().asElement().getSimpleName().toString().contains(ActionReference.class.getSimpleName()) && member.getSimpleName().contentEquals("path")) {
            if (userText == null) {
                userText = "";
            }
            if (userText.startsWith("\"")) {
                userText = userText.substring(1);
            }
            HashSet<Completion> res = new HashSet<Completion>();
            for (String c : DEFAULT_COMPLETIONS) {
                if (!c.startsWith(userText)) continue;
                res.add(Completions.of("\"" + c + '/', NbBundle.getMessage(ActionProcessor.class, (String)("HINT_" + c))));
            }
            if (!res.isEmpty()) {
                return res;
            }
            if (this.COMPLETIONS == null) {
                String pathCompletions = System.getProperty(ActionReference.class.getName() + ".completion");
                if (pathCompletions != null) {
                    void var7_10;
                    ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    if (classLoader == null) {
                        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                    }
                    if (var7_10 == null) {
                        ClassLoader classLoader3 = ActionProcessor.class.getClassLoader();
                    }
                    try {
                        void var7_12;
                        this.COMPLETIONS = (Processor)Class.forName(pathCompletions, true, (ClassLoader)var7_12).newInstance();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        this.COMPLETIONS = this;
                    }
                } else {
                    return res;
                }
            }
            if (this.COMPLETIONS != null && this.COMPLETIONS != this) {
                this.COMPLETIONS.init(this.processingEnv);
                for (Completion completion : this.COMPLETIONS.getCompletions(element, annotation, member, userText)) {
                    res.add(completion);
                }
            }
            return res;
        }
        return Collections.emptyList();
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        ActionID id;
        TypeMirror actionListener = this.type(ActionListener.class);
        TypeMirror p1 = this.type(Presenter.Menu.class);
        TypeMirror p2 = this.type(Presenter.Toolbar.class);
        TypeMirror p3 = this.type(Presenter.Popup.class);
        TypeMirror caa = this.type(ContextAwareAction.class);
        TypeMirror dmc = this.type(DynamicMenuContent.class);
        for (Element element : roundEnv.getElementsAnnotatedWith(ActionRegistration.class)) {
            ActionReferences actionReferences;
            String key;
            String popupText;
            ActionRegistration ar = element.getAnnotation(ActionRegistration.class);
            if (ar == null) continue;
            ActionID aid = element.getAnnotation(ActionID.class);
            if (aid == null) {
                throw new LayerGenerationException("@ActionRegistration can only be used together with @ActionID annotation", element, this.processingEnv, (Annotation)ar);
            }
            if (aid.id() == null) continue;
            if (aid.category().startsWith("Actions/")) {
                throw new LayerGenerationException("@ActionID category() should not start with Actions/", element, this.processingEnv, (Annotation)aid, "category");
            }
            if (!FQN.matcher(aid.id()).matches()) {
                throw new LayerGenerationException("@ActionID id() must be valid fully qualified name", element, this.processingEnv, (Annotation)aid, "id");
            }
            String id2 = aid.id().replace('.', '-');
            LayerBuilder builder = this.layer(new Element[]{element});
            LayerBuilder.File f = builder.file("Actions/" + aid.category() + "/" + id2 + ".instance");
            f.bundlevalue("displayName", ar.displayName(), (Annotation)ar, "displayName");
            String menuText = ar.menuText();
            if (!menuText.isEmpty()) {
                f.bundlevalue("menuText", menuText, (Annotation)ar, "menuText");
            }
            if (!(popupText = ar.popupText()).isEmpty()) {
                f.bundlevalue("popupText", popupText, (Annotation)ar, "popupText");
            }
            boolean createDelegate = true;
            if (element.getKind() == ElementKind.FIELD) {
                VariableElement var = (VariableElement)element;
                TypeMirror stringType = this.type(String.class);
                if (!(element.asType() == stringType && element.getModifiers().contains((Object)Modifier.PUBLIC) && element.getModifiers().contains((Object)Modifier.STATIC) && element.getModifiers().contains((Object)Modifier.FINAL))) {
                    throw new LayerGenerationException("Only static string constant fields can be annotated", element, this.processingEnv, (Annotation)ar);
                }
                if (ar.key().length() != 0) {
                    throw new LayerGenerationException("When annotating field, one cannot define key()", element, this.processingEnv, (Annotation)ar, "key");
                }
                createDelegate = false;
                key = var.getConstantValue().toString();
            } else if (element.getKind() == ElementKind.CLASS) {
                if (!this.isAssignable(element.asType(), actionListener)) {
                    throw new LayerGenerationException("Class annotated with @ActionRegistration must implement java.awt.event.ActionListener!", element, this.processingEnv, (Annotation)ar);
                }
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException("Class has to be public", element, this.processingEnv, (Annotation)ar);
                }
                if (element.getEnclosingElement().getKind() == ElementKind.CLASS && !element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException("Inner class annotated with @ActionRegistration has to be static", element);
                }
                key = ar.key();
            } else {
                assert (element.getKind() == ElementKind.METHOD) : element;
                builder.instanceFile("dummy", null, ActionListener.class, (Annotation)ar, null);
                key = ar.key();
            }
            Boolean direct = null;
            AnnotationMirror arMirror = null;
            block3: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(ActionRegistration.class.getCanonicalName())) continue;
                arMirror = annotationMirror;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("lazy")) continue;
                    direct = (Boolean)entry.getValue().getValue() == false;
                    assert (direct == !ar.lazy());
                    continue block3;
                }
            }
            if (direct == null) {
                if (element.getKind() == ElementKind.FIELD) {
                    direct = false;
                } else {
                    TypeMirror type = element.getKind() == ElementKind.CLASS ? element.asType() : ((ExecutableElement)element).getReturnType();
                    direct = this.isAssignable(type, p1) || this.isAssignable(type, p2) || this.isAssignable(type, p3) || this.isAssignable(type, caa) || this.isAssignable(type, dmc);
                    if (direct.booleanValue()) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Should explicitly specify lazy attribute", element);
                    }
                }
            }
            if (direct.booleanValue()) {
                if (key.length() != 0) {
                    throw new LayerGenerationException("Cannot specify key and use eager registration", element, this.processingEnv, (Annotation)ar, "key");
                }
                if (!ar.iconBase().isEmpty()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "iconBase unused on eager registrations", element, arMirror);
                }
                f.instanceAttribute("instanceCreate", Action.class);
            } else {
                if (key.length() == 0) {
                    f.methodvalue("instanceCreate", "org.openide.awt.Actions", "alwaysEnabled");
                } else {
                    f.methodvalue("instanceCreate", "org.openide.awt.Actions", "callback");
                    if (createDelegate) {
                        f.methodvalue("fallback", "org.openide.awt.Actions", "alwaysEnabled");
                    }
                    f.stringvalue("key", key);
                }
                if (createDelegate) {
                    try {
                        f.instanceAttribute("delegate", ActionListener.class, (Annotation)ar, null);
                    }
                    catch (LayerGenerationException ex) {
                        this.generateContext(element, f, ar);
                    }
                }
                if (ar.iconBase().length() > 0) {
                    builder.validateResource(ar.iconBase(), element, (Annotation)ar, "iconBase", true);
                    f.stringvalue("iconBase", ar.iconBase());
                }
                f.boolvalue("noIconInMenu", !ar.iconInMenu());
                if (ar.asynchronous()) {
                    f.boolvalue("asynchronous", true);
                }
                if (ar.surviveFocusChange()) {
                    f.boolvalue("surviveFocusChange", true);
                }
            }
            f.write();
            ActionReference aref = element.getAnnotation(ActionReference.class);
            if (aref != null) {
                this.processReferences(element, aref, aid);
            }
            if ((actionReferences = element.getAnnotation(ActionReferences.class)) == null) continue;
            for (ActionReference actionReference : actionReferences.value()) {
                this.processReferences(element, actionReference, aid);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ActionReference.class)) {
            ActionReference ref;
            if (element.getAnnotation(ActionRegistration.class) != null || (ref = element.getAnnotation(ActionReference.class)) == null) continue;
            id = element.getAnnotation(ActionID.class);
            if (id != null) {
                this.processReferences(element, ref, id);
                continue;
            }
            throw new LayerGenerationException("Don't use @ActionReference without @ActionID", element, this.processingEnv, (Annotation)ref);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ActionReferences.class)) {
            ActionReferences refs;
            if (element.getAnnotation(ActionRegistration.class) != null || (refs = element.getAnnotation(ActionReferences.class)) == null) continue;
            id = element.getAnnotation(ActionID.class);
            if (id != null) {
                for (ActionReference actionReference : refs.value()) {
                    if (!actionReference.id().id().isEmpty() || !actionReference.id().category().isEmpty()) {
                        throw new LayerGenerationException("Don't specify additional id=@ActionID(...) when using @ActionID on the element", element, this.processingEnv, (Annotation)actionReference.id());
                    }
                    this.processReferences(element, actionReference, id);
                }
                continue;
            }
            for (ActionReference actionReference : refs.value()) {
                if (actionReference.id().id().isEmpty() || actionReference.id().category().isEmpty()) {
                    throw new LayerGenerationException("Specify real id=@ActionID(...)", element, this.processingEnv, (Annotation)actionReference.id());
                }
                this.processReferences(element, actionReference, actionReference.id());
            }
        }
        return true;
    }

    private TypeMirror type(Class<?> type) {
        TypeElement e = this.processingEnv.getElementUtils().getTypeElement(type.getCanonicalName());
        return e == null ? null : e.asType();
    }

    private void generateContext(Element e, LayerBuilder.File f, ActionRegistration ar) throws LayerGenerationException {
        ExecutableElement ee = null;
        ExecutableElement candidate = null;
        for (ExecutableElement element : ElementFilter.constructorsIn(e.getEnclosedElements())) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            candidate = element;
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (ee != null) {
                throw new LayerGenerationException("Only one public constructor allowed", e, this.processingEnv, (Annotation)ar);
            }
            ee = element;
        }
        if (ee == null || ee.getParameters().size() != 1) {
            if (candidate != null) {
                throw new LayerGenerationException("Constructor has to be public with one argument", candidate);
            }
            throw new LayerGenerationException("Constructor must have one argument", (Element)ee);
        }
        VariableElement ve = ee.getParameters().get(0);
        TypeMirror ctorType = ve.asType();
        switch (ctorType.getKind()) {
            case ARRAY: {
                String elemType = ((ArrayType)ctorType).getComponentType().toString();
                throw new LayerGenerationException("Use List<" + elemType + "> rather than " + elemType + "[] in constructor", e, this.processingEnv, (Annotation)ar);
            }
            case DECLARED: {
                break;
            }
            default: {
                throw new LayerGenerationException("Must use SomeType (or List<SomeType>) in constructor, not " + (Object)((Object)ctorType.getKind()));
            }
        }
        DeclaredType dt = (DeclaredType)ctorType;
        String dtName = this.processingEnv.getElementUtils().getBinaryName((TypeElement)dt.asElement()).toString();
        if ("java.util.List".equals(dtName)) {
            if (dt.getTypeArguments().isEmpty()) {
                throw new LayerGenerationException("Use List<SomeType>", (Element)ee);
            }
            f.stringvalue("type", this.binaryName(dt.getTypeArguments().get(0)));
            f.methodvalue("delegate", "org.openide.awt.Actions", "inject");
            f.stringvalue("injectable", this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString());
            f.stringvalue("selectionType", "ANY");
            f.methodvalue("instanceCreate", "org.openide.awt.Actions", "context");
            return;
        }
        if (!dt.getTypeArguments().isEmpty()) {
            throw new LayerGenerationException("No type parameters allowed in ", (Element)ee);
        }
        f.stringvalue("type", this.binaryName(ctorType));
        f.methodvalue("delegate", "org.openide.awt.Actions", "inject");
        f.stringvalue("injectable", this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString());
        f.stringvalue("selectionType", "EXACTLY_ONE");
        f.methodvalue("instanceCreate", "org.openide.awt.Actions", "context");
    }

    private String binaryName(TypeMirror t) {
        Element e = this.processingEnv.getTypeUtils().asElement(t);
        if (e != null && (e.getKind().isClass() || e.getKind().isInterface())) {
            return this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
        }
        return t.toString();
    }

    private boolean isAssignable(TypeMirror first, TypeMirror snd) {
        if (snd == null) {
            return false;
        }
        return this.processingEnv.getTypeUtils().isAssignable(first, snd);
    }

    private void processReferences(Element e, ActionReference ref, ActionID aid) throws LayerGenerationException {
        KeyStroke[] stroke;
        if (!(ref.id().category().isEmpty() || ref.id().id().isEmpty() || aid.id().equals(ref.id().id()) && aid.category().equals(ref.id().category()))) {
            throw new LayerGenerationException("Can't specify id() attribute when @ActionID provided on the element", e, this.processingEnv, (Annotation)aid);
        }
        String name = ref.name();
        if (name.isEmpty()) {
            name = aid.id().replace('.', '-');
        }
        if (ref.path().startsWith("Shortcuts") && (stroke = Utilities.stringToKeys((String)name)) == null) {
            throw new LayerGenerationException("Registrations in Shortcuts folder need to represent a key. Specify value for 'name' attribute.\nSee org.openide.util.Utilities.stringToKeys for possible values. Current name=\"" + name + "\" is not valid.\n", e, this.processingEnv, (Annotation)ref, "path");
        }
        LayerBuilder.File f = this.layer(new Element[]{e}).file(ref.path() + "/" + name + ".shadow");
        f.stringvalue("originalFile", "Actions/" + aid.category() + "/" + aid.id().replace('.', '-') + ".instance");
        f.position(ref.position());
        f.write();
        if (ref.separatorAfter() != Integer.MAX_VALUE) {
            if (ref.position() == Integer.MAX_VALUE || ref.position() >= ref.separatorAfter()) {
                throw new LayerGenerationException("separatorAfter() must be greater than position()", e, this.processingEnv, (Annotation)ref);
            }
            LayerBuilder.File after = this.layer(new Element[]{e}).file(ref.path() + "/" + name + "-separatorAfter.instance");
            after.newvalue("instanceCreate", JSeparator.class.getName());
            after.position(ref.separatorAfter());
            after.write();
        }
        if (ref.separatorBefore() != Integer.MAX_VALUE) {
            if (ref.position() == Integer.MAX_VALUE || ref.position() <= ref.separatorBefore()) {
                throw new LayerGenerationException("separatorBefore() must be lower than position()", e, this.processingEnv, (Annotation)ref);
            }
            LayerBuilder.File before = this.layer(new Element[]{e}).file(ref.path() + "/" + name + "-separatorBefore.instance");
            before.newvalue("instanceCreate", JSeparator.class.getName());
            before.position(ref.separatorBefore());
            before.write();
        }
    }
}

