/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.model;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.html.angular.model.DirectiveConvention;
import org.netbeans.modules.html.angular.model.DirectiveType;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;

public enum Directive {
    app(false, true, true, false, DirectiveType.angularModule),
    bind(true, true, true, false, DirectiveType.expression),
    bindHtml(true, true, false, false, DirectiveType.expression),
    bindHtmlUnsafe(true, true, true, false, DirectiveType.expression),
    bindTemplate(true, true, true, false, DirectiveType.expression),
    blur(true, true, true, false, DirectiveType.expression),
    change(true, true, false, true, DirectiveType.expression),
    checked(true, true, false, false, DirectiveType.expression),
    _class(true, true, true, false, DirectiveType.expression),
    classEven(true, true, true, false, DirectiveType.expression),
    classOdd(true, true, true, false, DirectiveType.expression),
    click(true, true, true, false, DirectiveType.expression),
    cloak(true, true, true, false, DirectiveType.noValue),
    controller(true, true, true, false, DirectiveType.expression),
    copy(true, true, true, false, DirectiveType.expression),
    csp(false, true, true, false, DirectiveType.noValue),
    cut(true, true, true, false, DirectiveType.expression),
    dblclick(true, true, true, false, DirectiveType.expression),
    disabled(true, true, false, false, DirectiveType.expression),
    focus(true, true, false, false, DirectiveType.expression),
    form(true, true, true, true, DirectiveType.string),
    hide(true, true, true, false, DirectiveType.expression),
    href(true, true, false, false, DirectiveType.template),
    _if(true, true, true, true, DirectiveType.expression),
    include(true, true, true, true, DirectiveType.expression),
    init(true, true, true, false, DirectiveType.expression),
    keydown(true, true, true, false, DirectiveType.expression),
    keypress(true, true, true, false, DirectiveType.expression),
    keyup(true, true, true, false, DirectiveType.expression),
    list(true, true, true, false, DirectiveType.string),
    model(true, true, true, false, DirectiveType.expression),
    mousedown(true, true, true, false, DirectiveType.expression),
    mouseenter(true, true, true, false, DirectiveType.expression),
    mouseleave(true, true, true, false, DirectiveType.expression),
    mousemove(true, true, true, false, DirectiveType.expression),
    mouseover(true, true, true, false, DirectiveType.expression),
    mouseup(true, true, true, false, DirectiveType.expression),
    multiple(true, true, false, false, DirectiveType.expression),
    nonBindable(true, true, true, false, DirectiveType.noValue),
    open(true, true, true, false, DirectiveType.expression),
    paste(true, true, true, false, DirectiveType.expression),
    pluralize(true, true, false, true, DirectiveType.noValue),
    readonly(false, true, false, false, DirectiveType.expression),
    repeat(true, true, true, false, DirectiveType.repeatExpression),
    selected(false, true, false, false, DirectiveType.expression),
    show(true, true, true, false, DirectiveType.expression),
    src(true, true, false, false, DirectiveType.template),
    srcset(true, true, false, false, DirectiveType.template),
    style(true, true, true, false, DirectiveType.expression),
    submit(true, true, true, false, DirectiveType.expression),
    _switch(true, true, false, true, DirectiveType.expression),
    _switch_when(true, true, false, true, DirectiveType.string),
    _switch_default(true, true, false, true, DirectiveType.string),
    transclude(true, true, true, false, DirectiveType.noValue),
    value(true, true, false, false, DirectiveType.string),
    view(false, true, true, true, DirectiveType.noValue);

    private static final String PARTIAL_DOC_URL_BASE = "http://code.angularjs.org/1.2.12/docs/partials/api/ng.directive:";
    private static final String PARTIAL_SUFFIX = ".html";
    private static final String DOC_URL_BASE = "http://docs.angularjs.org/api/ng.directive:";
    public static final String NAME_PREFIX = "ng";
    private static final Map<String, Directive> NAMES2DIRECTIVES;
    private boolean attributeValueTypicallyUsed;
    private boolean useAsAttribute;
    private boolean useAsClass;
    private boolean useAsElement;
    private DirectiveType type;

    public static boolean isAngularAttribute(Attribute attribute) {
        return DirectiveConvention.getConvention(attribute.unqualifiedName()) != null;
    }

    public static Directive getDirective(String attributeName) {
        return NAMES2DIRECTIVES.get(attributeName);
    }

    private Directive(boolean attributeValueRequired, boolean useAsAttribute, boolean useAsClass, boolean useAsElement, DirectiveType type) {
        this.attributeValueTypicallyUsed = attributeValueRequired;
        this.useAsAttribute = useAsAttribute;
        this.useAsClass = useAsClass;
        this.useAsElement = useAsElement;
        this.type = type;
    }

    public String getExternalDocumentationURL() {
        return DOC_URL_BASE + NAME_PREFIX + Character.toUpperCase(this.getCleanCoreName().charAt(0)) + this.getCleanCoreName().substring(1);
    }

    public String getExternalDocumentationURL_partial() {
        return PARTIAL_DOC_URL_BASE + NAME_PREFIX + Character.toUpperCase(this.getCleanCoreName().charAt(0)) + this.getCleanCoreName().substring(1) + PARTIAL_SUFFIX;
    }

    @NonNull
    public String getAttributeName(DirectiveConvention convention) {
        return convention.createFQN(this);
    }

    String getAttributeCoreName(char delimiter) {
        StringBuilder sb = new StringBuilder();
        String name = this.getCleanCoreName();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(delimiter);
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String getCleanCoreName() {
        String name;
        String string = name = this.name().charAt(0) == '_' ? this.name().substring(1) : this.name();
        if (name.indexOf(95) > -1) {
            name = name.replace('_', '-');
        }
        return name;
    }

    public boolean isAttributeValueTypicallyUsed() {
        return this.attributeValueTypicallyUsed;
    }

    public boolean canUseAsAttribute() {
        return this.useAsAttribute;
    }

    public boolean canUseAsClass() {
        return this.useAsClass;
    }

    public boolean canUseAsElement() {
        return this.useAsElement;
    }

    public DirectiveType getType() {
        return this.type;
    }

    static {
        NAMES2DIRECTIVES = new HashMap<String, Directive>();
        for (Directive d : Directive.values()) {
            for (DirectiveConvention dc : DirectiveConvention.values()) {
                NAMES2DIRECTIVES.put(d.getAttributeName(dc), d);
            }
        }
    }
}

