/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.model;

import java.util.Collection;
import java.util.regex.Pattern;
import org.netbeans.modules.html.angular.Utils;
import org.netbeans.modules.html.angular.index.AngularJsIndexer;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;

public class AngularWhenInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("(.)*\\.when");
    public static final String TEMPLATE_URL_PROP = "templateUrl";
    public static final String CONTROLLER_PROP = "controller";

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public void intercept(String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (!AngularJsIndexer.isScannerThread()) {
            return;
        }
        for (FunctionArgument arg : args) {
            if (arg.getKind() != FunctionArgument.Kind.ANONYMOUS_OBJECT) continue;
            JsObject aObject = (JsObject)arg.getValue();
            JsObject url = aObject.getProperty(TEMPLATE_URL_PROP);
            JsObject controller = aObject.getProperty(CONTROLLER_PROP);
            FileObject fo = globalObject.getFileObject();
            if (url == null || controller == null || fo == null) continue;
            String content = null;
            Source source = Source.create((FileObject)fo);
            content = source.createSnapshot().getText().toString();
            if (content == null) continue;
            String template = this.getStringValueAt(content, url.getOffsetRange().getStart());
            String controllerName = this.getStringValueAt(content, controller.getOffsetRange().getStart());
            if (template == null || controllerName == null) continue;
            AngularJsIndexer.addTemplateController(fo.toURI(), Utils.cutQueryFromTemplateUrl(template), controllerName);
        }
    }

    private String getStringValueAt(String content, int offset) {
        String value = "";
        STATE state = STATE.INIT;
        while (state != STATE.END && offset < content.length()) {
            char ch = content.charAt(offset);
            block0 : switch (state) {
                case INIT: {
                    switch (ch) {
                        case ':': {
                            state = STATE.INVALUE;
                            break block0;
                        }
                        case '\"': 
                        case '\'': 
                        case ',': 
                        case '}': {
                            state = STATE.END;
                            break block0;
                        }
                    }
                    break;
                }
                case INVALUE: {
                    switch (ch) {
                        case '\"': 
                        case '\'': {
                            state = STATE.INSTRING;
                            value = "";
                            break block0;
                        }
                        case '\n': 
                        case '\r': 
                        case ',': 
                        case '}': {
                            state = STATE.END;
                            break block0;
                        }
                        case ' ': {
                            break block0;
                        }
                    }
                    value = value + ch;
                    break;
                }
                case INSTRING: {
                    switch (ch) {
                        case '\"': 
                        case '\'': {
                            state = STATE.END;
                            break block0;
                        }
                    }
                    value = value + ch;
                }
            }
            ++offset;
        }
        return value;
    }

    private static enum STATE {
        INIT,
        INSTRING,
        INVALUE,
        END;

    }
}

