/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.model;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.html.angular.index.AngularJsController;
import org.netbeans.modules.html.angular.index.AngularJsIndexer;
import org.netbeans.modules.html.angular.model.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsArray;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.openide.filesystems.FileObject;

public class AngularModuleInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("(.)*\\.controller");

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public void intercept(String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        JsObject controllerDecl;
        if (!AngularJsIndexer.isScannerThread()) {
            return;
        }
        String controllerName = null;
        String functionName = null;
        int functionOffset = -1;
        int nameOffset = -1;
        for (FunctionArgument fArgument : args) {
            block0 : switch (fArgument.getKind()) {
                case STRING: {
                    if (controllerName != null) break;
                    controllerName = (String)fArgument.getValue();
                    nameOffset = fArgument.getOffset();
                    break;
                }
                case ARRAY: {
                    JsArray array = (JsArray)fArgument.getValue();
                    for (TypeUsage type : array.getTypesInArray()) {
                        if (!type.getType().equals("Function")) continue;
                        functionName = type.getType();
                        functionOffset = type.getOffset();
                        break block0;
                    }
                    break;
                }
                case REFERENCE: {
                    functionName = (String)((List)fArgument.getValue()).get(0);
                    functionOffset = fArgument.getOffset();
                    break;
                }
            }
            if (controllerName == null || functionName == null) continue;
            break;
        }
        if (controllerName != null && functionName != null && (controllerDecl = ModelUtils.findJsObject(globalObject, functionOffset)) != null && controllerDecl instanceof JsFunction && controllerDecl.isDeclared()) {
            String fqnOfController = controllerDecl.getFullyQualifiedName();
            FileObject fo = globalObject.getFileObject();
            if (fo != null) {
                AngularJsIndexer.addController(fo.toURI(), new AngularJsController(controllerName, fqnOfController, fo.toURL(), nameOffset));
            }
        }
    }
}

