/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.index;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.angular.index.AngularJsController;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class AngularJsIndex {
    private static final Logger LOGGER = Logger.getLogger(AngularJsIndex.class.getSimpleName());
    private static final Map<Project, AngularJsIndex> INDEXES = new WeakHashMap<Project, AngularJsIndex>();
    private final QuerySupport querySupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AngularJsIndex get(Project project) throws IOException {
        if (project == null) {
            return null;
        }
        Map<Project, AngularJsIndex> map = INDEXES;
        synchronized (map) {
            AngularJsIndex index = INDEXES.get(project);
            if (index == null) {
                index = new AngularJsIndex(project);
                INDEXES.put(project, index);
            }
            return index;
        }
    }

    private AngularJsIndex(Project project) throws IOException {
        Collection sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
        this.querySupport = QuerySupport.forRoots((String)"angular", (int)3, (FileObject[])sourceRoots.toArray(new FileObject[0]));
    }

    public Collection<AngularJsController> getControllers(String name, boolean exact) {
        Collection result = null;
        try {
            result = this.querySupport.query("cont", name, QuerySupport.Kind.PREFIX, new String[]{"cont"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            ArrayList<AngularJsController> controllers = new ArrayList<AngularJsController>();
            for (IndexResult indexResult : result) {
                Collection<AngularJsController> possibleControllers = this.createControllers(indexResult);
                for (AngularJsController controller : possibleControllers) {
                    if ((!exact || !controller.getName().equals(name)) && (exact || !controller.getName().startsWith(name))) continue;
                    controllers.add(controller);
                }
            }
            return controllers;
        }
        return Collections.emptyList();
    }

    public Collection<String> getControllersForTemplate(@NonNull URI uri) {
        Collection result = null;
        try {
            result = this.querySupport.query("tc", "", QuerySupport.Kind.PREFIX, new String[]{"tc"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            String path = uri.toString();
            HashSet<String> controllers = new HashSet<String>();
            for (IndexResult indexResult : result) {
                String[] values;
                for (String value : values = indexResult.getValues("tc")) {
                    int index = value.indexOf(58);
                    String fileNamePart = value.substring(0, index);
                    if (!path.endsWith(fileNamePart)) continue;
                    controllers.add(value.substring(index + 1));
                }
            }
            return controllers;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection<AngularJsController> createControllers(IndexResult indexResult) {
        String[] values = indexResult.getValues("cont");
        ArrayList<AngularJsController> result = new ArrayList<AngularJsController>(values.length);
        for (String value : values) {
            if (value == null || value.isEmpty() || value.indexOf(58) <= 0) continue;
            String[] split = value.split(":");
            int offset = Integer.parseInt(split[2]);
            result.add(new AngularJsController(split[0], split[1], indexResult.getFile().toURL(), offset));
        }
        return result;
    }
}

